/*
 * Decompiled with CFR 0.152.
 */
package io.druid.storage.s3;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.base.Preconditions;
import io.druid.segment.loading.LoadSpec;
import io.druid.segment.loading.SegmentLoadingException;
import io.druid.storage.s3.S3DataSegmentPuller;
import java.io.File;

@JsonTypeName(value="s3_zip")
public class S3LoadSpec
implements LoadSpec {
    @JsonProperty(value="bucket")
    private final String bucket;
    @JsonProperty(value="key")
    private final String key;
    private final S3DataSegmentPuller puller;

    @JsonCreator
    public S3LoadSpec(@JacksonInject S3DataSegmentPuller puller, @JsonProperty(value="bucket") String bucket, @JsonProperty(value="key") String key) {
        Preconditions.checkNotNull((Object)bucket);
        Preconditions.checkNotNull((Object)key);
        this.bucket = bucket;
        this.key = key;
        this.puller = puller;
    }

    public LoadSpec.LoadSpecResult loadSegment(File outDir) throws SegmentLoadingException {
        return new LoadSpec.LoadSpecResult(this.puller.getSegmentFiles(new S3DataSegmentPuller.S3Coords(this.bucket, this.key), outDir).size());
    }
}

