/*
 * Decompiled with CFR 0.152.
 */
package io.druid.storage.s3;

import com.google.common.base.Optional;
import com.google.common.base.Throwables;
import com.google.common.io.ByteSource;
import com.google.inject.Inject;
import com.metamx.common.logger.Logger;
import io.druid.storage.s3.S3TaskLogsConfig;
import io.druid.storage.s3.S3Utils;
import io.druid.tasklogs.TaskLogs;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.Callable;
import org.jets3t.service.ServiceException;
import org.jets3t.service.StorageService;
import org.jets3t.service.impl.rest.httpclient.RestS3Service;
import org.jets3t.service.model.StorageObject;

public class S3TaskLogs
implements TaskLogs {
    private static final Logger log = new Logger(S3TaskLogs.class);
    private final StorageService service;
    private final S3TaskLogsConfig config;

    @Inject
    public S3TaskLogs(S3TaskLogsConfig config, RestS3Service service) {
        this.config = config;
        this.service = service;
    }

    public Optional<ByteSource> streamTaskLog(String taskid, final long offset) throws IOException {
        final String taskKey = this.getTaskLogKey(taskid);
        try {
            final StorageObject objectDetails = this.service.getObjectDetails(this.config.getS3Bucket(), taskKey, null, null, null, null);
            return Optional.of((Object)new ByteSource(){

                public InputStream openStream() throws IOException {
                    try {
                        long end = objectDetails.getContentLength() - 1L;
                        long start = offset > 0L && offset < objectDetails.getContentLength() ? offset : (offset < 0L && -1L * offset < objectDetails.getContentLength() ? objectDetails.getContentLength() + offset : 0L);
                        return S3TaskLogs.this.service.getObject(S3TaskLogs.this.config.getS3Bucket(), taskKey, null, null, new String[]{objectDetails.getETag()}, null, Long.valueOf(start), Long.valueOf(end)).getDataInputStream();
                    }
                    catch (ServiceException e) {
                        throw new IOException(e);
                    }
                }
            });
        }
        catch (ServiceException e) {
            if (404 == e.getResponseCode() || "NoSuchKey".equals(e.getErrorCode()) || "NoSuchBucket".equals(e.getErrorCode())) {
                return Optional.absent();
            }
            throw new IOException(String.format("Failed to stream logs from: %s", taskKey), e);
        }
    }

    public void pushTaskLog(String taskid, final File logFile) throws IOException {
        final String taskKey = this.getTaskLogKey(taskid);
        log.info("Pushing task log %s to: %s", new Object[]{logFile, taskKey});
        try {
            S3Utils.retryS3Operation(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    StorageObject object = new StorageObject(logFile);
                    object.setKey(taskKey);
                    S3TaskLogs.this.service.putObject(S3TaskLogs.this.config.getS3Bucket(), object);
                    return null;
                }
            });
        }
        catch (Exception e) {
            Throwables.propagateIfInstanceOf((Throwable)e, IOException.class);
            throw Throwables.propagate((Throwable)e);
        }
    }

    private String getTaskLogKey(String taskid) {
        return String.format("%s/%s/log", this.config.getS3Prefix(), taskid);
    }
}

