/*
 * Decompiled with CFR 0.152.
 */
package io.druid.storage.s3;

import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.metamx.common.RetryUtils;
import io.druid.segment.loading.DataSegmentPusherUtil;
import io.druid.timeline.DataSegment;
import java.io.IOException;
import java.util.concurrent.Callable;
import org.jets3t.service.ServiceException;
import org.jets3t.service.impl.rest.httpclient.RestS3Service;
import org.jets3t.service.model.S3Object;

public class S3Utils {
    private static final Joiner JOINER = Joiner.on((String)"/").skipNulls();
    public static final Predicate<Throwable> S3RETRY = new Predicate<Throwable>(){

        public boolean apply(Throwable e) {
            if (e == null) {
                return false;
            }
            if (e instanceof IOException) {
                return true;
            }
            if (e instanceof ServiceException) {
                return S3Utils.isServiceExceptionRecoverable((ServiceException)e);
            }
            return this.apply(e.getCause());
        }
    };

    public static void closeStreamsQuietly(S3Object s3Obj) {
        if (s3Obj == null) {
            return;
        }
        try {
            s3Obj.closeDataInputStream();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static boolean isServiceExceptionRecoverable(ServiceException ex) {
        boolean isIOException = ex.getCause() instanceof IOException;
        boolean isTimeout = "RequestTimeout".equals(ex.getErrorCode());
        return isIOException || isTimeout;
    }

    public static <T> T retryS3Operation(Callable<T> f) throws Exception {
        int maxTries = 10;
        return (T)RetryUtils.retry(f, S3RETRY, (int)10);
    }

    public static boolean isObjectInBucket(RestS3Service s3Client, String bucketName, String objectKey) throws ServiceException {
        try {
            s3Client.getObjectDetails(bucketName, objectKey);
        }
        catch (ServiceException e) {
            if (404 == e.getResponseCode() || "NoSuchKey".equals(e.getErrorCode()) || "NoSuchBucket".equals(e.getErrorCode())) {
                return false;
            }
            if ("AccessDenied".equals(e.getErrorCode())) {
                return true;
            }
            throw e;
        }
        return true;
    }

    public static String constructSegmentPath(String baseKey, DataSegment segment) {
        return JOINER.join((Object)(baseKey.isEmpty() ? null : baseKey), (Object)DataSegmentPusherUtil.getStorageDir((DataSegment)segment), new Object[0]) + "/index.zip";
    }

    public static String descriptorPathForSegmentPath(String s3Path) {
        return s3Path.substring(0, s3Path.lastIndexOf("/")) + "/descriptor.json";
    }
}

