/*
 * Decompiled with CFR 0.152.
 */
package io.druid.https;

import com.google.common.base.Throwables;
import com.google.inject.Inject;
import com.google.inject.Provider;
import io.druid.https.SSLClientConfig;
import io.druid.java.util.emitter.EmittingLogger;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;

public class SSLContextProvider
implements Provider<SSLContext> {
    private static final EmittingLogger log = new EmittingLogger(SSLContextProvider.class);
    private SSLClientConfig config;

    @Inject
    public SSLContextProvider(SSLClientConfig config) {
        this.config = config;
    }

    public SSLContext get() {
        log.info("Creating SslContext for https client using config [%s]", new Object[]{this.config});
        SSLContext sslContext = null;
        try {
            sslContext = SSLContext.getInstance(this.config.getProtocol() == null ? "TLSv1.2" : this.config.getProtocol());
            KeyStore keyStore = KeyStore.getInstance(this.config.getTrustStoreType() == null ? KeyStore.getDefaultType() : this.config.getTrustStoreType());
            keyStore.load(new FileInputStream(this.config.getTrustStorePath()), this.config.getTrustStorePasswordProvider().getPassword().toCharArray());
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(this.config.getTrustStoreAlgorithm() == null ? TrustManagerFactory.getDefaultAlgorithm() : this.config.getTrustStoreAlgorithm());
            trustManagerFactory.init(keyStore);
            sslContext.init(null, trustManagerFactory.getTrustManagers(), null);
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            Throwables.propagate((Throwable)e);
        }
        return sslContext;
    }
}

