/*
 * Licensed to Metamarkets Group Inc. (Metamarkets) under one
 * or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. Metamarkets licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package io.druid.java.util.common.guava.nary;

import java.util.Comparator;
import java.util.Iterator;


/**
 */
public class SortedMergeIterable<InType, OutType> implements Iterable<OutType>
{
  public static <InType, OutType> SortedMergeIterable<InType, OutType> create(
      Iterable<InType> lhs,
      Iterable<InType> rhs,
      Comparator<InType> comparator,
      BinaryFn<InType, InType, OutType> fn
  )
  {
    return new SortedMergeIterable<>(lhs, rhs, comparator, fn);
  }

  private final Iterable<InType> lhs;
  private final Iterable<InType> rhs;
  private final Comparator<InType> comparator;
  private final BinaryFn<InType, InType, OutType> fn;

  public SortedMergeIterable(
      Iterable<InType> lhs,
      Iterable<InType> rhs,
      Comparator<InType> comparator,
      BinaryFn<InType, InType, OutType> fn
  )
  {
    this.lhs = lhs;
    this.rhs = rhs;
    this.comparator = comparator;
    this.fn = fn;
  }

  @Override
  public Iterator<OutType> iterator()
  {
    return SortedMergeIterator.create(lhs.iterator(), rhs.iterator(), comparator, fn);
  }
}
