/*
 * Decompiled with CFR 0.152.
 */
package io.druid.java.util.emitter.core;

import com.google.common.primitives.UnsignedInts;
import java.util.concurrent.atomic.AtomicLong;

public class ConcurrentTimeCounter {
    private final AtomicLong timeSumAndCount = new AtomicLong(0L);
    private final AtomicLong max = new AtomicLong(-1L);
    private final AtomicLong min = new AtomicLong(-1L);

    public void add(int time) {
        long x = 0x100000000L | (long)time;
        this.timeSumAndCount.addAndGet(x);
        this.updateMax(time);
        this.updateMin(time);
    }

    private void updateMax(int time) {
        long max;
        do {
            if ((max = this.max.get()) < 0L || (int)max < time) continue;
            return;
        } while (!this.max.compareAndSet(max, UnsignedInts.toLong((int)time)));
    }

    private void updateMin(int time) {
        long min;
        do {
            if ((min = this.min.get()) < 0L || (int)min > time) continue;
            return;
        } while (!this.min.compareAndSet(min, UnsignedInts.toLong((int)time)));
    }

    public long getTimeSumAndCountAndReset() {
        return this.timeSumAndCount.getAndSet(0L);
    }

    public int getAndResetMaxTime() {
        long max = this.max.getAndSet(-1L);
        return max >= 0L ? (int)max : 0;
    }

    public int getAndResetMinTime() {
        long min = this.min.getAndSet(-1L);
        return min >= 0L ? (int)min : 0;
    }

    public static int timeSum(long timeSumAndCount) {
        return (int)timeSumAndCount;
    }

    public static int count(long timeSumAndCount) {
        return (int)(timeSumAndCount >> 32);
    }
}

