/*
 * Decompiled with CFR 0.152.
 */
package io.dwpbank.movewp3.microservice.security.autoconfiguration.client;

import io.dwpbank.movewp3.microservice.security.autoconfiguration.client.OAuth2Aware;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.jackson.JacksonAutoConfiguration;
import org.springframework.boot.autoconfigure.security.oauth2.client.servlet.OAuth2ClientAutoConfiguration;
import org.springframework.boot.autoconfigure.web.reactive.function.client.WebClientAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import org.springframework.security.oauth2.client.AuthorizedClientServiceOAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientProvider;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientProviderBuilder;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.client.web.reactive.function.client.ServletOAuth2AuthorizedClientExchangeFilterFunction;
import org.springframework.web.reactive.function.client.WebClient;

@Configuration
@ConditionalOnBean(value={ClientRegistrationRepository.class})
@AutoConfigureAfter(value={WebClientAutoConfiguration.class, OAuth2ClientAutoConfiguration.class, JacksonAutoConfiguration.class})
public class WebClientOauth2AutoConfiguration {
    @Bean
    @Scope(value="prototype")
    @OAuth2Aware
    public WebClient.Builder oauth2AwareWebClientBuilder(WebClient.Builder webClientBuilder, ServletOAuth2AuthorizedClientExchangeFilterFunction oAuth2ExchangeFilterFunction) {
        WebClient.Builder oauth2WebClientBuilder = webClientBuilder.clone();
        oauth2WebClientBuilder.apply(oAuth2ExchangeFilterFunction.oauth2Configuration());
        return oauth2WebClientBuilder;
    }

    @Bean
    public OAuth2AuthorizedClientManager authorizedClientManager(ClientRegistrationRepository clientRegistrationRepository, OAuth2AuthorizedClientService clientService) {
        OAuth2AuthorizedClientProvider authorizedClientProvider = OAuth2AuthorizedClientProviderBuilder.builder().clientCredentials().build();
        AuthorizedClientServiceOAuth2AuthorizedClientManager authorizedClientManager = new AuthorizedClientServiceOAuth2AuthorizedClientManager(clientRegistrationRepository, clientService);
        authorizedClientManager.setAuthorizedClientProvider(authorizedClientProvider);
        return authorizedClientManager;
    }

    @Bean
    public static ServletOAuth2AuthorizedClientExchangeFilterFunction oAuth2ExchangeFilterFunction(@Value(value="${io.dwpbank.microservice-security-autoconfiguration.default-client-registration-id:default}") String defaultClientRegistrationId, OAuth2AuthorizedClientManager authorizedClientManager, ClientRegistrationRepository clientRegistrationRepository) {
        ServletOAuth2AuthorizedClientExchangeFilterFunction filterFunction = new ServletOAuth2AuthorizedClientExchangeFilterFunction(authorizedClientManager);
        if (clientRegistrationRepository.findByRegistrationId(defaultClientRegistrationId) == null) {
            throw new IllegalArgumentException(String.format("The configured OAuth2 default client registration id \"%s\" does not seem to exist. Please make sure that the client registration id of your OAuth2 client configured below spring.security.oauth2.client.registration matches what you have configured for io.dwpbank.microservice-security-autoconfiguration.default-client-registration-id", defaultClientRegistrationId));
        }
        filterFunction.setDefaultClientRegistrationId(defaultClientRegistrationId);
        return filterFunction;
    }
}

