/*
 * Decompiled with CFR 0.152.
 */
package io.dwpbank.movewp3.microservice.security.autoconfiguration.server;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.security.oauth2.client.servlet.OAuth2ClientAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.servlet.util.matcher.MvcRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.web.servlet.handler.HandlerMappingIntrospector;

@Configuration
@EnableWebSecurity
@AutoConfigureBefore(value={OAuth2ClientAutoConfiguration.class})
@ConditionalOnProperty(value={"spring.security.oauth2.resourceserver.jwt.jwk-set-uri"})
@ConditionalOnWebApplication
public class WebSecurityAutoConfiguration {
    @Value(value="${io.dwpbank.movewp3.microservice.security.allowlist:/actuator/**}")
    private List<String> allowlist;
    @Autowired
    private HandlerMappingIntrospector introspector;

    @Bean
    SecurityFilterChain oidcResourceServerSecurityFilterChain(HttpSecurity http) throws Exception {
        ((HttpSecurity)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)http.authorizeHttpRequests().requestMatchers((RequestMatcher[])this.allowlist.stream().map(path -> new MvcRequestMatcher(this.introspector, path)).toArray(MvcRequestMatcher[]::new))).permitAll().anyRequest()).authenticated().and()).oauth2ResourceServer().jwt();
        http.sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS);
        http.csrf().disable();
        return (SecurityFilterChain)http.build();
    }
}

