/*
 * Decompiled with CFR 0.152.
 */
package io.dyte.webrtc;

import android.util.Log;
import io.dyte.webrtc.ApplicationContextHolder;
import io.dyte.webrtc.CameraVideoCapturerException;
import io.dyte.webrtc.Constrain;
import io.dyte.webrtc.FacingMode;
import io.dyte.webrtc.VideoCaptureController;
import io.dyte.webrtc.VideoTrackConstraints;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.SafeContinuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.DebugProbesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.webrtc.Camera2Enumerator;
import org.webrtc.CameraEnumerationAndroid;
import org.webrtc.CameraVideoCapturer;
import org.webrtc.Size;
import org.webrtc.VideoCapturer;
import org.webrtc.VideoSource;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u001cB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0011\u0010\u0014\u001a\u00020\u000fH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0015J\u0019\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\bH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0017J\u0016\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001d"}, d2={"Lio/dyte/webrtc/CameraVideoCaptureController;", "Lio/dyte/webrtc/VideoCaptureController;", "constraints", "Lio/dyte/webrtc/VideoTrackConstraints;", "videoSource", "Lorg/webrtc/VideoSource;", "(Lio/dyte/webrtc/VideoTrackConstraints;Lorg/webrtc/VideoSource;)V", "device", "", "enumerator", "Lorg/webrtc/Camera2Enumerator;", "tag", "createVideoCapturer", "Lorg/webrtc/VideoCapturer;", "selectDevice", "", "selectFps", "", "selectVideoSize", "Lorg/webrtc/Size;", "switchCamera", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "deviceId", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "switchCameraHandler", "Lorg/webrtc/CameraVideoCapturer$CameraSwitchHandler;", "continuation", "Lkotlin/coroutines/Continuation;", "CameraEventsHandler", "webrtc_release"})
public final class CameraVideoCaptureController
extends VideoCaptureController {
    @NotNull
    private final VideoTrackConstraints constraints;
    @NotNull
    private final String tag;
    @NotNull
    private final Camera2Enumerator enumerator;
    @Nullable
    private String device;

    public CameraVideoCaptureController(@NotNull VideoTrackConstraints constraints, @NotNull VideoSource videoSource) {
        Intrinsics.checkNotNullParameter((Object)constraints, (String)"constraints");
        Intrinsics.checkNotNullParameter((Object)videoSource, (String)"videoSource");
        super(videoSource);
        this.constraints = constraints;
        this.tag = "CameraCaptureController";
        this.enumerator = new Camera2Enumerator(ApplicationContextHolder.Companion.getContext());
    }

    @Override
    @NotNull
    public VideoCapturer createVideoCapturer() {
        this.selectDevice();
        CameraVideoCapturer cameraVideoCapturer = this.enumerator.createCapturer(this.device, (CameraVideoCapturer.CameraEventsHandler)new CameraEventsHandler());
        Intrinsics.checkNotNullExpressionValue((Object)cameraVideoCapturer, (String)"enumerator.createCapture\u2026e, CameraEventsHandler())");
        return (VideoCapturer)cameraVideoCapturer;
    }

    /*
     * Unable to fully structure code
     */
    private final void selectDevice() {
        block4: {
            deviceId = this.constraints.getDeviceId();
            v0 = this.constraints.getFacingMode();
            if ((v0 != null ? v0.getExact() : null) == FacingMode.User) ** GOTO lbl-1000
            v1 = this.constraints.getFacingMode();
            if ((v1 != null ? v1.getIdeal() : null) == FacingMode.User) lbl-1000:
            // 2 sources

            {
                v2 = true;
            } else {
                v2 = false;
            }
            isFrontFacing = v2;
            searchCriteria = deviceId != null ? (Function1)new Function1<String, Boolean>(deviceId){
                final /* synthetic */ String $deviceId;
                {
                    this.$deviceId = $deviceId;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull String it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return Intrinsics.areEqual((Object)it, (Object)this.$deviceId);
                }
            } : (Function1)new Function1<String, Boolean>(this, isFrontFacing){
                final /* synthetic */ CameraVideoCaptureController this$0;
                final /* synthetic */ boolean $isFrontFacing;
                {
                    this.this$0 = $receiver;
                    this.$isFrontFacing = $isFrontFacing;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull String it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return CameraVideoCaptureController.access$getEnumerator$p(this.this$0).isFrontFacing(it) == this.$isFrontFacing;
                }
            };
            v3 = this.enumerator.getDeviceNames();
            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"enumerator.deviceNames");
            var4_4 = v3;
            var9_5 = this;
            $i$f$firstOrNull = false;
            for (void element$iv : $this$firstOrNull$iv) {
                if (!((Boolean)searchCriteria.invoke((Object)element$iv)).booleanValue()) continue;
                v4 = element$iv;
                break block4;
            }
            v4 = null;
        }
        v5 = v4;
        if (v5 == null) {
            throw CameraVideoCapturerException.Companion.notFound(this.constraints);
        }
        var9_5.device = v5;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Size selectVideoSize() {
        List sizes;
        List list;
        List formats;
        int n;
        Object object;
        int requestedWidth;
        int n2;
        Constrain<Integer> constrain = this.constraints.getWidth();
        if (constrain != null && (constrain = constrain.getExact()) != null) {
            n2 = (Integer)((Object)constrain);
        } else {
            Constrain<Integer> constrain2 = this.constraints.getWidth();
            Integer n3 = constrain2 != null ? constrain2.getIdeal() : null;
            n2 = requestedWidth = n3 != null ? n3 : 1280;
        }
        if ((object = this.constraints.getHeight()) != null && (object = ((Constrain)object).getExact()) != null) {
            n = (Integer)object;
        } else {
            Constrain<Integer> constrain3 = this.constraints.getHeight();
            Integer n4 = constrain3 != null ? constrain3.getIdeal() : null;
            n = n4 != null ? n4 : 720;
        }
        int requestedHeight = n;
        List list2 = formats = this.enumerator.getSupportedFormats(this.device);
        if (list2 != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = list2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                CameraEnumerationAndroid.CaptureFormat captureFormat = (CameraEnumerationAndroid.CaptureFormat)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new Size(it.width, it.height));
            }
            list = (List)destination$iv$iv;
        } else {
            list = sizes = CollectionsKt.emptyList();
        }
        if (sizes.isEmpty()) {
            throw CameraVideoCapturerException.Companion.notFound(this.constraints);
        }
        Size size = CameraEnumerationAndroid.getClosestSupportedSize((List)sizes, (int)requestedWidth, (int)requestedHeight);
        Intrinsics.checkNotNullExpressionValue((Object)size, (String)"getClosestSupportedSize(\u2026requestedHeight\n        )");
        return size;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int selectFps() {
        List framerates;
        List list;
        List formats;
        Object object = this.constraints.getFrameRate();
        if (object == null || (object = ((Constrain)object).getExact()) == null) {
            Constrain<Double> constrain = this.constraints.getFrameRate();
            object = constrain != null ? constrain.getIdeal() : null;
            if (object == null) {
                object = 30;
            }
        }
        Constrain<Double> requestedFps = object;
        List list2 = formats = this.enumerator.getSupportedFormats(this.device);
        if (list2 != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = list2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                CameraEnumerationAndroid.CaptureFormat captureFormat = (CameraEnumerationAndroid.CaptureFormat)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.framerate);
            }
            list = (List)destination$iv$iv;
        } else {
            list = framerates = CollectionsKt.emptyList();
        }
        if (framerates.isEmpty()) {
            throw CameraVideoCapturerException.Companion.notFound(this.constraints);
        }
        int requestedFpsInt = ((Number)((Object)requestedFps)).intValue();
        CameraEnumerationAndroid.CaptureFormat.FramerateRange range = CameraEnumerationAndroid.getClosestSupportedFramerateRange((List)framerates, (int)requestedFpsInt);
        return RangesKt.coerceIn((int)requestedFpsInt, (int)(range.min / 1000), (int)(range.max / 1000));
    }

    @Nullable
    public final Object switchCamera(@NotNull Continuation<? super Unit> $completion) {
        VideoCapturer videoCapturer2 = this.getVideoCapturer();
        Intrinsics.checkNotNull((Object)videoCapturer2, (String)"null cannot be cast to non-null type org.webrtc.CameraVideoCapturer");
        CameraVideoCapturer cameraCapturer = (CameraVideoCapturer)videoCapturer2;
        Continuation<? super Unit> continuation = $completion;
        SafeContinuation safeContinuation = new SafeContinuation(IntrinsicsKt.intercepted(continuation));
        Continuation it = (Continuation)safeContinuation;
        boolean bl = false;
        cameraCapturer.switchCamera(this.switchCameraHandler((Continuation<? super Unit>)it));
        Object object = safeContinuation.getOrThrow();
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            DebugProbesKt.probeCoroutineSuspended($completion);
        }
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public final Object switchCamera(@NotNull String deviceId, @NotNull Continuation<? super Unit> $completion) {
        VideoCapturer videoCapturer2 = this.getVideoCapturer();
        Intrinsics.checkNotNull((Object)videoCapturer2, (String)"null cannot be cast to non-null type org.webrtc.CameraVideoCapturer");
        CameraVideoCapturer cameraCapturer = (CameraVideoCapturer)videoCapturer2;
        Continuation<? super Unit> continuation = $completion;
        SafeContinuation safeContinuation = new SafeContinuation(IntrinsicsKt.intercepted(continuation));
        Continuation it = (Continuation)safeContinuation;
        boolean bl = false;
        cameraCapturer.switchCamera(this.switchCameraHandler((Continuation<? super Unit>)it), deviceId);
        Object object = safeContinuation.getOrThrow();
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            DebugProbesKt.probeCoroutineSuspended($completion);
        }
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final CameraVideoCapturer.CameraSwitchHandler switchCameraHandler(Continuation<? super Unit> continuation) {
        return new CameraVideoCapturer.CameraSwitchHandler(this, continuation){
            final /* synthetic */ CameraVideoCaptureController this$0;
            final /* synthetic */ Continuation<Unit> $continuation;
            {
                this.this$0 = $receiver;
                this.$continuation = $continuation;
            }

            public void onCameraSwitchDone(boolean isFrontFacing) {
                Log.d((String)CameraVideoCaptureController.access$getTag$p(this.this$0), (String)("Camera switched. isFront: " + isFrontFacing));
                this.$continuation.resumeWith(Result.constructor-impl((Object)Unit.INSTANCE));
            }

            public void onCameraSwitchError(@Nullable String error) {
                String message = "Switch camera failed: " + error;
                Log.e((String)CameraVideoCaptureController.access$getTag$p(this.this$0), (String)message);
                this.$continuation.resumeWith(Result.constructor-impl((Object)ResultKt.createFailure((Throwable)new CameraVideoCapturerException(message))));
            }
        };
    }

    public static final /* synthetic */ Camera2Enumerator access$getEnumerator$p(CameraVideoCaptureController $this) {
        return $this.enumerator;
    }

    public static final /* synthetic */ String access$getTag$p(CameraVideoCaptureController $this) {
        return $this.tag;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\b\u0010\u0005\u001a\u00020\u0004H\u0016J\u0010\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\bH\u0016J\b\u0010\f\u001a\u00020\u0004H\u0016\u00a8\u0006\r"}, d2={"Lio/dyte/webrtc/CameraVideoCaptureController$CameraEventsHandler;", "Lorg/webrtc/CameraVideoCapturer$CameraEventsHandler;", "(Lio/dyte/webrtc/CameraVideoCaptureController;)V", "onCameraClosed", "", "onCameraDisconnected", "onCameraError", "errorDescription", "", "onCameraFreezed", "onCameraOpening", "cameraId", "onFirstFrameAvailable", "webrtc_release"})
    private final class CameraEventsHandler
    implements CameraVideoCapturer.CameraEventsHandler {
        public void onCameraError(@NotNull String errorDescription) {
            Intrinsics.checkNotNullParameter((Object)errorDescription, (String)"errorDescription");
            CameraVideoCaptureController.this.getVideoCapturerErrorListener().onError("Error: " + errorDescription);
        }

        public void onCameraDisconnected() {
            CameraVideoCaptureController.this.getVideoCapturerErrorListener().onError("Camera disconnected");
        }

        public void onCameraFreezed(@NotNull String errorDescription) {
            Intrinsics.checkNotNullParameter((Object)errorDescription, (String)"errorDescription");
            CameraVideoCaptureController.this.getVideoCapturerErrorListener().onError("Camera freezed: " + errorDescription);
        }

        public void onCameraOpening(@NotNull String cameraId) {
            Intrinsics.checkNotNullParameter((Object)cameraId, (String)"cameraId");
        }

        public void onFirstFrameAvailable() {
        }

        public void onCameraClosed() {
        }
    }
}

