/*
 * Decompiled with CFR 0.152.
 */
package io.dyte.webrtc;

import android.content.Context;
import androidx.core.content.ContextCompat;
import io.dyte.webrtc.ApplicationContextHolder;
import io.dyte.webrtc.AudioStreamTrack;
import io.dyte.webrtc.CameraPermissionException;
import io.dyte.webrtc.CameraVideoCaptureController;
import io.dyte.webrtc.MediaDeviceInfo;
import io.dyte.webrtc.MediaDeviceKind;
import io.dyte.webrtc.MediaDevices;
import io.dyte.webrtc.MediaDevicesKt;
import io.dyte.webrtc.MediaStream;
import io.dyte.webrtc.MediaStreamConstraints;
import io.dyte.webrtc.MediaStreamConstraintsBuilder;
import io.dyte.webrtc.RecordAudioPermissionException;
import io.dyte.webrtc.VideoStreamTrack;
import io.dyte.webrtc.VideoTrackConstraints;
import io.dyte.webrtc.WebRtc;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.webrtc.AudioSource;
import org.webrtc.AudioTrack;
import org.webrtc.Camera2Enumerator;
import org.webrtc.MediaConstraints;
import org.webrtc.VideoSource;
import org.webrtc.VideoTrack;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0002J\b\u0010\u0005\u001a\u00020\u0004H\u0002J\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\tJ\u0011\u0010\n\u001a\u00020\u000bH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\tJ*\u0010\f\u001a\u00020\u000b2\u0017\u0010\r\u001a\u0013\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00040\u000e\u00a2\u0006\u0002\b\u0010H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0011J\u0011\u0010\u0012\u001a\u00020\u0013H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\t\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0014"}, d2={"Lio/dyte/webrtc/MediaDevicesImpl;", "Lio/dyte/webrtc/MediaDevices;", "()V", "checkCameraPermission", "", "checkRecordAudioPermission", "enumerateDevices", "", "Lio/dyte/webrtc/MediaDeviceInfo;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getDisplayMedia", "Lio/dyte/webrtc/MediaStream;", "getUserMedia", "streamConstraints", "Lkotlin/Function1;", "Lio/dyte/webrtc/MediaStreamConstraintsBuilder;", "Lkotlin/ExtensionFunctionType;", "(Lkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "supportsDisplayMedia", "", "webrtc_release"})
final class MediaDevicesImpl
implements MediaDevices {
    @NotNull
    public static final MediaDevicesImpl INSTANCE = new MediaDevicesImpl();

    private MediaDevicesImpl() {
    }

    @Override
    @Nullable
    public Object getUserMedia(@NotNull Function1<? super MediaStreamConstraintsBuilder, Unit> streamConstraints, @NotNull Continuation<? super MediaStream> $completion) {
        MediaStream mediaStream;
        MediaStreamConstraintsBuilder it = new MediaStreamConstraintsBuilder();
        boolean bl = false;
        streamConstraints.invoke((Object)it);
        MediaStreamConstraints constraints = it.getConstraints$webrtc_release();
        AudioStreamTrack audioTrack = null;
        if (constraints.getAudio() != null) {
            Object v;
            Object k;
            Collection collection;
            Map.Entry entry;
            Map.Entry<Object, Object> item$iv$iv;
            Map<Object, ?> $this$mapTo$iv$iv;
            Map<Object, ?> $this$map$iv;
            this.checkRecordAudioPermission();
            MediaConstraints $this$getUserMedia_u24lambda_u243 = bl = new MediaConstraints();
            boolean bl2 = false;
            Map<Object, ?> map2 = MediaDevicesKt.toMandatoryMap(constraints.getAudio());
            List list = $this$getUserMedia_u24lambda_u243.mandatory;
            boolean $i$f$map = false;
            void var12_18 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            Iterator<Map.Entry<Object, Object>> iterator = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = item$iv$iv = iterator.next();
                collection = destination$iv$iv;
                boolean bl3 = false;
                k = entry.getKey();
                v = entry.getValue();
                collection.add(new MediaConstraints.KeyValuePair(String.valueOf(k), String.valueOf(v)));
            }
            list.addAll((List)destination$iv$iv);
            $this$map$iv = MediaDevicesKt.toOptionalMap(constraints.getAudio());
            list = $this$getUserMedia_u24lambda_u243.optional;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList($this$map$iv.size());
            $i$f$mapTo = false;
            iterator = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = item$iv$iv = iterator.next();
                collection = destination$iv$iv;
                boolean bl4 = false;
                k = entry.getKey();
                v = entry.getValue();
                collection.add(new MediaConstraints.KeyValuePair(String.valueOf(k), String.valueOf(v)));
            }
            list.addAll((List)destination$iv$iv);
            MediaConstraints mediaConstraints = bl;
            AudioSource audioSource = WebRtc.INSTANCE.getPeerConnectionFactory$webrtc_release().createAudioSource(mediaConstraints);
            AudioTrack androidTrack = WebRtc.INSTANCE.getPeerConnectionFactory$webrtc_release().createAudioTrack(UUID.randomUUID().toString(), audioSource);
            Intrinsics.checkNotNullExpressionValue((Object)androidTrack, (String)"androidTrack");
            audioTrack = new AudioStreamTrack(androidTrack, audioSource);
        }
        VideoStreamTrack videoTrack = null;
        if (constraints.getVideo() != null) {
            this.checkCameraPermission();
            VideoSource videoSource = WebRtc.INSTANCE.getPeerConnectionFactory$webrtc_release().createVideoSource(false);
            VideoTrackConstraints videoTrackConstraints = constraints.getVideo();
            Intrinsics.checkNotNullExpressionValue((Object)videoSource, (String)"videoSource");
            CameraVideoCaptureController videoCaptureController = new CameraVideoCaptureController(videoTrackConstraints, videoSource);
            VideoTrack androidTrack = WebRtc.INSTANCE.getPeerConnectionFactory$webrtc_release().createVideoTrack(UUID.randomUUID().toString(), videoSource);
            Intrinsics.checkNotNullExpressionValue((Object)androidTrack, (String)"androidTrack");
            videoTrack = new VideoStreamTrack(androidTrack, videoCaptureController);
        }
        org.webrtc.MediaStream localMediaStream = WebRtc.INSTANCE.getPeerConnectionFactory$webrtc_release().createLocalMediaStream(UUID.randomUUID().toString());
        MediaStream $this$getUserMedia_u24lambda_u244 = mediaStream = new MediaStream(localMediaStream, null, 2, null);
        boolean bl5 = false;
        if (audioTrack != null) {
            $this$getUserMedia_u24lambda_u244.addTrack(audioTrack);
        }
        if (videoTrack != null) {
            $this$getUserMedia_u24lambda_u244.addTrack(videoTrack);
        }
        return mediaStream;
    }

    @Override
    @Nullable
    public Object getDisplayMedia(@NotNull Continuation<? super MediaStream> $completion) {
        String string = "Not yet implemented for Android platform";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @Override
    @Nullable
    public Object supportsDisplayMedia(@NotNull Continuation<? super Boolean> $completion) {
        return Boxing.boxBoolean((boolean)false);
    }

    private final void checkRecordAudioPermission() {
        int result = ContextCompat.checkSelfPermission((Context)ApplicationContextHolder.Companion.getContext(), (String)"android.permission.RECORD_AUDIO");
        if (result == -1) {
            throw new RecordAudioPermissionException();
        }
    }

    private final void checkCameraPermission() {
        int result = ContextCompat.checkSelfPermission((Context)ApplicationContextHolder.Companion.getContext(), (String)"android.permission.CAMERA");
        if (result == -1) {
            throw new CameraPermissionException();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Object enumerateDevices(@NotNull Continuation<? super List<MediaDeviceInfo>> $completion) {
        void $this$mapTo$iv$iv;
        Camera2Enumerator enumerator = new Camera2Enumerator(ApplicationContextHolder.Companion.getContext());
        String[] stringArray = enumerator.getDeviceNames();
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"enumerator.deviceNames");
        Object[] $this$map$iv = stringArray;
        boolean $i$f$map = false;
        Object[] objectArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            collection.add(new MediaDeviceInfo((String)it, (String)it, MediaDeviceKind.VideoInput));
        }
        return (List)destination$iv$iv;
    }

    @Override
    @Nullable
    public Object getUserMedia(boolean audio2, boolean video2, @NotNull Continuation<? super MediaStream> $completion) {
        return MediaDevices.DefaultImpls.getUserMedia(this, audio2, video2, $completion);
    }
}

