/*
 * Decompiled with CFR 0.152.
 */
package io.dyte.webrtc;

import io.dyte.webrtc.MediaStreamTrack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.webrtc.AudioTrack;
import org.webrtc.VideoTrack;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u001b\b\u0000\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\tJ\u0010\u0010\u0015\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0004\u001a\u00020\u0005J\u0006\u0010\u0016\u001a\u00020\u0013J\u000e\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\tR\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0018"}, d2={"Lio/dyte/webrtc/MediaStream;", "", "android", "Lorg/webrtc/MediaStream;", "id", "", "(Lorg/webrtc/MediaStream;Ljava/lang/String;)V", "_tracks", "", "Lio/dyte/webrtc/MediaStreamTrack;", "getAndroid", "()Lorg/webrtc/MediaStream;", "getId", "()Ljava/lang/String;", "tracks", "", "getTracks", "()Ljava/util/List;", "addTrack", "", "track", "getTrackById", "release", "removeTrack", "webrtc_release"})
public final class MediaStream {
    @Nullable
    private final org.webrtc.MediaStream android;
    @NotNull
    private final String id;
    @NotNull
    private final List<MediaStreamTrack> _tracks;
    @NotNull
    private final List<MediaStreamTrack> tracks;

    public MediaStream(@Nullable org.webrtc.MediaStream android, @NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.android = android;
        this.id = id;
        this._tracks = new ArrayList();
        this.tracks = this._tracks;
    }

    public /* synthetic */ MediaStream(org.webrtc.MediaStream mediaStream, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            org.webrtc.MediaStream mediaStream2 = mediaStream;
            String string2 = mediaStream2 != null ? mediaStream2.getId() : null;
            if (string2 == null) {
                String string3 = UUID.randomUUID().toString();
                string2 = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"randomUUID().toString()");
            }
            string = string2;
        }
        this(mediaStream, string);
    }

    @Nullable
    public final org.webrtc.MediaStream getAndroid() {
        return this.android;
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    @NotNull
    public final List<MediaStreamTrack> getTracks() {
        return this.tracks;
    }

    public final void addTrack(@NotNull MediaStreamTrack track) {
        Intrinsics.checkNotNullParameter((Object)track, (String)"track");
        org.webrtc.MediaStream mediaStream = this.android;
        if (mediaStream != null) {
            boolean bl;
            org.webrtc.MediaStream it = mediaStream;
            boolean bl2 = false;
            org.webrtc.MediaStreamTrack mediaStreamTrack = track.getAndroid();
            if (mediaStreamTrack instanceof AudioTrack) {
                bl = it.addTrack((AudioTrack)track.getAndroid());
            } else if (mediaStreamTrack instanceof VideoTrack) {
                bl = it.addTrack((VideoTrack)track.getAndroid());
            } else {
                throw new IllegalStateException(("Unknown MediaStreamTrack kind: " + (Object)((Object)track.getKind())).toString());
            }
        }
        ((Collection)this._tracks).add(track);
    }

    @Nullable
    public final MediaStreamTrack getTrackById(@NotNull String id) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Iterable $this$firstOrNull$iv = this.tracks;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                MediaStreamTrack it = (MediaStreamTrack)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getId(), (Object)id)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    public final void removeTrack(@NotNull MediaStreamTrack track) {
        Intrinsics.checkNotNullParameter((Object)track, (String)"track");
        org.webrtc.MediaStream mediaStream = this.android;
        if (mediaStream != null) {
            boolean bl;
            org.webrtc.MediaStream it = mediaStream;
            boolean bl2 = false;
            org.webrtc.MediaStreamTrack mediaStreamTrack = track.getAndroid();
            if (mediaStreamTrack instanceof AudioTrack) {
                bl = it.removeTrack((AudioTrack)track.getAndroid());
            } else if (mediaStreamTrack instanceof VideoTrack) {
                bl = it.removeTrack((VideoTrack)track.getAndroid());
            } else {
                throw new IllegalStateException(("Unknown MediaStreamTrack kind: " + (Object)((Object)track.getKind())).toString());
            }
        }
        ((Collection)this._tracks).remove(track);
    }

    public final void release() {
        block1: {
            Iterable $this$forEach$iv = this.tracks;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                MediaStreamTrack p0 = (MediaStreamTrack)element$iv;
                boolean bl = false;
                p0.stop();
            }
            org.webrtc.MediaStream mediaStream = this.android;
            if (mediaStream == null) break block1;
            mediaStream.dispose();
        }
    }
}

