/*
 * Decompiled with CFR 0.152.
 */
package io.dyte.webrtc;

import io.dyte.webrtc.MediaStreamTrackKind;
import io.dyte.webrtc.MediaStreamTrackState;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.webrtc.MediaStreamTrack;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u001f\u001a\u00020\u0007H\u0002J\u0010\u0010 \u001a\u00020!2\u0006\u0010\f\u001a\u00020\u000bH$J\b\u0010\"\u001a\u00020!H$J\u0010\u0010#\u001a\u00020!2\u0006\u0010$\u001a\u00020\u000bH\u0004J\u0006\u0010%\u001a\u00020!R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR$\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0014R\u0017\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00070\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006&"}, d2={"Lio/dyte/webrtc/MediaStreamTrack;", "", "android", "Lorg/webrtc/MediaStreamTrack;", "(Lorg/webrtc/MediaStreamTrack;)V", "_state", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lio/dyte/webrtc/MediaStreamTrackState;", "getAndroid", "()Lorg/webrtc/MediaStreamTrack;", "value", "", "enabled", "getEnabled", "()Z", "setEnabled", "(Z)V", "id", "", "getId", "()Ljava/lang/String;", "kind", "Lio/dyte/webrtc/MediaStreamTrackKind;", "getKind", "()Lio/dyte/webrtc/MediaStreamTrackKind;", "label", "getLabel", "state", "Lkotlinx/coroutines/flow/StateFlow;", "getState", "()Lkotlinx/coroutines/flow/StateFlow;", "getInitialState", "onSetEnabled", "", "onStop", "setMuted", "muted", "stop", "webrtc_release"})
public abstract class MediaStreamTrack {
    @NotNull
    private final org.webrtc.MediaStreamTrack android;
    @NotNull
    private final MutableStateFlow<MediaStreamTrackState> _state;
    @NotNull
    private final StateFlow<MediaStreamTrackState> state;

    public MediaStreamTrack(@NotNull org.webrtc.MediaStreamTrack android) {
        Intrinsics.checkNotNullParameter((Object)android, (String)"android");
        this.android = android;
        this._state = StateFlowKt.MutableStateFlow((Object)this.getInitialState());
        this.state = FlowKt.asStateFlow(this._state);
    }

    @NotNull
    public final org.webrtc.MediaStreamTrack getAndroid() {
        return this.android;
    }

    @NotNull
    public final String getId() {
        String string = this.android.id();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"android.id()");
        return string;
    }

    @NotNull
    public final MediaStreamTrackKind getKind() {
        MediaStreamTrackKind mediaStreamTrackKind;
        String string = this.android.kind();
        if (Intrinsics.areEqual((Object)string, (Object)"audio")) {
            mediaStreamTrackKind = MediaStreamTrackKind.Audio;
        } else if (Intrinsics.areEqual((Object)string, (Object)"video")) {
            mediaStreamTrackKind = MediaStreamTrackKind.Video;
        } else {
            throw new IllegalStateException(("Unknown track kind: " + this.android.kind()).toString());
        }
        return mediaStreamTrackKind;
    }

    @NotNull
    public final String getLabel() {
        String string;
        switch (WhenMappings.$EnumSwitchMapping$0[this.getKind().ordinal()]) {
            case 1: {
                string = "microphone";
                break;
            }
            case 2: {
                string = "camera";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    public final boolean getEnabled() {
        return this.android.enabled();
    }

    public final void setEnabled(boolean value) {
        if (value == this.android.enabled()) {
            return;
        }
        this.android.setEnabled(value);
        this.onSetEnabled(value);
    }

    @NotNull
    public final StateFlow<MediaStreamTrackState> getState() {
        return this.state;
    }

    public final void stop() {
        MediaStreamTrackState it;
        MediaStreamTrackState nextValue$iv;
        Object prevValue$iv;
        if (this._state.getValue() instanceof MediaStreamTrackState.Ended) {
            return;
        }
        MutableStateFlow<MediaStreamTrackState> $this$update$iv = this._state;
        boolean $i$f$update = false;
        do {
            prevValue$iv = $this$update$iv.getValue();
            it = (MediaStreamTrackState)prevValue$iv;
            boolean bl = false;
        } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = (MediaStreamTrackState)new MediaStreamTrackState.Ended(it.getMuted()))));
        this.onStop();
    }

    protected final void setMuted(boolean muted) {
        if (muted) {
            MediaStreamTrackState it;
            MediaStreamTrackState nextValue$iv;
            Object prevValue$iv;
            MutableStateFlow<MediaStreamTrackState> $this$update$iv = this._state;
            boolean $i$f$update = false;
            do {
                prevValue$iv = $this$update$iv.getValue();
                it = (MediaStreamTrackState)prevValue$iv;
                boolean bl = false;
            } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = it.mute())));
        } else {
            MediaStreamTrackState it;
            MediaStreamTrackState nextValue$iv;
            Object prevValue$iv;
            MutableStateFlow<MediaStreamTrackState> $this$update$iv = this._state;
            boolean $i$f$update = false;
            do {
                prevValue$iv = $this$update$iv.getValue();
                it = (MediaStreamTrackState)prevValue$iv;
                boolean bl = false;
            } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = it.unmute())));
        }
    }

    protected abstract void onSetEnabled(boolean var1);

    protected abstract void onStop();

    private final MediaStreamTrackState getInitialState() {
        MediaStreamTrackState mediaStreamTrackState;
        MediaStreamTrack.State state = this.android.state();
        if (state == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        switch (WhenMappings.$EnumSwitchMapping$1[state.ordinal()]) {
            case 1: {
                mediaStreamTrackState = new MediaStreamTrackState.Live(false);
                break;
            }
            case 2: {
                mediaStreamTrackState = new MediaStreamTrackState.Live(false);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return mediaStreamTrackState;
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[MediaStreamTrackKind.values().length];
            try {
                nArray[MediaStreamTrackKind.Audio.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MediaStreamTrackKind.Video.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[MediaStreamTrack.State.values().length];
            try {
                nArray[MediaStreamTrack.State.LIVE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MediaStreamTrack.State.ENDED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

