/*
 * Decompiled with CFR 0.152.
 */
package io.dyte.webrtc;

import io.dyte.webrtc.AudioStreamTrack;
import io.dyte.webrtc.CommonRtpEncodingParameters;
import io.dyte.webrtc.CommonRtpTransceiverInit;
import io.dyte.webrtc.DataChannel;
import io.dyte.webrtc.IceCandidate;
import io.dyte.webrtc.IceConnectionState;
import io.dyte.webrtc.IceGatheringState;
import io.dyte.webrtc.MediaStream;
import io.dyte.webrtc.MediaStreamTrack;
import io.dyte.webrtc.MediaStreamTrackKind;
import io.dyte.webrtc.OfferAnswerOptions;
import io.dyte.webrtc.PeerConnectionEvent;
import io.dyte.webrtc.PeerConnectionKt;
import io.dyte.webrtc.PeerConnectionState;
import io.dyte.webrtc.RtcConfiguration;
import io.dyte.webrtc.RtcStatsReport;
import io.dyte.webrtc.RtpReceiver;
import io.dyte.webrtc.RtpSender;
import io.dyte.webrtc.RtpTransceiver;
import io.dyte.webrtc.RtpTransceiverKt;
import io.dyte.webrtc.SessionDescription;
import io.dyte.webrtc.SessionDescriptionExtKt;
import io.dyte.webrtc.SignalingState;
import io.dyte.webrtc.TrackEvent;
import io.dyte.webrtc.VideoStreamTrack;
import io.dyte.webrtc.WebRtc;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.SafeContinuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.DebugProbesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.webrtc.AudioTrack;
import org.webrtc.CandidatePairChangeEvent;
import org.webrtc.DataChannel;
import org.webrtc.MediaConstraints;
import org.webrtc.MediaStreamTrack;
import org.webrtc.PeerConnection;
import org.webrtc.RTCStatsCollectorCallback;
import org.webrtc.RTCStatsReport;
import org.webrtc.RtpParameters;
import org.webrtc.RtpTransceiver;
import org.webrtc.SdpObserver;
import org.webrtc.VideoTrack;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00de\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001fB\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.J'\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\u001f2\u0012\u00102\u001a\n\u0012\u0006\b\u0001\u0012\u00020403\"\u000204\u00a2\u0006\u0002\u00105J\"\u00106\u001a\u0002072\b\u00101\u001a\u0004\u0018\u00010\u001f2\b\u00108\u001a\u0004\u0018\u0001092\u0006\u0010:\u001a\u00020;J\u0006\u0010<\u001a\u000207J\u0019\u0010=\u001a\u00020\u00192\u0006\u0010>\u001a\u00020?H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010@JL\u0010A\u001a\u0004\u0018\u00010B2\u0006\u0010C\u001a\u00020\u001e2\b\b\u0002\u0010D\u001a\u00020E2\b\b\u0002\u0010F\u001a\u00020,2\b\b\u0002\u0010G\u001a\u00020E2\b\b\u0002\u0010H\u001a\u00020E2\b\b\u0002\u0010I\u001a\u00020\u001e2\b\b\u0002\u0010J\u001a\u00020,J\u0019\u0010K\u001a\u00020\u00192\u0006\u0010>\u001a\u00020?H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010@J\u0016\u0010L\u001a\u00020M2\f\u0010N\u001a\b\u0012\u0004\u0012\u00020\u00190OH\u0002J\f\u0010P\u001a\b\u0012\u0004\u0012\u00020R0QJ\f\u0010S\u001a\b\u0012\u0004\u0012\u0002000QJ\u0013\u0010T\u001a\u0004\u0018\u00010UH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010VJ\f\u0010W\u001a\b\u0012\u0004\u0012\u00020X0QJ\u0014\u0010Y\u001a\u00020,2\f\u0010Z\u001a\b\u0012\u0004\u0012\u00020.0QJ\u000e\u0010[\u001a\u00020,2\u0006\u0010\\\u001a\u000200J\u000e\u0010]\u001a\u00020,2\u0006\u0010^\u001a\u00020\u0003J\u0019\u0010_\u001a\u0002072\u0006\u0010`\u001a\u00020\u0019H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010aJ\u0019\u0010b\u001a\u0002072\u0006\u0010`\u001a\u00020\u0019H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010aJ\u0016\u0010c\u001a\u00020M2\f\u0010N\u001a\b\u0012\u0004\u0012\u0002070OH\u0002J\f\u0010d\u001a\u00020e*\u00020?H\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0013\u0010\u0018\u001a\u0004\u0018\u00010\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001f0\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00070!X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0013\u0010$\u001a\u0004\u0018\u00010\u00198F\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u001bR\u001a\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001f0\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010'\u001a\u00020(8F\u00a2\u0006\u0006\u001a\u0004\b)\u0010*\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006g"}, d2={"Lio/dyte/webrtc/PeerConnection;", "", "rtcConfiguration", "Lio/dyte/webrtc/RtcConfiguration;", "(Lio/dyte/webrtc/RtcConfiguration;)V", "_peerConnectionEvent", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "Lio/dyte/webrtc/PeerConnectionEvent;", "android", "Lorg/webrtc/PeerConnection;", "getAndroid", "()Lorg/webrtc/PeerConnection;", "connectionState", "Lio/dyte/webrtc/PeerConnectionState;", "getConnectionState", "()Lio/dyte/webrtc/PeerConnectionState;", "iceConnectionState", "Lio/dyte/webrtc/IceConnectionState;", "getIceConnectionState", "()Lio/dyte/webrtc/IceConnectionState;", "iceGatheringState", "Lio/dyte/webrtc/IceGatheringState;", "getIceGatheringState", "()Lio/dyte/webrtc/IceGatheringState;", "localDescription", "Lio/dyte/webrtc/SessionDescription;", "getLocalDescription", "()Lio/dyte/webrtc/SessionDescription;", "localTracks", "", "", "Lio/dyte/webrtc/MediaStreamTrack;", "peerConnectionEvent", "Lkotlinx/coroutines/flow/Flow;", "getPeerConnectionEvent$webrtc_release", "()Lkotlinx/coroutines/flow/Flow;", "remoteDescription", "getRemoteDescription", "remoteTracks", "signalingState", "Lio/dyte/webrtc/SignalingState;", "getSignalingState", "()Lio/dyte/webrtc/SignalingState;", "addIceCandidate", "", "candidate", "Lio/dyte/webrtc/IceCandidate;", "addTrack", "Lio/dyte/webrtc/RtpSender;", "track", "streams", "", "Lio/dyte/webrtc/MediaStream;", "(Lio/dyte/webrtc/MediaStreamTrack;[Lio/dyte/webrtc/MediaStream;)Lio/dyte/webrtc/RtpSender;", "addTransceiver", "", "kind", "Lio/dyte/webrtc/MediaStreamTrackKind;", "init", "Lio/dyte/webrtc/CommonRtpTransceiverInit;", "close", "createAnswer", "options", "Lio/dyte/webrtc/OfferAnswerOptions;", "(Lio/dyte/webrtc/OfferAnswerOptions;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createDataChannel", "Lio/dyte/webrtc/DataChannel;", "label", "id", "", "ordered", "maxRetransmitTimeMs", "maxRetransmits", "protocol", "negotiated", "createOffer", "createSdpObserver", "Lorg/webrtc/SdpObserver;", "continuation", "Lkotlin/coroutines/Continuation;", "getReceivers", "", "Lio/dyte/webrtc/RtpReceiver;", "getSenders", "getStats", "Lio/dyte/webrtc/RtcStatsReport;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getTransceivers", "Lio/dyte/webrtc/RtpTransceiver;", "removeIceCandidates", "candidates", "removeTrack", "sender", "setConfiguration", "configuration", "setLocalDescription", "description", "(Lio/dyte/webrtc/SessionDescription;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "setRemoteDescription", "setSdpObserver", "toMediaConstraints", "Lorg/webrtc/MediaConstraints;", "AndroidPeerConnectionObserver", "webrtc_release"})
public final class PeerConnection {
    @NotNull
    private final org.webrtc.PeerConnection android;
    @NotNull
    private final MutableSharedFlow<PeerConnectionEvent> _peerConnectionEvent;
    @NotNull
    private final Flow<PeerConnectionEvent> peerConnectionEvent;
    @NotNull
    private final Map<String, MediaStreamTrack> localTracks;
    @NotNull
    private final Map<String, MediaStreamTrack> remoteTracks;

    public PeerConnection(@NotNull RtcConfiguration rtcConfiguration) {
        Intrinsics.checkNotNullParameter((Object)rtcConfiguration, (String)"rtcConfiguration");
        org.webrtc.PeerConnection peerConnection = WebRtc.INSTANCE.getPeerConnectionFactory$webrtc_release().createPeerConnection(rtcConfiguration.getAndroid(), (PeerConnection.Observer)new AndroidPeerConnectionObserver());
        if (peerConnection == null) {
            throw new IllegalStateException("Creating PeerConnection failed".toString());
        }
        this.android = peerConnection;
        this._peerConnectionEvent = SharedFlowKt.MutableSharedFlow$default((int)0, (int)64, null, (int)5, null);
        this.peerConnectionEvent = (Flow)FlowKt.asSharedFlow(this._peerConnectionEvent);
        this.localTracks = new LinkedHashMap();
        this.remoteTracks = new LinkedHashMap();
    }

    public /* synthetic */ PeerConnection(RtcConfiguration rtcConfiguration, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            rtcConfiguration = new RtcConfiguration(null, null, 0, null, null, null, 63, null);
        }
        this(rtcConfiguration);
    }

    @NotNull
    public final org.webrtc.PeerConnection getAndroid() {
        return this.android;
    }

    @Nullable
    public final SessionDescription getLocalDescription() {
        org.webrtc.SessionDescription sessionDescription = this.android.getLocalDescription();
        return sessionDescription != null ? SessionDescriptionExtKt.asCommon(sessionDescription) : null;
    }

    @Nullable
    public final SessionDescription getRemoteDescription() {
        org.webrtc.SessionDescription sessionDescription = this.android.getRemoteDescription();
        return sessionDescription != null ? SessionDescriptionExtKt.asCommon(sessionDescription) : null;
    }

    @NotNull
    public final SignalingState getSignalingState() {
        PeerConnection.SignalingState signalingState = this.android.signalingState();
        Intrinsics.checkNotNullExpressionValue((Object)signalingState, (String)"android.signalingState()");
        return PeerConnectionKt.access$asCommon(signalingState);
    }

    @NotNull
    public final IceConnectionState getIceConnectionState() {
        PeerConnection.IceConnectionState iceConnectionState = this.android.iceConnectionState();
        Intrinsics.checkNotNullExpressionValue((Object)iceConnectionState, (String)"android.iceConnectionState()");
        return PeerConnectionKt.access$asCommon(iceConnectionState);
    }

    @NotNull
    public final PeerConnectionState getConnectionState() {
        PeerConnection.PeerConnectionState peerConnectionState = this.android.connectionState();
        Intrinsics.checkNotNullExpressionValue((Object)peerConnectionState, (String)"android.connectionState()");
        return PeerConnectionKt.access$asCommon(peerConnectionState);
    }

    @NotNull
    public final IceGatheringState getIceGatheringState() {
        PeerConnection.IceGatheringState iceGatheringState = this.android.iceGatheringState();
        Intrinsics.checkNotNullExpressionValue((Object)iceGatheringState, (String)"android.iceGatheringState()");
        return PeerConnectionKt.access$asCommon(iceGatheringState);
    }

    @NotNull
    public final Flow<PeerConnectionEvent> getPeerConnectionEvent$webrtc_release() {
        return this.peerConnectionEvent;
    }

    @Nullable
    public final DataChannel createDataChannel(@NotNull String label, int id, boolean ordered, int maxRetransmitTimeMs, int maxRetransmits, @NotNull String protocol, boolean negotiated) {
        DataChannel dataChannel;
        DataChannel.Init init;
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        Intrinsics.checkNotNullParameter((Object)protocol, (String)"protocol");
        DataChannel.Init it = init = new DataChannel.Init();
        boolean bl = false;
        it.id = id;
        it.ordered = ordered;
        it.maxRetransmitTimeMs = maxRetransmitTimeMs;
        it.maxRetransmits = maxRetransmits;
        it.protocol = protocol;
        it.negotiated = negotiated;
        DataChannel.Init init2 = init;
        org.webrtc.DataChannel dataChannel2 = this.android.createDataChannel(label, init2);
        if (dataChannel2 != null) {
            org.webrtc.DataChannel it2 = dataChannel2;
            boolean bl2 = false;
            dataChannel = new DataChannel(it2);
        } else {
            dataChannel = null;
        }
        return dataChannel;
    }

    public static /* synthetic */ DataChannel createDataChannel$default(PeerConnection peerConnection, String string, int n, boolean bl, int n2, int n3, String string2, boolean bl2, int n4, Object object) {
        if ((n4 & 2) != 0) {
            n = -1;
        }
        if ((n4 & 4) != 0) {
            bl = true;
        }
        if ((n4 & 8) != 0) {
            n2 = -1;
        }
        if ((n4 & 0x10) != 0) {
            n3 = -1;
        }
        if ((n4 & 0x20) != 0) {
            string2 = "";
        }
        if ((n4 & 0x40) != 0) {
            bl2 = false;
        }
        return peerConnection.createDataChannel(string, n, bl, n2, n3, string2, bl2);
    }

    @Nullable
    public final Object createOffer(@NotNull OfferAnswerOptions options, @NotNull Continuation<? super SessionDescription> $completion) {
        Continuation<? super SessionDescription> continuation = $completion;
        SafeContinuation safeContinuation = new SafeContinuation(IntrinsicsKt.intercepted(continuation));
        Continuation cont = (Continuation)safeContinuation;
        boolean bl = false;
        this.android.createOffer(this.createSdpObserver((Continuation<? super SessionDescription>)cont), this.toMediaConstraints(options));
        Object object = safeContinuation.getOrThrow();
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            DebugProbesKt.probeCoroutineSuspended($completion);
        }
        return object;
    }

    @Nullable
    public final Object createAnswer(@NotNull OfferAnswerOptions options, @NotNull Continuation<? super SessionDescription> $completion) {
        Continuation<? super SessionDescription> continuation = $completion;
        SafeContinuation safeContinuation = new SafeContinuation(IntrinsicsKt.intercepted(continuation));
        Continuation cont = (Continuation)safeContinuation;
        boolean bl = false;
        this.android.createAnswer(this.createSdpObserver((Continuation<? super SessionDescription>)cont), this.toMediaConstraints(options));
        Object object = safeContinuation.getOrThrow();
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            DebugProbesKt.probeCoroutineSuspended($completion);
        }
        return object;
    }

    private final MediaConstraints toMediaConstraints(OfferAnswerOptions $this$toMediaConstraints) {
        MediaConstraints mediaConstraints;
        block3: {
            Collection collection;
            boolean it;
            MediaConstraints $this$toMediaConstraints_u24lambda_u248 = mediaConstraints = new MediaConstraints();
            boolean bl = false;
            Boolean bl2 = $this$toMediaConstraints.getIceRestart();
            if (bl2 != null) {
                it = bl2;
                boolean bl3 = false;
                List list = $this$toMediaConstraints_u24lambda_u248.mandatory;
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"mandatory");
                collection = list;
                collection.add(new MediaConstraints.KeyValuePair("IceRestart", String.valueOf(it)));
            }
            Boolean bl4 = $this$toMediaConstraints.getOfferToReceiveAudio();
            if (bl4 != null) {
                it = bl4;
                boolean bl5 = false;
                List list = $this$toMediaConstraints_u24lambda_u248.mandatory;
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"mandatory");
                collection = list;
                collection.add(new MediaConstraints.KeyValuePair("OfferToReceiveAudio", String.valueOf(it)));
            }
            Boolean bl6 = $this$toMediaConstraints.getOfferToReceiveVideo();
            if (bl6 != null) {
                it = bl6;
                boolean bl7 = false;
                List list = $this$toMediaConstraints_u24lambda_u248.mandatory;
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"mandatory");
                collection = list;
                collection.add(new MediaConstraints.KeyValuePair("OfferToReceiveVideo", String.valueOf(it)));
            }
            Boolean bl8 = $this$toMediaConstraints.getVoiceActivityDetection();
            if (bl8 == null) break block3;
            it = bl8;
            boolean bl9 = false;
            List list = $this$toMediaConstraints_u24lambda_u248.mandatory;
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"mandatory");
            collection = list;
            collection.add(new MediaConstraints.KeyValuePair("VoiceActivityDetection", String.valueOf(it)));
        }
        return mediaConstraints;
    }

    private final SdpObserver createSdpObserver(Continuation<? super SessionDescription> continuation) {
        return new SdpObserver(continuation){
            final /* synthetic */ Continuation<SessionDescription> $continuation;
            {
                this.$continuation = $continuation;
            }

            public void onCreateSuccess(@NotNull org.webrtc.SessionDescription description) {
                Intrinsics.checkNotNullParameter((Object)description, (String)"description");
                this.$continuation.resumeWith(Result.constructor-impl((Object)SessionDescriptionExtKt.asCommon(description)));
            }

            public void onSetSuccess() {
            }

            public void onCreateFailure(@Nullable String error) {
                this.$continuation.resumeWith(Result.constructor-impl((Object)ResultKt.createFailure((Throwable)new RuntimeException("Creating SDP failed: " + error))));
            }

            public void onSetFailure(@Nullable String error) {
            }
        };
    }

    @Nullable
    public final Object setLocalDescription(@NotNull SessionDescription description, @NotNull Continuation<? super Unit> $completion) {
        Continuation<? super Unit> continuation = $completion;
        SafeContinuation safeContinuation = new SafeContinuation(IntrinsicsKt.intercepted(continuation));
        Continuation it = (Continuation)safeContinuation;
        boolean bl = false;
        this.android.setLocalDescription(this.setSdpObserver((Continuation<? super Unit>)it), SessionDescriptionExtKt.asAndroid(description));
        Object object = safeContinuation.getOrThrow();
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            DebugProbesKt.probeCoroutineSuspended($completion);
        }
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public final Object setRemoteDescription(@NotNull SessionDescription description, @NotNull Continuation<? super Unit> $completion) {
        Continuation<? super Unit> continuation = $completion;
        SafeContinuation safeContinuation = new SafeContinuation(IntrinsicsKt.intercepted(continuation));
        Continuation it = (Continuation)safeContinuation;
        boolean bl = false;
        this.android.setRemoteDescription(this.setSdpObserver((Continuation<? super Unit>)it), SessionDescriptionExtKt.asAndroid(description));
        Object object = safeContinuation.getOrThrow();
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            DebugProbesKt.probeCoroutineSuspended($completion);
        }
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final SdpObserver setSdpObserver(Continuation<? super Unit> continuation) {
        return new SdpObserver(continuation){
            final /* synthetic */ Continuation<Unit> $continuation;
            {
                this.$continuation = $continuation;
            }

            public void onCreateSuccess(@NotNull org.webrtc.SessionDescription description) {
                Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            }

            public void onSetSuccess() {
                this.$continuation.resumeWith(Result.constructor-impl((Object)Unit.INSTANCE));
            }

            public void onCreateFailure(@Nullable String error) {
            }

            public void onSetFailure(@Nullable String error) {
                this.$continuation.resumeWith(Result.constructor-impl((Object)ResultKt.createFailure((Throwable)new RuntimeException("Setting SDP failed: " + error))));
            }
        };
    }

    public final boolean setConfiguration(@NotNull RtcConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        return this.android.setConfiguration(configuration.getAndroid());
    }

    public final boolean addIceCandidate(@NotNull IceCandidate candidate) {
        Intrinsics.checkNotNullParameter((Object)candidate, (String)"candidate");
        return this.android.addIceCandidate(candidate.getNative());
    }

    /*
     * WARNING - void declaration
     */
    public final boolean removeIceCandidates(@NotNull List<IceCandidate> candidates) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(candidates, (String)"candidates");
        Iterable iterable = candidates;
        org.webrtc.PeerConnection peerConnection = this.android;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IceCandidate iceCandidate = (IceCandidate)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getNative());
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return peerConnection.removeIceCandidates(thisCollection$iv.toArray(new org.webrtc.IceCandidate[0]));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<RtpSender> getSenders() {
        void $this$mapTo$iv$iv;
        List list = this.android.getSenders();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"android.senders");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            org.webrtc.RtpSender rtpSender = (org.webrtc.RtpSender)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            Map<String, MediaStreamTrack> map2 = this.localTracks;
            org.webrtc.MediaStreamTrack mediaStreamTrack = it.track();
            collection.add(new RtpSender((org.webrtc.RtpSender)it, map2.get(mediaStreamTrack != null ? mediaStreamTrack.id() : null)));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<RtpReceiver> getReceivers() {
        void $this$mapTo$iv$iv;
        List list = this.android.getReceivers();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"android.receivers");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            org.webrtc.RtpReceiver rtpReceiver = (org.webrtc.RtpReceiver)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            Map<String, MediaStreamTrack> map2 = this.remoteTracks;
            org.webrtc.MediaStreamTrack mediaStreamTrack = it.track();
            collection.add(new RtpReceiver((org.webrtc.RtpReceiver)it, map2.get(mediaStreamTrack != null ? mediaStreamTrack.id() : null)));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<RtpTransceiver> getTransceivers() {
        void $this$mapTo$iv$iv;
        List list = this.android.getTransceivers();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"android.transceivers");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            org.webrtc.RtpTransceiver rtpTransceiver = (org.webrtc.RtpTransceiver)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Map<String, MediaStreamTrack> map2 = this.localTracks;
            org.webrtc.MediaStreamTrack mediaStreamTrack = it.getSender().track();
            MediaStreamTrack senderTrack = map2.get(mediaStreamTrack != null ? mediaStreamTrack.id() : null);
            Map<String, MediaStreamTrack> map3 = this.remoteTracks;
            org.webrtc.MediaStreamTrack mediaStreamTrack2 = it.getReceiver().track();
            MediaStreamTrack receiverTrack = map3.get(mediaStreamTrack2 != null ? mediaStreamTrack2.id() : null);
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            collection.add(new RtpTransceiver((org.webrtc.RtpTransceiver)it, senderTrack, receiverTrack));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final RtpSender addTrack(@NotNull MediaStreamTrack track, MediaStream ... streams) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)track, (String)"track");
        Intrinsics.checkNotNullParameter((Object)streams, (String)"streams");
        MediaStream[] $this$map$iv = streams;
        boolean $i$f$map = false;
        MediaStream[] mediaStreamArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var12_11 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId());
        }
        List streamIds = (List)destination$iv$iv;
        this.localTracks.put(track.getId(), track);
        org.webrtc.RtpSender rtpSender = this.android.addTrack(track.getAndroid(), streamIds);
        Intrinsics.checkNotNullExpressionValue((Object)rtpSender, (String)"android.addTrack(track.android, streamIds)");
        return new RtpSender(rtpSender, track);
    }

    public final boolean removeTrack(@NotNull RtpSender sender) {
        Intrinsics.checkNotNullParameter((Object)sender, (String)"sender");
        Map<String, MediaStreamTrack> map2 = this.localTracks;
        MediaStreamTrack mediaStreamTrack = sender.getTrack();
        String string = mediaStreamTrack != null ? mediaStreamTrack.getId() : null;
        TypeIntrinsics.asMutableMap(map2).remove(string);
        return this.android.removeTrack(sender.getNative());
    }

    @Nullable
    public final Object getStats(@NotNull Continuation<? super RtcStatsReport> $completion) {
        Continuation<? super RtcStatsReport> continuation = $completion;
        SafeContinuation safeContinuation = new SafeContinuation(IntrinsicsKt.intercepted(continuation));
        Continuation cont = (Continuation)safeContinuation;
        boolean bl = false;
        this.android.getStats(new RTCStatsCollectorCallback((Continuation<? super RtcStatsReport>)cont){
            final /* synthetic */ Continuation<RtcStatsReport> $cont;
            {
                this.$cont = $cont;
            }

            public final void onStatsDelivered(RTCStatsReport it) {
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                this.$cont.resumeWith(Result.constructor-impl((Object)new RtcStatsReport(it)));
            }
        });
        Object object = safeContinuation.getOrThrow();
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            DebugProbesKt.probeCoroutineSuspended($completion);
        }
        return object;
    }

    public final void close() {
        Iterable $this$forEach$iv = this.remoteTracks.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MediaStreamTrack p0 = (MediaStreamTrack)element$iv;
            boolean bl = false;
            p0.stop();
        }
        this.remoteTracks.clear();
        this.android.dispose();
    }

    public final void addTransceiver(@Nullable MediaStreamTrack track, @Nullable MediaStreamTrackKind kind, @NotNull CommonRtpTransceiverInit init) {
        Collection<RtpParameters.Encoding> collection;
        CommonRtpEncodingParameters it;
        Collection collection2;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)init, (String)"init");
        Iterable iterable = init.getStreams();
        RtpTransceiver.RtpTransceiverDirection rtpTransceiverDirection = RtpTransceiverKt.asNative(init.getDirection());
        boolean $i$f$map = false;
        void var7_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            MediaStream mediaStream = (MediaStream)item$iv$iv;
            collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(((MediaStream)((Object)it)).getId());
        }
        $this$map$iv = init.getSendEncodings();
        collection2 = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (CommonRtpEncodingParameters)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new RtpParameters.Encoding(it.getRid(), it.getActive(), it.getScaleResolutionDownBy()));
        }
        collection = (List)destination$iv$iv;
        List list = collection;
        Collection collection3 = collection2;
        RtpTransceiver.RtpTransceiverDirection rtpTransceiverDirection2 = rtpTransceiverDirection;
        RtpTransceiver.RtpTransceiverInit nativeRtpTransceiverInit = new RtpTransceiver.RtpTransceiverInit(rtpTransceiverDirection2, (List)collection3, list);
        if (track != null) {
            this.android.addTransceiver(track.getAndroid(), nativeRtpTransceiverInit);
        } else if (kind != null) {
            MediaStreamTrack.MediaType nativeKind = MediaStreamTrack.MediaType.MEDIA_TYPE_VIDEO;
            if (kind == MediaStreamTrackKind.Audio) {
                nativeKind = MediaStreamTrack.MediaType.MEDIA_TYPE_AUDIO;
            }
            this.android.addTransceiver(nativeKind, nativeRtpTransceiverInit);
        }
    }

    public PeerConnection() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0080\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J%\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u000e\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u000bH\u0016\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u001d\u0010\u0016\u001a\u00020\u00042\u000e\u0010\u0017\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00150\u000bH\u0016\u00a2\u0006\u0002\u0010\u0018J\u0010\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010!\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\"\u001a\u00020\u0004H\u0016J\u0010\u0010#\u001a\u00020\u00042\u0006\u0010$\u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020'H\u0016J\u0010\u0010(\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u001aH\u0016\u00a8\u0006)"}, d2={"Lio/dyte/webrtc/PeerConnection$AndroidPeerConnectionObserver;", "Lorg/webrtc/PeerConnection$Observer;", "(Lio/dyte/webrtc/PeerConnection;)V", "onAddStream", "", "nativeStream", "Lorg/webrtc/MediaStream;", "onAddTrack", "receiver", "Lorg/webrtc/RtpReceiver;", "androidStreams", "", "(Lorg/webrtc/RtpReceiver;[Lorg/webrtc/MediaStream;)V", "onConnectionChange", "newState", "Lorg/webrtc/PeerConnection$PeerConnectionState;", "onDataChannel", "dataChannel", "Lorg/webrtc/DataChannel;", "onIceCandidate", "candidate", "Lorg/webrtc/IceCandidate;", "onIceCandidatesRemoved", "candidates", "([Lorg/webrtc/IceCandidate;)V", "onIceConnectionChange", "Lorg/webrtc/PeerConnection$IceConnectionState;", "onIceConnectionReceivingChange", "receiving", "", "onIceGatheringChange", "Lorg/webrtc/PeerConnection$IceGatheringState;", "onRemoveStream", "onRemoveTrack", "onRenegotiationNeeded", "onSelectedCandidatePairChanged", "event", "Lorg/webrtc/CandidatePairChangeEvent;", "onSignalingChange", "Lorg/webrtc/PeerConnection$SignalingState;", "onStandardizedIceConnectionChange", "webrtc_release"})
    public final class AndroidPeerConnectionObserver
    implements PeerConnection.Observer {
        public void onSignalingChange(@NotNull PeerConnection.SignalingState newState) {
            Intrinsics.checkNotNullParameter((Object)newState, (String)"newState");
            PeerConnection.this._peerConnectionEvent.tryEmit((Object)new PeerConnectionEvent.SignalingStateChange(PeerConnectionKt.access$asCommon(newState)));
        }

        public void onIceConnectionChange(@NotNull PeerConnection.IceConnectionState newState) {
            Intrinsics.checkNotNullParameter((Object)newState, (String)"newState");
            PeerConnection.this._peerConnectionEvent.tryEmit((Object)new PeerConnectionEvent.IceConnectionStateChange(PeerConnectionKt.access$asCommon(newState)));
        }

        public void onStandardizedIceConnectionChange(@NotNull PeerConnection.IceConnectionState newState) {
            Intrinsics.checkNotNullParameter((Object)newState, (String)"newState");
            PeerConnection.this._peerConnectionEvent.tryEmit((Object)new PeerConnectionEvent.StandardizedIceConnectionChange(PeerConnectionKt.access$asCommon(newState)));
        }

        public void onConnectionChange(@NotNull PeerConnection.PeerConnectionState newState) {
            Intrinsics.checkNotNullParameter((Object)newState, (String)"newState");
            PeerConnection.this._peerConnectionEvent.tryEmit((Object)new PeerConnectionEvent.ConnectionStateChange(PeerConnectionKt.access$asCommon(newState)));
        }

        public void onIceConnectionReceivingChange(boolean receiving) {
        }

        public void onIceGatheringChange(@NotNull PeerConnection.IceGatheringState newState) {
            Intrinsics.checkNotNullParameter((Object)newState, (String)"newState");
            PeerConnection.this._peerConnectionEvent.tryEmit((Object)new PeerConnectionEvent.IceGatheringStateChange(PeerConnectionKt.access$asCommon(newState)));
        }

        public void onIceCandidate(@NotNull org.webrtc.IceCandidate candidate) {
            Intrinsics.checkNotNullParameter((Object)candidate, (String)"candidate");
            PeerConnection.this._peerConnectionEvent.tryEmit((Object)new PeerConnectionEvent.NewIceCandidate(new IceCandidate(candidate)));
        }

        /*
         * WARNING - void declaration
         */
        public void onIceCandidatesRemoved(@NotNull org.webrtc.IceCandidate[] candidates) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter((Object)candidates, (String)"candidates");
            org.webrtc.IceCandidate[] iceCandidateArray = candidates;
            MutableSharedFlow mutableSharedFlow = PeerConnection.this._peerConnectionEvent;
            boolean $i$f$map = false;
            void var4_5 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
            boolean $i$f$mapTo = false;
            int n = ((void)$this$mapTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void it;
                void item$iv$iv;
                void var10_11 = item$iv$iv = $this$mapTo$iv$iv[i];
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new IceCandidate((org.webrtc.IceCandidate)it));
            }
            List list = (List)destination$iv$iv;
            mutableSharedFlow.tryEmit((Object)new PeerConnectionEvent.RemovedIceCandidates(list));
        }

        public void onAddStream(@NotNull org.webrtc.MediaStream nativeStream) {
            Intrinsics.checkNotNullParameter((Object)nativeStream, (String)"nativeStream");
        }

        public void onRemoveStream(@NotNull org.webrtc.MediaStream nativeStream) {
            Intrinsics.checkNotNullParameter((Object)nativeStream, (String)"nativeStream");
        }

        public void onDataChannel(@NotNull org.webrtc.DataChannel dataChannel) {
            Intrinsics.checkNotNullParameter((Object)dataChannel, (String)"dataChannel");
            PeerConnection.this._peerConnectionEvent.tryEmit((Object)new PeerConnectionEvent.NewDataChannel(new DataChannel(dataChannel)));
        }

        public void onRenegotiationNeeded() {
            PeerConnection.this._peerConnectionEvent.tryEmit((Object)PeerConnectionEvent.NegotiationNeeded.INSTANCE);
        }

        /*
         * WARNING - void declaration
         */
        public void onAddTrack(@NotNull org.webrtc.RtpReceiver receiver, @NotNull org.webrtc.MediaStream[] androidStreams) {
            Object $this$mapTo$iv$iv;
            void $this$map$iv;
            void $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv;
            Map key$iv;
            Collection collection;
            void $this$mapTo$iv$iv2;
            void $this$map$iv2;
            Iterable list$iv$iv;
            void it;
            void $this$flatMapTo$iv$iv2;
            Iterable $this$flatMap$iv2;
            Object v1;
            int n;
            block13: {
                Intrinsics.checkNotNullParameter((Object)receiver, (String)"receiver");
                Intrinsics.checkNotNullParameter((Object)androidStreams, (String)"androidStreams");
                List list = PeerConnection.this.getAndroid().getTransceivers();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"android.transceivers");
                Iterable iterable = list;
                for (Object t : iterable) {
                    org.webrtc.RtpTransceiver it2 = (org.webrtc.RtpTransceiver)t;
                    n = 0;
                    if (!Intrinsics.areEqual((Object)it2.getReceiver().id(), (Object)receiver.id())) continue;
                    v1 = t;
                    break block13;
                }
                v1 = null;
            }
            org.webrtc.RtpTransceiver rtpTransceiver = v1;
            if (rtpTransceiver == null) {
                return;
            }
            org.webrtc.RtpTransceiver transceiver = rtpTransceiver;
            org.webrtc.MediaStream[] mediaStreamArray = androidStreams;
            boolean $i$f$flatMap22 = false;
            Iterator iterator = $this$flatMap$iv2;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            int n2 = ((void)$this$flatMapTo$iv$iv2).length;
            for (n = 0; n < n2; ++n) {
                void element$iv$iv;
                it = element$iv$iv = $this$flatMapTo$iv$iv2[n];
                boolean bl = false;
                List list = it.audioTracks;
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"it.audioTracks");
                list$iv$iv = list;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            $this$flatMap$iv2 = (List)destination$iv$iv;
            org.webrtc.MediaStream[] $i$f$flatMap22 = PeerConnection.this;
            boolean $i$f$map = false;
            destination$iv$iv = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                Object object;
                void $this$getOrPut$iv;
                list$iv$iv = (AudioTrack)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl = false;
                Map map2 = ((PeerConnection)$i$f$flatMap22).remoteTracks;
                Intrinsics.checkNotNullExpressionValue((Object)it.id(), (String)"it.id()");
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl2 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    MediaStreamTrack answer$iv = new AudioStreamTrack((AudioTrack)it, null, 2, null);
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                collection.add((MediaStreamTrack)object);
            }
            List audioTracks = (List)destination$iv$iv2;
            $i$f$flatMap22 = androidStreams;
            boolean $i$f$flatMap32 = false;
            $this$mapTo$iv$iv2 = $this$flatMap$iv;
            destination$iv$iv2 = new ArrayList();
            boolean $i$f$flatMapTo2 = false;
            int n3 = ((void)$this$flatMapTo$iv$iv).length;
            for (int i = 0; i < n3; ++i) {
                void element$iv$iv;
                void it3 = element$iv$iv = $this$flatMapTo$iv$iv[i];
                boolean bl = false;
                List list = it3.videoTracks;
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"it.videoTracks");
                Iterable list$iv$iv2 = list;
                CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv2);
            }
            $this$flatMap$iv = (List)destination$iv$iv2;
            PeerConnection $i$f$flatMap32 = PeerConnection.this;
            boolean $i$f$map2 = false;
            destination$iv$iv2 = $this$map$iv;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo2 = false;
            Iterator iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Object object;
                String key$iv2;
                void $this$getOrPut$iv;
                void it4;
                Object item$iv$iv = iterator2.next();
                VideoTrack list$iv$iv2 = (VideoTrack)item$iv$iv;
                collection = destination$iv$iv3;
                boolean bl = false;
                key$iv = $i$f$flatMap32.remoteTracks;
                Intrinsics.checkNotNullExpressionValue((Object)it4.id(), (String)"it.id()");
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv2);
                if (value$iv == null) {
                    boolean bl3 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it4, (String)"it");
                    MediaStreamTrack answer$iv = new VideoStreamTrack((VideoTrack)it4, null, 2, null);
                    $this$getOrPut$iv.put(key$iv2, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                collection.add((MediaStreamTrack)object);
            }
            List videoTracks = (List)destination$iv$iv3;
            org.webrtc.MediaStream[] $this$map$iv3 = androidStreams;
            $i$f$map2 = false;
            $this$mapTo$iv$iv = $this$map$iv3;
            destination$iv$iv3 = new ArrayList($this$map$iv3.length);
            $i$f$mapTo2 = false;
            int n4 = ((org.webrtc.MediaStream[])$this$mapTo$iv$iv).length;
            for (int i = 0; i < n4; ++i) {
                MediaStreamTrack p0;
                MediaStream mediaStream;
                void androidStream;
                org.webrtc.MediaStream item$iv$iv;
                org.webrtc.MediaStream bl = item$iv$iv = $this$mapTo$iv$iv[i];
                collection = destination$iv$iv3;
                boolean bl4 = false;
                String string = androidStream.getId();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"androidStream.id");
                MediaStream stream = mediaStream = new MediaStream((org.webrtc.MediaStream)androidStream, string);
                boolean bl5 = false;
                Iterable $this$forEach$iv = audioTracks;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    p0 = (MediaStreamTrack)element$iv;
                    boolean bl6 = false;
                    stream.addTrack(p0);
                }
                $this$forEach$iv = videoTracks;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    p0 = (MediaStreamTrack)element$iv;
                    boolean bl7 = false;
                    stream.addTrack(p0);
                }
                collection.add(mediaStream);
            }
            List streams = (List)destination$iv$iv3;
            Map $i$f$map22 = PeerConnection.this.localTracks;
            org.webrtc.MediaStreamTrack mediaStreamTrack = transceiver.getSender().track();
            MediaStreamTrack senderTrack = (MediaStreamTrack)$i$f$map22.get(mediaStreamTrack != null ? mediaStreamTrack.id() : null);
            $this$mapTo$iv$iv = PeerConnection.this.remoteTracks;
            org.webrtc.MediaStreamTrack mediaStreamTrack2 = receiver.track();
            MediaStreamTrack receiverTrack = (MediaStreamTrack)$this$mapTo$iv$iv.get(mediaStreamTrack2 != null ? mediaStreamTrack2.id() : null);
            TrackEvent trackEvent = new TrackEvent(new RtpReceiver(receiver, receiverTrack), streams, receiverTrack, new RtpTransceiver(transceiver, senderTrack, receiverTrack));
            PeerConnection.this._peerConnectionEvent.tryEmit((Object)new PeerConnectionEvent.Track(trackEvent));
        }

        public void onRemoveTrack(@NotNull org.webrtc.RtpReceiver receiver) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)receiver, (String)"receiver");
                Map map2 = PeerConnection.this.remoteTracks;
                org.webrtc.MediaStreamTrack mediaStreamTrack = receiver.track();
                String string = mediaStreamTrack != null ? mediaStreamTrack.id() : null;
                MediaStreamTrack track = (MediaStreamTrack)TypeIntrinsics.asMutableMap((Object)map2).remove(string);
                PeerConnection.this._peerConnectionEvent.tryEmit((Object)new PeerConnectionEvent.RemoveTrack(new RtpReceiver(receiver, track)));
                MediaStreamTrack mediaStreamTrack2 = track;
                if (mediaStreamTrack2 == null) break block0;
                mediaStreamTrack2.stop();
            }
        }

        public void onSelectedCandidatePairChanged(@NotNull CandidatePairChangeEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        }
    }
}

