/*
 * Decompiled with CFR 0.152.
 */
package io.dyte.webrtc;

import io.dyte.webrtc.ApplicationContextHolder;
import io.dyte.webrtc.VideoCapturerErrorListener;
import io.dyte.webrtc.WebRtc;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.webrtc.EglBase;
import org.webrtc.Size;
import org.webrtc.SurfaceTextureHelper;
import org.webrtc.VideoCapturer;
import org.webrtc.VideoSource;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b \u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0017\u001a\u00020\fH&J\u0006\u0010\u0018\u001a\u00020\u0019J\b\u0010\u001a\u001a\u00020\u001bH&J\b\u0010\u001c\u001a\u00020\u001dH&J\u0006\u0010\u001e\u001a\u00020\u0019J\u0006\u0010\u001f\u001a\u00020\u0019R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000b\u001a\u00020\f8DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lio/dyte/webrtc/VideoCaptureController;", "", "videoSource", "Lorg/webrtc/VideoSource;", "(Lorg/webrtc/VideoSource;)V", "disposed", "", "isScreencast", "()Z", "textureHelper", "Lorg/webrtc/SurfaceTextureHelper;", "videoCapturer", "Lorg/webrtc/VideoCapturer;", "getVideoCapturer", "()Lorg/webrtc/VideoCapturer;", "videoCapturer$delegate", "Lkotlin/Lazy;", "videoCapturerErrorListener", "Lio/dyte/webrtc/VideoCapturerErrorListener;", "getVideoCapturerErrorListener", "()Lio/dyte/webrtc/VideoCapturerErrorListener;", "setVideoCapturerErrorListener", "(Lio/dyte/webrtc/VideoCapturerErrorListener;)V", "createVideoCapturer", "dispose", "", "selectFps", "", "selectVideoSize", "Lorg/webrtc/Size;", "startCapture", "stopCapture", "webrtc_release"})
public abstract class VideoCaptureController {
    @NotNull
    private final VideoSource videoSource;
    @NotNull
    private VideoCapturerErrorListener videoCapturerErrorListener;
    @NotNull
    private final Lazy videoCapturer$delegate;
    @Nullable
    private SurfaceTextureHelper textureHelper;
    private boolean disposed;

    public VideoCaptureController(@NotNull VideoSource videoSource) {
        Intrinsics.checkNotNullParameter((Object)videoSource, (String)"videoSource");
        this.videoSource = videoSource;
        this.videoCapturerErrorListener = VideoCaptureController::videoCapturerErrorListener$lambda$0;
        this.videoCapturer$delegate = LazyKt.lazy((Function0)((Function0)new Function0<VideoCapturer>(this){
            final /* synthetic */ VideoCaptureController this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final VideoCapturer invoke() {
                return this.this$0.createVideoCapturer();
            }
        }));
    }

    public final boolean isScreencast() {
        return this.getVideoCapturer().isScreencast();
    }

    @NotNull
    public final VideoCapturerErrorListener getVideoCapturerErrorListener() {
        return this.videoCapturerErrorListener;
    }

    public final void setVideoCapturerErrorListener(@NotNull VideoCapturerErrorListener videoCapturerErrorListener) {
        Intrinsics.checkNotNullParameter((Object)videoCapturerErrorListener, (String)"<set-?>");
        this.videoCapturerErrorListener = videoCapturerErrorListener;
    }

    @NotNull
    protected final VideoCapturer getVideoCapturer() {
        Lazy lazy = this.videoCapturer$delegate;
        return (VideoCapturer)lazy.getValue();
    }

    @NotNull
    public abstract VideoCapturer createVideoCapturer();

    @NotNull
    public abstract Size selectVideoSize();

    public abstract int selectFps();

    public final void startCapture() {
        if (!(!this.disposed)) {
            boolean $i$a$-check-VideoCaptureController$startCapture$32 = false;
            String $i$a$-check-VideoCaptureController$startCapture$32 = "Video capturer disposed";
            throw new IllegalStateException($i$a$-check-VideoCaptureController$startCapture$32.toString());
        }
        if (!(this.textureHelper == null)) {
            boolean $i$a$-check-VideoCaptureController$startCapture$42 = false;
            String $i$a$-check-VideoCaptureController$startCapture$42 = "Video capturer already started";
            throw new IllegalStateException($i$a$-check-VideoCaptureController$startCapture$42.toString());
        }
        this.textureHelper = SurfaceTextureHelper.create((String)"VideoCapturerTextureHelper", (EglBase.Context)WebRtc.INSTANCE.getRootEglBase().getEglBaseContext());
        this.getVideoCapturer().initialize(this.textureHelper, ApplicationContextHolder.Companion.getContext(), this.videoSource.getCapturerObserver());
        Size size = this.selectVideoSize();
        int fps = this.selectFps();
        this.getVideoCapturer().startCapture(size.width, size.height, fps);
    }

    public final void stopCapture() {
        if (!(!this.disposed)) {
            boolean bl = false;
            String string = "Video capturer disposed";
            throw new IllegalStateException(string.toString());
        }
        if (this.textureHelper == null) {
            return;
        }
        this.getVideoCapturer().stopCapture();
        SurfaceTextureHelper surfaceTextureHelper = this.textureHelper;
        if (surfaceTextureHelper != null) {
            surfaceTextureHelper.stopListening();
        }
        SurfaceTextureHelper surfaceTextureHelper2 = this.textureHelper;
        if (surfaceTextureHelper2 != null) {
            surfaceTextureHelper2.dispose();
        }
        this.textureHelper = null;
    }

    public final void dispose() {
        this.stopCapture();
        this.getVideoCapturer().dispose();
        this.videoSource.dispose();
    }

    private static final void videoCapturerErrorListener$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
    }
}

