/*
 * Decompiled with CFR 0.152.
 */
package io.dyte.webrtc;

import android.content.Context;
import io.dyte.webrtc.ApplicationContextHolder;
import io.dyte.webrtc.WebRtc;
import io.dyte.webrtc.WebRtcBuilder;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.webrtc.DefaultVideoDecoderFactory;
import org.webrtc.DefaultVideoEncoderFactory;
import org.webrtc.EglBase;
import org.webrtc.Logging;
import org.webrtc.PeerConnectionFactory;
import org.webrtc.VideoDecoderFactory;
import org.webrtc.VideoEncoderFactory;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J!\u0010\u000f\u001a\u00020\u00102\u0019\b\u0002\u0010\u0011\u001a\u0013\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00100\u0012\u00a2\u0006\u0002\b\u0013J\u0006\u0010\u0014\u001a\u00020\u0010J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\u0006\u0010\u0017\u001a\u00020\u0010J\b\u0010\u0018\u001a\u00020\u0010H\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\u00068@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lio/dyte/webrtc/WebRtc;", "", "()V", "_eglBase", "Lorg/webrtc/EglBase;", "_peerConnectionFactory", "Lorg/webrtc/PeerConnectionFactory;", "builder", "Lio/dyte/webrtc/WebRtcBuilder;", "peerConnectionFactory", "getPeerConnectionFactory$webrtc_release", "()Lorg/webrtc/PeerConnectionFactory;", "rootEglBase", "getRootEglBase", "()Lorg/webrtc/EglBase;", "configureBuilder", "", "block", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "dispose", "getDefaultPeerConnectionBuilder", "Lorg/webrtc/PeerConnectionFactory$Builder;", "initialize", "initializePeerConnectionFactory", "webrtc_release"})
public final class WebRtc {
    @NotNull
    public static final WebRtc INSTANCE = new WebRtc();
    @Nullable
    private static EglBase _eglBase;
    @Nullable
    private static PeerConnectionFactory _peerConnectionFactory;
    @NotNull
    private static WebRtcBuilder builder;

    private WebRtc() {
    }

    @NotNull
    public final EglBase getRootEglBase() {
        if (_eglBase == null) {
            this.initialize();
        }
        EglBase eglBase = _eglBase;
        if (eglBase == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        return eglBase;
    }

    @NotNull
    public final PeerConnectionFactory getPeerConnectionFactory$webrtc_release() {
        if (_peerConnectionFactory == null) {
            this.initialize();
        }
        PeerConnectionFactory peerConnectionFactory = _peerConnectionFactory;
        if (peerConnectionFactory == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        return peerConnectionFactory;
    }

    public final void configureBuilder(@NotNull Function1<? super WebRtcBuilder, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        block.invoke((Object)builder);
    }

    public static /* synthetic */ void configureBuilder$default(WebRtc webRtc, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            function1 = configureBuilder.1.INSTANCE;
        }
        webRtc.configureBuilder((Function1<? super WebRtcBuilder, Unit>)function1);
    }

    public final void initialize() {
        if (!(_peerConnectionFactory == null)) {
            boolean bl = false;
            String string = "WebRtc already initialized.";
            throw new IllegalStateException(string.toString());
        }
        EglBase eglBase = builder.getEglBase();
        if (eglBase == null) {
            eglBase = EglBase.create();
        }
        _eglBase = eglBase;
        this.initializePeerConnectionFactory();
        PeerConnectionFactory.Builder builder = WebRtc.builder.getFactoryBuilder();
        if (builder == null) {
            builder = this.getDefaultPeerConnectionBuilder();
        }
        PeerConnectionFactory.Builder pcfBuilder = builder;
        _peerConnectionFactory = pcfBuilder.createPeerConnectionFactory();
    }

    private final void initializePeerConnectionFactory() {
        block0: {
            Logging.Severity severity;
            WebRtcBuilder $this$initializePeerConnectionFactory_u24lambda_u242 = builder;
            boolean bl = false;
            String fieldTrialsString2 = CollectionsKt.joinToString$default((Iterable)$this$initializePeerConnectionFactory_u24lambda_u242.getFieldTrials().entrySet(), (CharSequence)"/", null, null, (int)0, null, (Function1)initializePeerConnectionFactory.1.fieldTrialsString.1.INSTANCE, (int)30, null);
            PeerConnectionFactory.InitializationOptions initOptions = PeerConnectionFactory.InitializationOptions.builder((Context)ApplicationContextHolder.Companion.getContext()).setFieldTrials(fieldTrialsString2).setEnableInternalTracer($this$initializePeerConnectionFactory_u24lambda_u242.getEnableInternalTracer()).createInitializationOptions();
            PeerConnectionFactory.initialize((PeerConnectionFactory.InitializationOptions)initOptions);
            Logging.Severity severity2 = $this$initializePeerConnectionFactory_u24lambda_u242.getLoggingSeverity();
            if (severity2 == null) break block0;
            Logging.Severity it = severity = severity2;
            boolean bl2 = false;
            Logging.enableLogToDebugOutput((Logging.Severity)it);
        }
    }

    private final PeerConnectionFactory.Builder getDefaultPeerConnectionBuilder() {
        DefaultVideoEncoderFactory videoEncoderFactory = new DefaultVideoEncoderFactory(this.getRootEglBase().getEglBaseContext(), true, false);
        DefaultVideoDecoderFactory videoDecoderFactory = new DefaultVideoDecoderFactory(this.getRootEglBase().getEglBaseContext());
        PeerConnectionFactory.Builder builder = PeerConnectionFactory.builder().setVideoEncoderFactory((VideoEncoderFactory)videoEncoderFactory).setVideoDecoderFactory((VideoDecoderFactory)videoDecoderFactory);
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"builder()\n            .s\u2026tory(videoDecoderFactory)");
        return builder;
    }

    public final void dispose() {
        if (_peerConnectionFactory == null) {
            return;
        }
        EglBase eglBase = _eglBase;
        if (eglBase != null) {
            eglBase.release();
        }
        _eglBase = null;
        PeerConnectionFactory peerConnectionFactory = _peerConnectionFactory;
        if (peerConnectionFactory != null) {
            peerConnectionFactory.dispose();
        }
        _peerConnectionFactory = null;
        PeerConnectionFactory.shutdownInternalTracer();
    }

    static {
        builder = new WebRtcBuilder(null, null, false, null, null, 31, null);
    }
}

