/*
 * Decompiled with CFR 0.152.
 */
package io.earcam.utilitarian.site.deploy.netlify;

import io.earcam.unexceptional.CheckedConsumer;
import io.earcam.unexceptional.Closing;
import io.earcam.unexceptional.EmeticStream;
import io.earcam.utilitarian.site.deploy.netlify.Site;
import io.earcam.utilitarian.web.jaxrs.JsonMessageBodyReader;
import io.earcam.utilitarian.web.jaxrs.JsonMessageBodyWriter;
import io.earcam.utilitarian.web.jaxrs.TokenBearerAuthenticator;
import io.earcam.utilitarian.web.jaxrs.UserAgent;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.annotation.WillClose;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonValue;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Netlify {
    private static final String USER_AGENT = "Mozilla/5.0 (X11; YouNix; Linux x86_64; rv:53.0) earcam.io/1.0";
    private static final MediaType APPLICATION_ZIP_TYPE = new MediaType("application", "zip");
    public static final String BASE_URL = "https://api.netlify.com/api/v1/";
    private static final Logger LOG = LoggerFactory.getLogger(Netlify.class);
    private Client client;
    private String baseUrl;

    public Netlify(String accessToken) {
        this(accessToken, ClientBuilder.newBuilder().build(), BASE_URL);
    }

    public Netlify(String accessToken, String baseUrl) {
        this(accessToken, ClientBuilder.newBuilder().build(), baseUrl);
    }

    public Netlify(String accessToken, Client client, String baseUrl) {
        this.client = Netlify.configure(accessToken, client);
        this.baseUrl = this.ensureTrailingSlash(baseUrl);
    }

    private static Client configure(String accessToken, Client client) {
        return (Client)((Client)((Client)((Client)client.register((Object)new TokenBearerAuthenticator(accessToken))).register((Object)new UserAgent(USER_AGENT))).register((Object)new JsonMessageBodyReader())).register((Object)new JsonMessageBodyWriter());
    }

    private String ensureTrailingSlash(String earl) {
        return earl.charAt(earl.length() - 1) == '/' ? earl : earl + '/';
    }

    public Site create(Site site) {
        StreamingOutput o = site::writeJson;
        Response response = this.client.target(this.baseUrl + "sites").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.entity((Object)o, (MediaType)MediaType.APPLICATION_JSON_TYPE));
        Netlify.checkSuccessful(response);
        JsonObject json = (JsonObject)response.readEntity(JsonObject.class);
        return Site.fromJsonObject(json);
    }

    static void checkSuccessful(Response response) {
        if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            throw Netlify.requestFailedException(response);
        }
    }

    static IllegalStateException requestFailedException(Response response) {
        return new IllegalStateException(response.getStatus() + " - " + response.getStatusInfo().getReasonPhrase());
    }

    public List<Site> list() {
        throw new UnsupportedOperationException("TODO");
    }

    public void destroy(String siteName) {
        Site site = this.siteForName(siteName);
        Response response = this.client.target(this.baseUrl + "sites/" + site.id()).request().delete();
        Netlify.checkSuccessful(response);
    }

    private Site siteForName(String siteName) {
        return this.findSiteForName(siteName).orElseThrow(() -> new RuntimeException("No site found with name: " + siteName));
    }

    public void deployZip(String siteName, String uploadPath, Path baseDir) {
        this.deployZip(siteName, Collections.singletonMap(uploadPath, baseDir));
    }

    public void deployZip(String siteName, Map<String, Path> baseDirs) {
        Site site = this.siteForName(siteName);
        this.deploySiteZip(baseDirs, site);
    }

    protected void deploySiteZip(Map<String, Path> baseDirs, Site site) {
        StreamingOutput body = o -> this.writeZip(baseDirs, o);
        Response response = this.client.target(this.baseUrl + "sites/" + site.id() + "/deploys").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.entity((Object)body, (MediaType)APPLICATION_ZIP_TYPE));
        LOG.debug("response:  {}", (Object)response);
        Netlify.checkSuccessful(response);
        JsonObject json = (JsonObject)response.readEntity(JsonObject.class);
        String state = json.getString("state", "unknown");
        if (!"uploaded".equals(state)) {
            throw new IllegalStateException("Response JSON doesn't include 'state=\"uploaded\"', " + state + ".  JSON: " + json);
        }
    }

    protected void writeZip(Map<String, Path> baseDirs, @WillClose OutputStream output) {
        Closing.closeAfterAccepting(ZipOutputStream::new, (Object)output, baseDirs, this::doWriteZip);
    }

    private void doWriteZip(ZipOutputStream zip, Map<String, Path> baseDirs) {
        CheckedConsumer writeThenClose = ((CheckedConsumer)zip::write).andThen(b -> zip.closeEntry());
        for (Map.Entry<String, Path> e : baseDirs.entrySet()) {
            EmeticStream.emesis(x$0 -> Files.walk(x$0, new FileVisitOption[0]), (Object)e.getValue()).sequential().sorted(Path::compareTo).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(p -> !p.getFileName().toString().startsWith(".io.earcam.utilitarian.site.sitemap.")).peek(f -> LOG.debug("Writing to zip: {}", f)).peek(f -> this.zipEntry(zip, e, (Path)f)).map(Files::readAllBytes).forEach(writeThenClose);
        }
    }

    private void zipEntry(ZipOutputStream zip, Map.Entry<String, Path> baseDir, Path file) throws IOException {
        URI relativePath = baseDir.getValue().toUri().relativize(file.toUri());
        String absolutePath = baseDir.getKey() + relativePath;
        ZipEntry entry = new ZipEntry(absolutePath);
        LOG.debug("Absolute path in site: /{}", (Object)absolutePath);
        entry.setTime(0L);
        entry.setCreationTime(FileTime.from(Instant.MIN));
        entry.setLastAccessTime(FileTime.from(Instant.MIN));
        entry.setLastModifiedTime(FileTime.from(Instant.MIN));
        zip.putNextEntry(entry);
    }

    public Optional<Site> findSiteForName(String siteName) {
        List<Site> json = this.siteList();
        return json.stream().filter(s -> siteName.equals(s.name())).findAny();
    }

    List<Site> siteList() {
        return ((JsonArray)this.client.target(this.baseUrl + "sites").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get().readEntity(JsonArray.class)).stream().map(JsonValue::asJsonObject).map(Site::fromJsonObject).collect(Collectors.toList());
    }
}

