/*
 * Decompiled with CFR 0.152.
 */
package io.earcam.wrapped.com.sun.tools.attach;

import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.AttachOperationFailedException;
import com.sun.tools.attach.VirtualMachine;
import com.sun.tools.attach.VirtualMachineDescriptor;
import com.sun.tools.attach.spi.AttachProvider;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import sun.tools.attach.BsdAttachProvider;
import sun.tools.attach.LinuxAttachProvider;
import sun.tools.attach.SolarisAttachProvider;
import sun.tools.attach.WindowsAttachProvider;

public class Provider
extends AttachProvider {
    private static final String SYSTEM_PROPERTY_OS_NAME = "os.name";
    private Optional<Supplier<AttachProvider>> PROVIDER_BY_OS = Provider.findProvider();
    private volatile AttachProvider provider;

    private static Optional<Supplier<AttachProvider>> findProvider() {
        HashMap<String, Supplier<AttachProvider>> map = new HashMap<String, Supplier<AttachProvider>>();
        map.put("windows", WindowsAttachProvider::new);
        map.put("mac os x", BsdAttachProvider::new);
        map.put("bsd", BsdAttachProvider::new);
        map.put("sunos", SolarisAttachProvider::new);
        map.put("solaris", SolarisAttachProvider::new);
        map.put("linux", LinuxAttachProvider::new);
        return map.entrySet().stream().filter(e -> Provider.os().startsWith((String)e.getKey())).map(Map.Entry::getValue).findFirst();
    }

    private static String os() {
        return System.getProperty(SYSTEM_PROPERTY_OS_NAME, "").toLowerCase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public AttachProvider provider() {
        if (this.provider != null) return this.provider;
        Class<Provider> clazz = Provider.class;
        synchronized (Provider.class) {
            if (this.provider != null) return this.provider;
            this.provider = this.PROVIDER_BY_OS.orElseThrow(Provider::providerNotFound).get();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.provider;
        }
    }

    private static UncheckedIOException providerNotFound() {
        return new UncheckedIOException(new AttachOperationFailedException("Failed to locate AttachProvider for this OS: " + Provider.os()));
    }

    @Override
    public VirtualMachine attachVirtualMachine(String arg0) throws AttachNotSupportedException, IOException {
        return this.provider().attachVirtualMachine(arg0);
    }

    @Override
    public List<VirtualMachineDescriptor> listVirtualMachines() {
        return this.provider().listVirtualMachines();
    }

    @Override
    public String name() {
        return this.provider().name();
    }

    @Override
    public String type() {
        return this.provider().type();
    }
}

