/*
 * Decompiled with CFR 0.152.
 */
package sun.jvmstat.perfdata.monitor;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.util.List;
import sun.jvmstat.monitor.Monitor;
import sun.jvmstat.monitor.MonitorException;
import sun.jvmstat.perfdata.monitor.AbstractPerfDataBufferPrologue;
import sun.jvmstat.perfdata.monitor.MonitorStatus;
import sun.jvmstat.perfdata.monitor.PerfDataBufferImpl;

public abstract class AbstractPerfDataBuffer {
    protected PerfDataBufferImpl impl;

    public int getLocalVmId() {
        return this.impl.getLocalVmId();
    }

    public byte[] getBytes() {
        return this.impl.getBytes();
    }

    public int getCapacity() {
        return this.impl.getCapacity();
    }

    public Monitor findByName(String name) throws MonitorException {
        return this.impl.findByName(name);
    }

    public List<Monitor> findByPattern(String patternString) throws MonitorException {
        return this.impl.findByPattern(patternString);
    }

    public MonitorStatus getMonitorStatus() throws MonitorException {
        return this.impl.getMonitorStatus();
    }

    public ByteBuffer getByteBuffer() {
        return this.impl.getByteBuffer();
    }

    protected void createPerfDataBuffer(ByteBuffer bb, int lvmid) throws MonitorException {
        int majorVersion = AbstractPerfDataBufferPrologue.getMajorVersion(bb);
        int minorVersion = AbstractPerfDataBufferPrologue.getMinorVersion(bb);
        String classname = "sun.jvmstat.perfdata.monitor.v" + majorVersion + "_" + minorVersion + ".PerfDataBuffer";
        try {
            Class<?> implClass = Class.forName(classname);
            Constructor<?> cons = implClass.getConstructor(Class.forName("java.nio.ByteBuffer"), Integer.TYPE);
            this.impl = (PerfDataBufferImpl)cons.newInstance(bb, new Integer(lvmid));
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Could not find " + classname + ": " + e.getMessage(), e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Expected constructor missing in " + classname + ": " + e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Unexpected constructor access in " + classname + ": " + e.getMessage(), e);
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException(classname + "is abstract: " + e.getMessage(), e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof MonitorException) {
                throw (MonitorException)cause;
            }
            throw new RuntimeException("Unexpected exception: " + e.getMessage(), e);
        }
    }
}

