/*
 * Decompiled with CFR 0.152.
 */
package sun.jvmstat.perfdata.monitor;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import sun.jvmstat.monitor.Monitor;
import sun.jvmstat.monitor.MonitorException;
import sun.jvmstat.perfdata.monitor.AliasFileParser;
import sun.jvmstat.perfdata.monitor.MonitorStatus;
import sun.jvmstat.perfdata.monitor.SyntaxException;

public abstract class PerfDataBufferImpl {
    protected ByteBuffer buffer;
    protected Map<String, Monitor> monitors;
    protected int lvmid;
    protected Map<String, ArrayList<String>> aliasMap;
    protected Map aliasCache;

    protected PerfDataBufferImpl(ByteBuffer buffer, int lvmid) {
        this.buffer = buffer;
        this.lvmid = lvmid;
        this.monitors = new TreeMap<String, Monitor>();
        this.aliasMap = new HashMap<String, ArrayList<String>>();
        this.aliasCache = new HashMap();
    }

    public int getLocalVmId() {
        return this.lvmid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBytes() {
        ByteBuffer bb = null;
        PerfDataBufferImpl perfDataBufferImpl = this;
        synchronized (perfDataBufferImpl) {
            try {
                if (this.monitors.isEmpty()) {
                    this.buildMonitorMap(this.monitors);
                }
            }
            catch (MonitorException monitorException) {
                // empty catch block
            }
            bb = this.buffer.duplicate();
        }
        bb.rewind();
        byte[] bytes = new byte[bb.limit()];
        bb.get(bytes);
        return bytes;
    }

    public int getCapacity() {
        return this.buffer.capacity();
    }

    ByteBuffer getByteBuffer() {
        return this.buffer;
    }

    private void buildAliasMap() {
        assert (Thread.holdsLock(this));
        URL aliasURL = null;
        String filename = System.getProperty("sun.jvmstat.perfdata.aliasmap");
        if (filename != null) {
            File f = new File(filename);
            try {
                aliasURL = f.toURL();
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException(e);
            }
        } else {
            aliasURL = this.getClass().getResource("/sun/jvmstat/perfdata/resources/aliasmap");
        }
        assert (aliasURL != null);
        AliasFileParser aliasParser = new AliasFileParser(aliasURL);
        try {
            aliasParser.parse(this.aliasMap);
        }
        catch (IOException e) {
            System.err.println("Error processing " + filename + ": " + e.getMessage());
        }
        catch (SyntaxException e) {
            System.err.println("Syntax error parsing " + filename + ": " + e.getMessage());
        }
    }

    protected Monitor findByAlias(String name) {
        ArrayList<String> al;
        assert (Thread.holdsLock(this));
        Monitor m = (Monitor)this.aliasCache.get(name);
        if (m == null && (al = this.aliasMap.get(name)) != null) {
            Iterator<String> i = al.iterator();
            while (i.hasNext() && m == null) {
                String alias = i.next();
                m = this.monitors.get(alias);
            }
        }
        return m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Monitor findByName(String name) throws MonitorException {
        Monitor m = null;
        PerfDataBufferImpl perfDataBufferImpl = this;
        synchronized (perfDataBufferImpl) {
            if (this.monitors.isEmpty()) {
                this.buildMonitorMap(this.monitors);
                this.buildAliasMap();
            }
            if ((m = this.monitors.get(name)) == null) {
                this.getNewMonitors(this.monitors);
                m = this.monitors.get(name);
            }
            if (m == null) {
                m = this.findByAlias(name);
            }
        }
        return m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Monitor> findByPattern(String patternString) throws MonitorException, PatternSyntaxException {
        PerfDataBufferImpl perfDataBufferImpl = this;
        synchronized (perfDataBufferImpl) {
            if (this.monitors.isEmpty()) {
                this.buildMonitorMap(this.monitors);
            } else {
                this.getNewMonitors(this.monitors);
            }
        }
        Pattern pattern = Pattern.compile(patternString);
        Matcher matcher = pattern.matcher("");
        ArrayList<Monitor> matches = new ArrayList<Monitor>();
        Set<Map.Entry<String, Monitor>> monitorSet = this.monitors.entrySet();
        for (Map.Entry<String, Monitor> me : monitorSet) {
            String name = me.getKey();
            Monitor m = me.getValue();
            matcher.reset(name);
            if (!matcher.lookingAt()) continue;
            matches.add(me.getValue());
        }
        return matches;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MonitorStatus getMonitorStatus() throws MonitorException {
        PerfDataBufferImpl perfDataBufferImpl = this;
        synchronized (perfDataBufferImpl) {
            if (this.monitors.isEmpty()) {
                this.buildMonitorMap(this.monitors);
            }
            return this.getMonitorStatus(this.monitors);
        }
    }

    protected abstract MonitorStatus getMonitorStatus(Map<String, Monitor> var1) throws MonitorException;

    protected abstract void buildMonitorMap(Map<String, Monitor> var1) throws MonitorException;

    protected abstract void getNewMonitors(Map<String, Monitor> var1) throws MonitorException;
}

