/*
 * Decompiled with CFR 0.152.
 */
package sun.jvmstat.perfdata.monitor.protocol.rmi;

import java.nio.ByteBuffer;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import sun.jvmstat.monitor.MonitorException;
import sun.jvmstat.monitor.VmIdentifier;
import sun.jvmstat.monitor.event.MonitorStatusChangeEvent;
import sun.jvmstat.monitor.event.VmEvent;
import sun.jvmstat.monitor.event.VmListener;
import sun.jvmstat.monitor.remote.RemoteVm;
import sun.jvmstat.perfdata.monitor.AbstractMonitoredVm;
import sun.jvmstat.perfdata.monitor.CountedTimerTask;
import sun.jvmstat.perfdata.monitor.CountedTimerTaskUtils;
import sun.jvmstat.perfdata.monitor.MonitorStatus;
import sun.jvmstat.perfdata.monitor.protocol.rmi.PerfDataBuffer;

public class RemoteMonitoredVm
extends AbstractMonitoredVm {
    private ArrayList<VmListener> listeners;
    private NotifierTask notifierTask;
    private SamplerTask samplerTask;
    private Timer timer;
    private RemoteVm rvm;
    private ByteBuffer updateBuffer;

    public RemoteMonitoredVm(RemoteVm rvm, VmIdentifier vmid, Timer timer, int interval) throws MonitorException {
        super(vmid, interval);
        this.rvm = rvm;
        this.pdb = new PerfDataBuffer(rvm, vmid.getLocalVmId());
        this.listeners = new ArrayList();
        this.timer = timer;
    }

    public void attach() throws MonitorException {
        this.updateBuffer = this.pdb.getByteBuffer().duplicate();
        if (this.interval > 0) {
            this.samplerTask = new SamplerTask();
            this.timer.schedule((TimerTask)this.samplerTask, 0L, (long)this.interval);
        }
    }

    @Override
    public void detach() {
        try {
            if (this.interval > 0) {
                if (this.samplerTask != null) {
                    this.samplerTask.cancel();
                    this.samplerTask = null;
                }
                if (this.notifierTask != null) {
                    this.notifierTask.cancel();
                    this.notifierTask = null;
                }
                this.sample();
            }
        }
        catch (RemoteException e) {
            System.err.println("Could not read data for remote JVM " + this.vmid);
            e.printStackTrace();
        }
        finally {
            super.detach();
        }
    }

    public void sample() throws RemoteException {
        assert (this.updateBuffer != null);
        ((PerfDataBuffer)this.pdb).sample(this.updateBuffer);
    }

    public RemoteVm getRemoteVm() {
        return this.rvm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addVmListener(VmListener l) {
        ArrayList<VmListener> arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.add(l);
            if (this.notifierTask == null) {
                this.notifierTask = new NotifierTask();
                this.timer.schedule((TimerTask)this.notifierTask, 0L, (long)this.interval);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeVmListener(VmListener l) {
        ArrayList<VmListener> arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.remove(l);
            if (this.listeners.isEmpty() && this.notifierTask != null) {
                this.notifierTask.cancel();
                this.notifierTask = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setInterval(int newInterval) {
        ArrayList<VmListener> arrayList = this.listeners;
        synchronized (arrayList) {
            if (newInterval == this.interval) {
                return;
            }
            int oldInterval = this.interval;
            super.setInterval(newInterval);
            if (this.samplerTask != null) {
                this.samplerTask.cancel();
                SamplerTask oldSamplerTask = this.samplerTask;
                this.samplerTask = new SamplerTask();
                CountedTimerTaskUtils.reschedule(this.timer, oldSamplerTask, this.samplerTask, oldInterval, newInterval);
            }
            if (this.notifierTask != null) {
                this.notifierTask.cancel();
                NotifierTask oldNotifierTask = this.notifierTask;
                this.notifierTask = new NotifierTask();
                CountedTimerTaskUtils.reschedule(this.timer, oldNotifierTask, this.notifierTask, oldInterval, newInterval);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireMonitorStatusChangedEvents(List inserted, List removed) {
        ArrayList registered = null;
        MonitorStatusChangeEvent ev = null;
        ArrayList<VmListener> arrayList = this.listeners;
        synchronized (arrayList) {
            registered = (ArrayList)this.listeners.clone();
        }
        for (VmListener l : registered) {
            if (ev == null) {
                ev = new MonitorStatusChangeEvent(this, inserted, removed);
            }
            l.monitorStatusChanged(ev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireMonitorsUpdatedEvents() {
        ArrayList registered = null;
        VmEvent ev = null;
        ArrayList<VmListener> arrayList = this.listeners;
        synchronized (arrayList) {
            registered = (ArrayList)this.listeners.clone();
        }
        for (VmListener l : registered) {
            if (ev == null) {
                ev = new VmEvent(this);
            }
            l.monitorsUpdated(ev);
        }
    }

    private class SamplerTask
    extends CountedTimerTask {
        private SamplerTask() {
        }

        @Override
        public void run() {
            super.run();
            try {
                RemoteMonitoredVm.this.sample();
                RemoteMonitoredVm.this.fireMonitorsUpdatedEvents();
            }
            catch (RemoteException e) {
                System.err.println("Exception taking sample for " + RemoteMonitoredVm.this.getVmIdentifier());
                e.printStackTrace();
                this.cancel();
            }
        }
    }

    private class NotifierTask
    extends CountedTimerTask {
        private NotifierTask() {
        }

        @Override
        public void run() {
            super.run();
            try {
                MonitorStatus status = RemoteMonitoredVm.this.getMonitorStatus();
                List inserted = status.getInserted();
                List removed = status.getRemoved();
                if (!inserted.isEmpty() || !removed.isEmpty()) {
                    RemoteMonitoredVm.this.fireMonitorStatusChangedEvents(inserted, removed);
                }
            }
            catch (MonitorException e) {
                System.err.println("Exception updating monitors for " + RemoteMonitoredVm.this.getVmIdentifier());
                e.printStackTrace();
            }
        }
    }
}

