/*
 * Decompiled with CFR 0.152.
 */
package sun.jvmstat.perfdata.monitor.v2_0;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.util.ArrayList;
import java.util.Map;
import sun.jvmstat.monitor.AbstractMonitor;
import sun.jvmstat.monitor.IntegerMonitor;
import sun.jvmstat.monitor.Monitor;
import sun.jvmstat.monitor.MonitorException;
import sun.jvmstat.monitor.Units;
import sun.jvmstat.monitor.Variability;
import sun.jvmstat.perfdata.monitor.MonitorDataException;
import sun.jvmstat.perfdata.monitor.MonitorStatus;
import sun.jvmstat.perfdata.monitor.MonitorStructureException;
import sun.jvmstat.perfdata.monitor.MonitorTypeException;
import sun.jvmstat.perfdata.monitor.PerfDataBufferImpl;
import sun.jvmstat.perfdata.monitor.PerfIntegerMonitor;
import sun.jvmstat.perfdata.monitor.PerfLongMonitor;
import sun.jvmstat.perfdata.monitor.PerfStringConstantMonitor;
import sun.jvmstat.perfdata.monitor.PerfStringVariableMonitor;
import sun.jvmstat.perfdata.monitor.v2_0.PerfDataBufferPrologue;
import sun.jvmstat.perfdata.monitor.v2_0.TypeCode;

public class PerfDataBuffer
extends PerfDataBufferImpl {
    private static final boolean DEBUG = false;
    private static final int syncWaitMs = Integer.getInteger("sun.jvmstat.perdata.syncWaitMs", 5000);
    private static final ArrayList EMPTY_LIST = new ArrayList(0);
    private static final int PERFDATA_ENTRYLENGTH_OFFSET = 0;
    private static final int PERFDATA_ENTRYLENGTH_SIZE = 4;
    private static final int PERFDATA_NAMEOFFSET_OFFSET = 4;
    private static final int PERFDATA_NAMEOFFSET_SIZE = 4;
    private static final int PERFDATA_VECTORLENGTH_OFFSET = 8;
    private static final int PERFDATA_VECTORLENGTH_SIZE = 4;
    private static final int PERFDATA_DATATYPE_OFFSET = 12;
    private static final int PERFDATA_DATATYPE_SIZE = 1;
    private static final int PERFDATA_FLAGS_OFFSET = 13;
    private static final int PERFDATA_FLAGS_SIZE = 1;
    private static final int PERFDATA_DATAUNITS_OFFSET = 14;
    private static final int PERFDATA_DATAUNITS_SIZE = 1;
    private static final int PERFDATA_DATAVAR_OFFSET = 15;
    private static final int PERFDATA_DATAVAR_SIZE = 1;
    private static final int PERFDATA_DATAOFFSET_OFFSET = 16;
    private static final int PERFDATA_DATAOFFSET_SIZE = 4;
    PerfDataBufferPrologue prologue;
    int nextEntry;
    long lastNumEntries;
    IntegerMonitor overflow;
    ArrayList<Monitor> insertedMonitors;

    public PerfDataBuffer(ByteBuffer buffer, int lvmid) throws MonitorException {
        super(buffer, lvmid);
        this.prologue = new PerfDataBufferPrologue(buffer);
        this.buffer.order(this.prologue.getByteOrder());
    }

    @Override
    protected void buildMonitorMap(Map<String, Monitor> map) throws MonitorException {
        assert (Thread.holdsLock(this));
        this.buffer.rewind();
        this.buildPseudoMonitors(map);
        this.synchWithTarget();
        this.nextEntry = this.prologue.getEntryOffset();
        int numEntries = this.prologue.getNumEntries();
        Monitor monitor = this.getNextMonitorEntry();
        while (monitor != null) {
            map.put(monitor.getName(), monitor);
            monitor = this.getNextMonitorEntry();
        }
        this.lastNumEntries = numEntries;
        this.insertedMonitors = new ArrayList<Monitor>(map.values());
    }

    @Override
    protected void getNewMonitors(Map<String, Monitor> map) throws MonitorException {
        assert (Thread.holdsLock(this));
        int numEntries = this.prologue.getNumEntries();
        if ((long)numEntries > this.lastNumEntries) {
            this.lastNumEntries = numEntries;
            Monitor monitor = this.getNextMonitorEntry();
            while (monitor != null) {
                String name = monitor.getName();
                if (!map.containsKey(name)) {
                    map.put(name, monitor);
                    if (this.insertedMonitors != null) {
                        this.insertedMonitors.add(monitor);
                    }
                }
                monitor = this.getNextMonitorEntry();
            }
        }
    }

    @Override
    protected MonitorStatus getMonitorStatus(Map<String, Monitor> map) throws MonitorException {
        assert (Thread.holdsLock(this));
        assert (this.insertedMonitors != null);
        this.getNewMonitors(map);
        ArrayList removed = EMPTY_LIST;
        ArrayList<Monitor> inserted = this.insertedMonitors;
        this.insertedMonitors = new ArrayList();
        return new MonitorStatus(inserted, removed);
    }

    protected void buildPseudoMonitors(Map<String, Monitor> map) {
        AbstractMonitor monitor = null;
        String name = null;
        IntBuffer ib = null;
        name = "sun.perfdata.majorVersion";
        ib = this.prologue.majorVersionBuffer();
        monitor = new PerfIntegerMonitor(name, Units.NONE, Variability.CONSTANT, false, ib);
        map.put(name, monitor);
        name = "sun.perfdata.minorVersion";
        ib = this.prologue.minorVersionBuffer();
        monitor = new PerfIntegerMonitor(name, Units.NONE, Variability.CONSTANT, false, ib);
        map.put(name, monitor);
        name = "sun.perfdata.size";
        ib = this.prologue.sizeBuffer();
        monitor = new PerfIntegerMonitor(name, Units.BYTES, Variability.MONOTONIC, false, ib);
        map.put(name, monitor);
        name = "sun.perfdata.used";
        ib = this.prologue.usedBuffer();
        monitor = new PerfIntegerMonitor(name, Units.BYTES, Variability.MONOTONIC, false, ib);
        map.put(name, monitor);
        name = "sun.perfdata.overflow";
        ib = this.prologue.overflowBuffer();
        monitor = new PerfIntegerMonitor(name, Units.BYTES, Variability.MONOTONIC, false, ib);
        map.put(name, monitor);
        this.overflow = monitor;
        name = "sun.perfdata.timestamp";
        LongBuffer lb = this.prologue.modificationTimeStampBuffer();
        monitor = new PerfLongMonitor(name, Units.TICKS, Variability.MONOTONIC, false, lb);
        map.put(name, monitor);
    }

    protected void synchWithTarget() throws MonitorException {
        long timeLimit = System.currentTimeMillis() + (long)syncWaitMs;
        this.log("synchWithTarget: " + this.lvmid + " ");
        while (!this.prologue.isAccessible()) {
            this.log(".");
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (System.currentTimeMillis() <= timeLimit) continue;
            this.logln("failed: " + this.lvmid);
            throw new MonitorException("Could not synchronize with target");
        }
        this.logln("success: " + this.lvmid);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Monitor getNextMonitorEntry() throws MonitorException {
        void var1_6;
        byte b;
        Object var1_1 = null;
        if (this.nextEntry % 4 != 0) {
            throw new MonitorStructureException("Misaligned entry index: " + Integer.toHexString(this.nextEntry));
        }
        if (this.nextEntry < 0 || this.nextEntry > this.buffer.limit()) {
            throw new MonitorStructureException("Entry index out of bounds: " + Integer.toHexString(this.nextEntry) + ", limit = " + Integer.toHexString(this.buffer.limit()));
        }
        if (this.nextEntry == this.buffer.limit()) {
            this.logln("getNextMonitorEntry(): nextEntry == buffer.limit(): returning");
            return null;
        }
        this.buffer.position(this.nextEntry);
        int entryStart = this.buffer.position();
        int entryLength = this.buffer.getInt();
        if (entryLength < 0 || entryLength > this.buffer.limit()) {
            throw new MonitorStructureException("Invalid entry length: entryLength = " + entryLength + " (0x" + Integer.toHexString(entryLength) + ")");
        }
        if (entryStart + entryLength > this.buffer.limit()) {
            throw new MonitorStructureException("Entry extends beyond end of buffer:  entryStart = 0x" + Integer.toHexString(entryStart) + " entryLength = 0x" + Integer.toHexString(entryLength) + " buffer limit = 0x" + Integer.toHexString(this.buffer.limit()));
        }
        if (entryLength == 0) {
            return null;
        }
        int nameOffset = this.buffer.getInt();
        int vectorLength = this.buffer.getInt();
        byte typeCodeByte = this.buffer.get();
        byte flags = this.buffer.get();
        byte unitsByte = this.buffer.get();
        byte varByte = this.buffer.get();
        int dataOffset = this.buffer.getInt();
        this.dump_entry_fixed(entryStart, nameOffset, vectorLength, typeCodeByte, flags, unitsByte, varByte, dataOffset);
        Units units = Units.toUnits(unitsByte);
        Variability variability = Variability.toVariability(varByte);
        TypeCode typeCode = null;
        boolean supported = (flags & 1) != 0;
        try {
            typeCode = TypeCode.toTypeCode(typeCodeByte);
        }
        catch (IllegalArgumentException e) {
            throw new MonitorStructureException("Illegal type code encountered: entry_offset = 0x" + Integer.toHexString(this.nextEntry) + ", type_code = " + Integer.toHexString(typeCodeByte));
        }
        if (nameOffset > entryLength) {
            throw new MonitorStructureException("Field extends beyond entry bounds entry_offset = 0x" + Integer.toHexString(this.nextEntry) + ", name_offset = 0x" + Integer.toHexString(nameOffset));
        }
        if (dataOffset > entryLength) {
            throw new MonitorStructureException("Field extends beyond entry bounds: entry_offset = 0x" + Integer.toHexString(this.nextEntry) + ", data_offset = 0x" + Integer.toHexString(dataOffset));
        }
        if (variability == Variability.INVALID) {
            throw new MonitorDataException("Invalid variability attribute: entry_offset = 0x" + Integer.toHexString(this.nextEntry) + ", variability = 0x" + Integer.toHexString(varByte));
        }
        if (units == Units.INVALID) {
            throw new MonitorDataException("Invalid units attribute: entry_offset = 0x" + Integer.toHexString(this.nextEntry) + ", units = 0x" + Integer.toHexString(unitsByte));
        }
        assert (this.buffer.position() == entryStart + nameOffset);
        assert (dataOffset > nameOffset);
        int maxNameLength = dataOffset - nameOffset;
        assert (maxNameLength < entryLength);
        byte[] nameBytes = new byte[maxNameLength];
        int nameLength = 0;
        while ((b = this.buffer.get()) != 0 && nameLength < maxNameLength) {
            nameBytes[nameLength++] = b;
        }
        assert (nameLength < maxNameLength);
        assert (this.buffer.position() <= entryStart + dataOffset);
        String name = new String(nameBytes, 0, nameLength);
        int dataSize = entryLength - dataOffset;
        this.buffer.position(entryStart + dataOffset);
        this.dump_entry_variable(name, this.buffer, dataSize);
        if (vectorLength == 0) {
            if (typeCode != TypeCode.LONG) throw new MonitorTypeException("Unexpected type code encountered: entry_offset = 0x" + Integer.toHexString(this.nextEntry) + ", name = " + name + ", type_code = " + typeCode + " (0x" + Integer.toHexString(typeCodeByte) + ")");
            LongBuffer lb = this.buffer.asLongBuffer();
            lb.limit(1);
            PerfLongMonitor perfLongMonitor = new PerfLongMonitor(name, units, variability, supported, lb);
        } else {
            if (typeCode != TypeCode.BYTE) throw new MonitorTypeException("Unexpected type code encountered: entry_offset = 0x" + Integer.toHexString(this.nextEntry) + ", name = " + name + ", type_code = " + typeCode + " (0x" + Integer.toHexString(typeCodeByte) + ")");
            if (units != Units.STRING) {
                throw new MonitorTypeException("Unexpected vector type encounterd: entry_offset = " + Integer.toHexString(this.nextEntry) + ", name = " + name + ", type_code = " + typeCode + " (0x" + Integer.toHexString(typeCodeByte) + "), units = " + units + " (0x" + Integer.toHexString(unitsByte) + ")");
            }
            ByteBuffer bb = this.buffer.slice();
            bb.limit(vectorLength);
            if (variability == Variability.CONSTANT) {
                PerfStringConstantMonitor perfStringConstantMonitor = new PerfStringConstantMonitor(name, supported, bb);
            } else if (variability == Variability.VARIABLE) {
                PerfStringVariableMonitor perfStringVariableMonitor = new PerfStringVariableMonitor(name, supported, bb, vectorLength - 1);
            } else {
                if (variability == Variability.MONOTONIC) {
                    throw new MonitorDataException("Unexpected variability attribute: entry_offset = 0x" + Integer.toHexString(this.nextEntry) + " name = " + name + ", variability = " + variability + " (0x" + Integer.toHexString(varByte) + ")");
                }
                assert (false);
            }
        }
        this.nextEntry = entryStart + entryLength;
        return var1_6;
    }

    private void dumpAll(Map<String, Monitor> map, int lvmid) {
    }

    private void dump_entry_fixed(int entry_start, int nameOffset, int vectorLength, byte typeCodeByte, byte flags, byte unitsByte, byte varByte, int dataOffset) {
    }

    private void dump_entry_variable(String name, ByteBuffer bb, int size) {
    }

    private void logln(String s) {
    }

    private void log(String s) {
    }
}

