/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.attach;

import com.sun.tools.attach.AgentLoadException;
import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.AttachOperationFailedException;
import com.sun.tools.attach.spi.AttachProvider;
import java.io.IOException;
import java.io.InputStream;
import java.util.Random;
import sun.tools.attach.HotSpotVirtualMachine;

public class WindowsVirtualMachine
extends HotSpotVirtualMachine {
    private static byte[] stub;
    private volatile long hProcess;

    WindowsVirtualMachine(AttachProvider provider, String id) throws AttachNotSupportedException, IOException {
        super(provider, id);
        int pid;
        try {
            pid = Integer.parseInt(id);
        }
        catch (NumberFormatException x) {
            throw new AttachNotSupportedException("Invalid process identifier");
        }
        this.hProcess = WindowsVirtualMachine.openProcess(pid);
        try {
            WindowsVirtualMachine.enqueue(this.hProcess, stub, null, null, new Object[0]);
        }
        catch (IOException x) {
            throw new AttachNotSupportedException(x.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void detach() throws IOException {
        WindowsVirtualMachine windowsVirtualMachine = this;
        synchronized (windowsVirtualMachine) {
            if (this.hProcess != -1L) {
                WindowsVirtualMachine.closeProcess(this.hProcess);
                this.hProcess = -1L;
            }
        }
    }

    @Override
    InputStream execute(String cmd, Object ... args) throws AgentLoadException, IOException {
        assert (args.length <= 3);
        int r = new Random().nextInt();
        String pipename = "\\\\.\\pipe\\javatool" + r;
        long hPipe = WindowsVirtualMachine.createPipe(pipename);
        if (this.hProcess == -1L) {
            WindowsVirtualMachine.closePipe(hPipe);
            throw new IOException("Detached from target VM");
        }
        try {
            WindowsVirtualMachine.enqueue(this.hProcess, stub, cmd, pipename, args);
            WindowsVirtualMachine.connectPipe(hPipe);
            PipedInputStream is = new PipedInputStream(hPipe);
            int status = this.readInt(is);
            if (status != 0) {
                String message = this.readErrorMessage(is);
                if (cmd.equals("load")) {
                    throw new AgentLoadException("Failed to load agent library");
                }
                if (message == null) {
                    throw new AttachOperationFailedException("Command failed in target VM");
                }
                throw new AttachOperationFailedException(message);
            }
            return is;
        }
        catch (IOException ioe) {
            WindowsVirtualMachine.closePipe(hPipe);
            throw ioe;
        }
    }

    static native void init();

    static native byte[] generateStub();

    static native long openProcess(int var0) throws IOException;

    static native void closeProcess(long var0) throws IOException;

    static native long createPipe(String var0) throws IOException;

    static native void closePipe(long var0) throws IOException;

    static native void connectPipe(long var0) throws IOException;

    static native int readPipe(long var0, byte[] var2, int var3, int var4) throws IOException;

    static native void enqueue(long var0, byte[] var2, String var3, String var4, Object ... var5) throws IOException;

    static {
        System.loadLibrary("attach");
        WindowsVirtualMachine.init();
        stub = WindowsVirtualMachine.generateStub();
    }

    private class PipedInputStream
    extends InputStream {
        private long hPipe;

        public PipedInputStream(long hPipe) {
            this.hPipe = hPipe;
        }

        @Override
        public synchronized int read() throws IOException {
            byte[] b = new byte[1];
            int n = this.read(b, 0, 1);
            if (n == 1) {
                return b[0] & 0xFF;
            }
            return -1;
        }

        @Override
        public synchronized int read(byte[] bs, int off, int len) throws IOException {
            if (off < 0 || off > bs.length || len < 0 || off + len > bs.length || off + len < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return 0;
            }
            return WindowsVirtualMachine.readPipe(this.hPipe, bs, off, len);
        }

        @Override
        public void close() throws IOException {
            if (this.hPipe != -1L) {
                WindowsVirtualMachine.closePipe(this.hPipe);
                this.hPipe = -1L;
            }
        }
    }
}

