/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.enhance.agent;

import io.ebean.enhance.agent.ClassMeta;
import io.ebean.enhance.agent.DeferredCode;
import io.ebean.enhance.asm.MethodVisitor;
import io.ebean.enhance.asm.Opcodes;
import java.util.ArrayList;
import java.util.List;

public class ConstructorDeferredCode
implements Opcodes {
    private static final ALoad ALOAD_INSTRUCTION = new ALoad();
    private static final Dup DUP_INSTRUCTION = new Dup();
    private final ClassMeta meta;
    private final MethodVisitor mv;
    private final List<DeferredCode> codes = new ArrayList<DeferredCode>();

    ConstructorDeferredCode(ClassMeta meta, MethodVisitor mv) {
        this.meta = meta;
        this.mv = mv;
    }

    public boolean deferVisitVarInsn(int opcode, int var) {
        this.flush();
        if (opcode == 25 && var == 0) {
            this.codes.add(ALOAD_INSTRUCTION);
            return true;
        }
        return false;
    }

    public boolean deferVisitTypeInsn(int opcode, String type) {
        if (opcode == 187 && this.isCollection(type) && this.stateAload()) {
            this.codes.add(new NewCollection(type));
            return true;
        }
        if (opcode == 192 && this.stateCollectionInit()) {
            this.codes.add(new CheckCastCollection(type));
            return true;
        }
        this.flush();
        return false;
    }

    public boolean deferVisitInsn(int opcode) {
        if (opcode == 89 && this.stateNewCollection()) {
            this.codes.add(DUP_INSTRUCTION);
            return true;
        }
        this.flush();
        return false;
    }

    public boolean deferVisitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
        if (opcode == 183 && this.stateDup() && this.isCollectionInit(owner, name, desc)) {
            this.codes.add(new CollectionInit(opcode, owner, name, desc, itf));
            return true;
        }
        this.flush();
        return false;
    }

    private boolean isCollectionInit(String owner, String name, String desc) {
        return name.equals("<init>") && desc.equals("()V") && this.isCollection(owner);
    }

    public boolean consumeVisitFieldInsn(int opcode, String owner, String name, String desc) {
        if (opcode == 181 && this.stateConsumeDeferred() && this.meta.isFieldPersistentMany(name)) {
            if (this.meta.isLog(2)) {
                this.meta.log("... consumed init of many: " + name);
            }
            this.codes.clear();
            return true;
        }
        this.flush();
        return false;
    }

    protected void flush() {
        if (!this.codes.isEmpty()) {
            for (DeferredCode code : this.codes) {
                if (this.meta.isLog(4)) {
                    this.meta.log("... flush deferred: " + code);
                }
                code.write(this.mv);
            }
            this.codes.clear();
        }
    }

    private boolean stateAload() {
        return this.codes.size() == 1;
    }

    private boolean stateNewCollection() {
        return this.codes.size() == 2;
    }

    private boolean stateDup() {
        return this.codes.size() == 3;
    }

    private boolean stateCollectionInit() {
        return this.codes.size() == 4;
    }

    private boolean stateConsumeDeferred() {
        int size = this.codes.size();
        return size == 4 || size == 5;
    }

    private boolean isCollection(String type) {
        return "java/util/ArrayList".equals(type) || "java/util/LinkedHashSet".equals(type) || "java/util/HashSet".equals(type);
    }

    static class CollectionInit
    implements DeferredCode {
        final int opcode;
        final String owner;
        final String name;
        final String desc;
        final boolean itf;

        public CollectionInit(int opcode, String owner, String name, String desc, boolean itf) {
            this.opcode = opcode;
            this.owner = owner;
            this.name = name;
            this.desc = desc;
            this.itf = itf;
        }

        @Override
        public void write(MethodVisitor mv) {
            mv.visitMethodInsn(this.opcode, this.owner, this.name, this.desc, this.itf);
        }

        public String toString() {
            return "INVOKESPECIAL " + this.owner + ".<init> ()V";
        }
    }

    static class CheckCastCollection
    implements DeferredCode {
        final String type;

        CheckCastCollection(String type) {
            this.type = type;
        }

        @Override
        public void write(MethodVisitor mv) {
            mv.visitTypeInsn(192, this.type);
        }

        public String toString() {
            return "CHECKCAST " + this.type;
        }
    }

    static class NewCollection
    implements DeferredCode {
        final String type;

        NewCollection(String type) {
            this.type = type;
        }

        @Override
        public void write(MethodVisitor mv) {
            mv.visitTypeInsn(187, this.type);
        }

        public String toString() {
            return "NEW " + this.type;
        }
    }

    static class Dup
    implements DeferredCode {
        Dup() {
        }

        @Override
        public void write(MethodVisitor mv) {
            mv.visitInsn(89);
        }

        public String toString() {
            return "DUP";
        }
    }

    static class ALoad
    implements DeferredCode {
        ALoad() {
        }

        @Override
        public void write(MethodVisitor mv) {
            mv.visitVarInsn(25, 0);
        }

        public String toString() {
            return "ALOAD 0";
        }
    }
}

