/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.enhance.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;

class DistillPackages {
    private TreeSet<String> treeSet = new TreeSet();

    DistillPackages() {
    }

    DistillPackages add(Collection<String> packages) {
        if (packages != null) {
            this.treeSet.addAll(packages);
        }
        return this;
    }

    DistillPackages addRaw(String packages) {
        if (packages != null) {
            String[] split = packages.split(",|;| ");
            for (int i = 0; i < split.length; ++i) {
                String pkg = split[i].trim();
                if (pkg.isEmpty()) continue;
                this.treeSet.add(pkg);
            }
        }
        return this;
    }

    List<String> distill() {
        ArrayList<String> distilled = new ArrayList<String>();
        for (String pack : this.treeSet) {
            if (!this.notAlreadyContained(distilled, pack)) continue;
            distilled.add(pack);
        }
        return distilled;
    }

    private boolean notAlreadyContained(List<String> distilled, String pack) {
        for (int i = 0; i < distilled.size(); ++i) {
            if (!pack.startsWith(distilled.get(i))) continue;
            return false;
        }
        return true;
    }
}

