/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.enhance.querybean;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public class AgentManifestReader {
    private final Set<String> packageSet = new HashSet<String>();

    public static Set<String> read(ClassLoader classLoader, Set<String> initialPackages) {
        try {
            return new AgentManifestReader(initialPackages).readManifests(classLoader, "META-INF/ebean-typequery.mf").readManifests(classLoader, "META-INF/ebean.mf").getPackages();
        }
        catch (IOException e) {
            System.err.println("QueryBean Agent: error reading META-INF/ebean-typequery.mf manifest resources");
            e.printStackTrace();
            return new HashSet<String>();
        }
    }

    public AgentManifestReader(Set<String> initialPackages) {
        if (initialPackages != null) {
            this.packageSet.addAll(initialPackages);
        }
    }

    public AgentManifestReader() {
    }

    public void addRaw(String content) {
        this.add(content.replace("packages:", "").trim());
    }

    public Set<String> getPackages() {
        return this.packageSet;
    }

    private AgentManifestReader readManifests(ClassLoader classLoader, String path) throws IOException {
        Enumeration<URL> resources = classLoader.getResources(path);
        while (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            try {
                this.addResource(url.openStream());
            }
            catch (IOException e) {
                System.err.println("Error reading manifest resources " + url);
                e.printStackTrace();
            }
        }
        return this;
    }

    private void addResource(InputStream is) throws IOException {
        try {
            this.addManifest(new Manifest(is));
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                System.err.println("Error closing manifest resource");
                e.printStackTrace();
            }
        }
    }

    private void addManifest(Manifest manifest) {
        Attributes attributes = manifest.getMainAttributes();
        this.add(attributes.getValue("packages"));
    }

    private void add(String packages) {
        if (packages != null) {
            String[] split = packages.split(",|;| ");
            for (int i = 0; i < split.length; ++i) {
                String pkg = split[i].trim();
                if (pkg.isEmpty()) continue;
                this.packageSet.add(pkg);
            }
        }
    }
}

