/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.enhance.transactional;

import io.ebean.enhance.asm.AnnotationVisitor;
import io.ebean.enhance.asm.MethodVisitor;
import io.ebean.enhance.asm.Type;
import io.ebean.enhance.asm.commons.FinallyAdapter;
import io.ebean.enhance.common.AnnotationInfo;
import io.ebean.enhance.common.AnnotationInfoVisitor;
import io.ebean.enhance.common.EnhanceConstants;
import io.ebean.enhance.common.VisitUtil;
import io.ebean.enhance.transactional.ClassAdapterTransactional;
import java.util.ArrayList;

public class ScopeTransAdapter
extends FinallyAdapter
implements EnhanceConstants {
    private static final Type txScopeType = Type.getType("Lio/ebean/TxScope;");
    private static final Type scopeTransType = Type.getType("Lio/ebeaninternal/api/ScopeTrans;");
    private static final Type helpScopeTrans = Type.getType("Lio/ebeaninternal/api/HelpScopeTrans;");
    private final AnnotationInfo annotationInfo;
    private final ClassAdapterTransactional owner;
    private final String methodName;
    private boolean transactional;
    private int posTxScope;
    private int posScopeTrans;

    public ScopeTransAdapter(ClassAdapterTransactional owner, MethodVisitor mv, int access, String name, String desc) {
        super(327680, mv, access, name, desc);
        this.owner = owner;
        this.methodName = name;
        AnnotationInfo parentInfo = owner.getClassAnnotationInfo();
        AnnotationInfo interfaceInfo = owner.getInterfaceTransactionalInfo(name, desc);
        if (parentInfo == null) {
            parentInfo = interfaceInfo;
        } else {
            parentInfo.setParent(interfaceInfo);
        }
        this.annotationInfo = new AnnotationInfo(parentInfo);
        this.transactional = parentInfo != null;
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        AnnotationVisitor av = super.visitAnnotation(desc, visible);
        if (desc.equals("Lio/ebean/annotation/Transactional;")) {
            this.transactional = true;
            return new AnnotationInfoVisitor(null, this.annotationInfo, av);
        }
        return av;
    }

    private void setTxType(Object txType) {
        this.mv.visitVarInsn(25, this.posTxScope);
        this.mv.visitLdcInsn(txType.toString());
        this.mv.visitMethodInsn(184, "io/ebean/TxType", "valueOf", "(Ljava/lang/String;)Lio/ebean/TxType;", false);
        this.mv.visitMethodInsn(182, "io/ebean/TxScope", "setType", "(Lio/ebean/TxType;)Lio/ebean/TxScope;", false);
        this.mv.visitInsn(87);
    }

    private void setTxIsolation(Object txIsolation) {
        this.mv.visitVarInsn(25, this.posTxScope);
        this.mv.visitLdcInsn(txIsolation.toString());
        this.mv.visitMethodInsn(184, "io/ebean/TxIsolation", "valueOf", "(Ljava/lang/String;)Lio/ebean/TxIsolation;", false);
        this.mv.visitMethodInsn(182, "io/ebean/TxScope", "setIsolation", "(Lio/ebean/TxIsolation;)Lio/ebean/TxScope;", false);
        this.mv.visitInsn(87);
    }

    private void setBatch(Object batch) {
        this.mv.visitVarInsn(25, this.posTxScope);
        this.mv.visitLdcInsn(batch.toString());
        this.mv.visitMethodInsn(184, "io/ebean/PersistBatch", "valueOf", "(Ljava/lang/String;)Lio/ebean/PersistBatch;", false);
        this.mv.visitMethodInsn(182, "io/ebean/TxScope", "setBatch", "(Lio/ebean/PersistBatch;)Lio/ebean/TxScope;", false);
        this.mv.visitInsn(87);
    }

    private void setBatchOnCascade(Object batch) {
        this.mv.visitVarInsn(25, this.posTxScope);
        this.mv.visitLdcInsn(batch.toString());
        this.mv.visitMethodInsn(184, "io/ebean/PersistBatch", "valueOf", "(Ljava/lang/String;)Lio/ebean/PersistBatch;", false);
        this.mv.visitMethodInsn(182, "io/ebean/TxScope", "setBatchOnCascade", "(Lio/ebean/PersistBatch;)Lio/ebean/TxScope;", false);
        this.mv.visitInsn(87);
    }

    private void setBatchSize(Object batchSize) {
        this.mv.visitVarInsn(25, this.posTxScope);
        VisitUtil.visitIntInsn(this.mv, Integer.parseInt(batchSize.toString()));
        this.mv.visitMethodInsn(182, "io/ebean/TxScope", "setBatchSize", "(I)Lio/ebean/TxScope;", false);
        this.mv.visitInsn(87);
    }

    private void setServerName(Object serverName) {
        this.mv.visitVarInsn(25, this.posTxScope);
        this.mv.visitLdcInsn(serverName.toString());
        this.mv.visitMethodInsn(182, "io/ebean/TxScope", "setServerName", "(Ljava/lang/String;)Lio/ebean/TxScope;", false);
        this.mv.visitInsn(87);
    }

    private void setGetGeneratedKeys(Object getGeneratedKeys) {
        boolean getKeys = (Boolean)getGeneratedKeys;
        if (!getKeys) {
            this.mv.visitVarInsn(25, this.posTxScope);
            this.mv.visitMethodInsn(182, "io/ebean/TxScope", "setSkipGeneratedKeys", "()Lio/ebean/TxScope;", false);
        }
    }

    private void setReadOnly(Object readOnlyObj) {
        boolean readOnly = (Boolean)readOnlyObj;
        this.mv.visitVarInsn(25, this.posTxScope);
        if (readOnly) {
            this.mv.visitInsn(4);
        } else {
            this.mv.visitInsn(3);
        }
        this.mv.visitMethodInsn(182, "io/ebean/TxScope", "setReadOnly", "(Z)Lio/ebean/TxScope;", false);
    }

    private void setNoRollbackFor(Object noRollbackFor) {
        ArrayList list = (ArrayList)noRollbackFor;
        for (int i = 0; i < list.size(); ++i) {
            Type throwType = (Type)list.get(i);
            this.mv.visitVarInsn(25, this.posTxScope);
            this.mv.visitLdcInsn(throwType);
            this.mv.visitMethodInsn(182, txScopeType.getInternalName(), "setNoRollbackFor", "(Ljava/lang/Class;)Lio/ebean/TxScope;", false);
            this.mv.visitInsn(87);
        }
    }

    private void setRollbackFor(Object rollbackFor) {
        ArrayList list = (ArrayList)rollbackFor;
        for (int i = 0; i < list.size(); ++i) {
            Type throwType = (Type)list.get(i);
            this.mv.visitVarInsn(25, this.posTxScope);
            this.mv.visitLdcInsn(throwType);
            this.mv.visitMethodInsn(182, txScopeType.getInternalName(), "setRollbackFor", "(Ljava/lang/Class;)Lio/ebean/TxScope;", false);
            this.mv.visitInsn(87);
        }
    }

    @Override
    protected void onMethodEnter() {
        Object serverName;
        Object rollbackFor;
        Object noRollbackFor;
        Object readOnly;
        Object getGeneratedKeys;
        Object batchSize;
        Object batchOnCascade;
        Object batch;
        Object txIsolation;
        if (!this.transactional) {
            return;
        }
        this.owner.transactionalMethod(this.methodName, this.methodDesc, this.annotationInfo);
        this.posTxScope = this.newLocal(txScopeType);
        this.posScopeTrans = this.newLocal(scopeTransType);
        this.mv.visitTypeInsn(187, txScopeType.getInternalName());
        this.mv.visitInsn(89);
        this.mv.visitMethodInsn(183, txScopeType.getInternalName(), "<init>", "()V", false);
        this.mv.visitVarInsn(58, this.posTxScope);
        Object txType = this.annotationInfo.getValue("type");
        if (txType != null) {
            this.setTxType(txType);
        }
        if ((txIsolation = this.annotationInfo.getValue("isolation")) != null) {
            this.setTxIsolation(txIsolation);
        }
        if ((batch = this.annotationInfo.getValue("batch")) != null) {
            this.setBatch(batch);
        }
        if ((batchOnCascade = this.annotationInfo.getValue("batchOnCascade")) != null) {
            this.setBatchOnCascade(batchOnCascade);
        }
        if ((batchSize = this.annotationInfo.getValue("batchSize")) != null) {
            this.setBatchSize(batchSize);
        }
        if ((getGeneratedKeys = this.annotationInfo.getValue("getGeneratedKeys")) != null) {
            this.setGetGeneratedKeys(getGeneratedKeys);
        }
        if ((readOnly = this.annotationInfo.getValue("readOnly")) != null) {
            this.setReadOnly(readOnly);
        }
        if ((noRollbackFor = this.annotationInfo.getValue("noRollbackFor")) != null) {
            this.setNoRollbackFor(noRollbackFor);
        }
        if ((rollbackFor = this.annotationInfo.getValue("rollbackFor")) != null) {
            this.setRollbackFor(rollbackFor);
        }
        if ((serverName = this.annotationInfo.getValue("serverName")) != null && !serverName.equals("")) {
            this.setServerName(serverName);
        }
        this.mv.visitVarInsn(25, this.posTxScope);
        this.mv.visitMethodInsn(184, helpScopeTrans.getInternalName(), "createScopeTrans", "(" + txScopeType.getDescriptor() + ")" + scopeTransType.getDescriptor(), false);
        this.mv.visitVarInsn(58, this.posScopeTrans);
    }

    @Override
    protected void onFinally(int opcode) {
        this.onExit(opcode);
    }

    protected void onExit(int opcode) {
        if (!this.transactional) {
            return;
        }
        if (opcode == 177) {
            this.visitInsn(1);
        } else if (opcode == 176 || opcode == 191) {
            this.dup();
        } else {
            if (opcode == 173 || opcode == 175) {
                this.dup2();
            } else {
                this.dup();
            }
            this.box(Type.getReturnType(this.methodDesc));
        }
        this.visitIntInsn(17, opcode);
        this.loadLocal(this.posScopeTrans);
        this.visitMethodInsn(184, helpScopeTrans.getInternalName(), "onExitScopeTrans", "(Ljava/lang/Object;I" + scopeTransType.getDescriptor() + ")V", false);
    }
}

