/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.enhance.querybean;

import io.ebean.enhance.asm.MethodVisitor;
import io.ebean.enhance.asm.Opcodes;
import io.ebean.enhance.common.EnhanceContext;
import io.ebean.enhance.querybean.ClassInfo;
import java.util.HashSet;
import java.util.Set;

public class MethodAdapter
extends MethodVisitor
implements Opcodes {
    private static Set<String> FINDER_METHODS = new HashSet<String>();
    private final EnhanceContext enhanceContext;
    private final ClassInfo classInfo;
    private final String methodName;
    private boolean labelSet;

    public MethodAdapter(MethodVisitor mv, EnhanceContext enhanceContext, ClassInfo classInfo, String methodName) {
        super(458752, mv);
        this.enhanceContext = enhanceContext;
        this.classInfo = classInfo;
        this.methodName = methodName;
    }

    @Override
    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        if (opcode == 180 && this.enhanceContext.isQueryBean(owner)) {
            this.classInfo.addGetFieldIntercept(owner, name);
            this.mv.visitMethodInsn(182, owner, "_" + name, "()" + desc, false);
        } else {
            super.visitFieldInsn(opcode, owner, name, desc);
        }
    }

    @Override
    public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
        if (!isInterface && this.enhanceContext.isEnableQueryAutoLabel()) {
            if ("setLabel".equals(name) && this.enhanceContext.isQueryBean(owner)) {
                this.labelSet = true;
            }
            if (!this.labelSet && this.isFinderMethod(name) && this.enhanceContext.isQueryBean(owner)) {
                this.classInfo.markTypeQueryEnhanced();
                this.mv.visitLdcInsn(this.classInfo.getShortName() + "." + this.methodName);
                this.mv.visitMethodInsn(182, owner, "setLabel", "(Ljava/lang/String;)Ljava/lang/Object;", false);
                this.mv.visitTypeInsn(192, owner);
            }
        }
        super.visitMethodInsn(opcode, owner, name, descriptor, isInterface);
    }

    private boolean isFinderMethod(String name) {
        return FINDER_METHODS.contains(name);
    }

    static {
        FINDER_METHODS.add("findList");
        FINDER_METHODS.add("findSet");
        FINDER_METHODS.add("findMap");
        FINDER_METHODS.add("findIds");
        FINDER_METHODS.add("findCount");
        FINDER_METHODS.add("findOne");
        FINDER_METHODS.add("findOneOrEmpty");
        FINDER_METHODS.add("findSingleAttribute");
        FINDER_METHODS.add("findSingleAttributeList");
        FINDER_METHODS.add("findIterate");
    }
}

