/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.enhance.transactional;

import io.ebean.enhance.asm.AnnotationVisitor;
import io.ebean.enhance.asm.Label;
import io.ebean.enhance.asm.MethodVisitor;
import io.ebean.enhance.asm.Type;
import io.ebean.enhance.common.AnnotationInfo;
import io.ebean.enhance.common.AnnotationInfoVisitor;
import io.ebean.enhance.common.EnhanceConstants;
import io.ebean.enhance.common.VisitUtil;
import io.ebean.enhance.transactional.ClassAdapterTransactional;
import io.ebean.enhance.transactional.ConstructorMethodAdapter;
import io.ebean.enhance.transactional.TransactionalMethodKey;
import java.util.ArrayList;

class MethodAdapter
extends ConstructorMethodAdapter
implements EnhanceConstants {
    private static final String TX_FIELD_PREFIX = "_$ebpt";
    private static final Type txScopeType = Type.getType("Lio/ebean/TxScope;");
    private static final Type helpScopeTrans = Type.getType("Lio/ebeaninternal/api/HelpScopeTrans;");
    private final AnnotationInfo annotationInfo;
    private final String methodName;
    private boolean transactional;
    private int posTxScope;
    private int lineNumber;
    private TransactionalMethodKey methodKey;
    private int locationField;

    MethodAdapter(ClassAdapterTransactional classAdapter, MethodVisitor mv, int access, String name, String desc) {
        super(classAdapter, mv, access, name, desc);
        this.methodName = name;
        AnnotationInfo parentInfo = classAdapter.getClassAnnotationInfo();
        AnnotationInfo interfaceInfo = classAdapter.getInterfaceTransactionalInfo(name, desc);
        if (parentInfo == null) {
            parentInfo = interfaceInfo;
        } else {
            parentInfo.setParent(interfaceInfo);
        }
        this.annotationInfo = new AnnotationInfo(parentInfo);
        this.transactional = parentInfo != null;
    }

    @Override
    public void visitCode() {
        this.finallyVisitCode();
    }

    @Override
    public void visitMaxs(int maxStack, int maxLocals) {
        this.finallyVisitMaxs(maxStack, maxLocals);
    }

    @Override
    public void visitLineNumber(int line, Label start) {
        super.visitLineNumber(line, start);
        if (this.lineNumber == 0 && this.methodKey != null) {
            this.lineNumber = line;
            this.methodKey.setLineNumber(this.lineNumber);
        }
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        AnnotationVisitor av = super.visitAnnotation(desc, visible);
        if (desc.equals("Lio/ebean/annotation/Transactional;")) {
            this.transactional = true;
            return new AnnotationInfoVisitor(null, this.annotationInfo, av);
        }
        return av;
    }

    private void setTxType(Object txType) {
        this.visitLabelLine();
        this.mv.visitVarInsn(25, this.posTxScope);
        this.mv.visitLdcInsn(txType.toString());
        this.mv.visitMethodInsn(184, "io/ebean/annotation/TxType", "valueOf", "(Ljava/lang/String;)Lio/ebean/annotation/TxType;", false);
        this.mv.visitMethodInsn(182, "io/ebean/TxScope", "setType", "(Lio/ebean/annotation/TxType;)Lio/ebean/TxScope;", false);
        this.mv.visitInsn(87);
    }

    private void setTxIsolation(Object txIsolation) {
        this.visitLabelLine();
        this.mv.visitVarInsn(25, this.posTxScope);
        this.mv.visitLdcInsn(txIsolation.toString());
        this.mv.visitMethodInsn(184, "io/ebean/annotation/TxIsolation", "valueOf", "(Ljava/lang/String;)Lio/ebean/annotation/TxIsolation;", false);
        this.mv.visitMethodInsn(182, "io/ebean/TxScope", "setIsolation", "(Lio/ebean/annotation/TxIsolation;)Lio/ebean/TxScope;", false);
        this.mv.visitInsn(87);
    }

    private void setTxProfileLocation(int locationField) {
        this.visitLabelLine();
        this.mv.visitVarInsn(25, this.posTxScope);
        this.mv.visitFieldInsn(178, this.classAdapter.className(), TX_FIELD_PREFIX + locationField, "Lio/ebean/ProfileLocation;");
        this.mv.visitMethodInsn(182, "io/ebean/TxScope", "setProfileLocation", "(Lio/ebean/ProfileLocation;)Lio/ebean/TxScope;", false);
        this.mv.visitInsn(87);
    }

    private void setBatch(Object batch) {
        this.visitLabelLine();
        this.mv.visitVarInsn(25, this.posTxScope);
        this.mv.visitLdcInsn(batch.toString());
        this.mv.visitMethodInsn(184, "io/ebean/annotation/PersistBatch", "valueOf", "(Ljava/lang/String;)Lio/ebean/annotation/PersistBatch;", false);
        this.mv.visitMethodInsn(182, "io/ebean/TxScope", "setBatch", "(Lio/ebean/annotation/PersistBatch;)Lio/ebean/TxScope;", false);
        this.mv.visitInsn(87);
    }

    private void visitLabelLine() {
        Label l6 = new Label();
        this.mv.visitLabel(l6);
        this.mv.visitLineNumber(1, l6);
    }

    private void setBatchOnCascade(Object batch) {
        this.visitLabelLine();
        this.mv.visitVarInsn(25, this.posTxScope);
        this.mv.visitLdcInsn(batch.toString());
        this.mv.visitMethodInsn(184, "io/ebean/annotation/PersistBatch", "valueOf", "(Ljava/lang/String;)Lio/ebean/annotation/PersistBatch;", false);
        this.mv.visitMethodInsn(182, "io/ebean/TxScope", "setBatchOnCascade", "(Lio/ebean/annotation/PersistBatch;)Lio/ebean/TxScope;", false);
        this.mv.visitInsn(87);
    }

    private void setProfileId(int profileId) {
        this.visitLabelLine();
        this.mv.visitVarInsn(25, this.posTxScope);
        VisitUtil.visitIntInsn(this.mv, profileId);
        this.mv.visitMethodInsn(182, "io/ebean/TxScope", "setProfileId", "(I)Lio/ebean/TxScope;", false);
        this.mv.visitInsn(87);
    }

    private void setBatchSize(Object batchSize) {
        this.visitLabelLine();
        this.mv.visitVarInsn(25, this.posTxScope);
        VisitUtil.visitIntInsn(this.mv, Integer.parseInt(batchSize.toString()));
        this.mv.visitMethodInsn(182, "io/ebean/TxScope", "setBatchSize", "(I)Lio/ebean/TxScope;", false);
        this.mv.visitInsn(87);
    }

    private void setGetGeneratedKeys(Object getGeneratedKeys) {
        boolean getKeys = (Boolean)getGeneratedKeys;
        if (!getKeys) {
            this.visitLabelLine();
            this.mv.visitVarInsn(25, this.posTxScope);
            this.mv.visitMethodInsn(182, "io/ebean/TxScope", "setSkipGeneratedKeys", "()Lio/ebean/TxScope;", false);
            this.mv.visitInsn(87);
        }
    }

    private void setReadOnly(Object readOnlyObj) {
        this.visitLabelLine();
        boolean readOnly = (Boolean)readOnlyObj;
        this.mv.visitVarInsn(25, this.posTxScope);
        if (readOnly) {
            this.mv.visitInsn(4);
        } else {
            this.mv.visitInsn(3);
        }
        this.mv.visitMethodInsn(182, "io/ebean/TxScope", "setReadOnly", "(Z)Lio/ebean/TxScope;", false);
        this.mv.visitInsn(87);
    }

    private void setFlushOnQuery(Object flushObj) {
        boolean flushOnQuery = (Boolean)flushObj;
        if (!flushOnQuery) {
            this.visitLabelLine();
            this.mv.visitVarInsn(25, this.posTxScope);
            this.mv.visitInsn(3);
            this.mv.visitMethodInsn(182, "io/ebean/TxScope", "setFlushOnQuery", "(Z)Lio/ebean/TxScope;", false);
            this.mv.visitInsn(87);
        }
    }

    private void setSkipCache(Object skipCacheObj) {
        boolean skipCache = (Boolean)skipCacheObj;
        if (skipCache) {
            this.visitLabelLine();
            this.mv.visitVarInsn(25, this.posTxScope);
            this.mv.visitInsn(4);
            this.mv.visitMethodInsn(182, "io/ebean/TxScope", "setSkipCache", "(Z)Lio/ebean/TxScope;", false);
            this.mv.visitInsn(87);
        }
    }

    private void setLabel(String label) {
        this.visitLabelLine();
        this.mv.visitVarInsn(25, this.posTxScope);
        this.mv.visitLdcInsn(label);
        this.mv.visitMethodInsn(182, "io/ebean/TxScope", "setLabel", "(Ljava/lang/String;)Lio/ebean/TxScope;", false);
        this.mv.visitInsn(87);
    }

    private void setNoRollbackFor(Object noRollbackFor) {
        ArrayList list = (ArrayList)noRollbackFor;
        for (Object aList : list) {
            this.visitLabelLine();
            Type throwType = (Type)aList;
            this.mv.visitVarInsn(25, this.posTxScope);
            this.mv.visitLdcInsn(throwType);
            this.mv.visitMethodInsn(182, txScopeType.getInternalName(), "setNoRollbackFor", "(Ljava/lang/Class;)Lio/ebean/TxScope;", false);
            this.mv.visitInsn(87);
        }
    }

    private void setRollbackFor(Object rollbackFor) {
        ArrayList list = (ArrayList)rollbackFor;
        for (Object aList : list) {
            this.visitLabelLine();
            Type throwType = (Type)aList;
            this.mv.visitVarInsn(25, this.posTxScope);
            this.mv.visitLdcInsn(throwType);
            this.mv.visitMethodInsn(182, txScopeType.getInternalName(), "setRollbackFor", "(Ljava/lang/Class;)Lio/ebean/TxScope;", false);
            this.mv.visitInsn(87);
        }
    }

    private int annotationProfileId() {
        Object value = this.annotationInfo.getValue("profileId");
        if (value == null) {
            return 0;
        }
        return (Integer)value;
    }

    @Override
    protected void onMethodEnter() {
        Object rollbackFor;
        Object noRollbackFor;
        Object skipCache;
        Object flushOnQuery;
        Object readOnly;
        Object getGeneratedKeys;
        Object batchSize;
        Object batchOnCascade;
        Object batch;
        Object txIsolation;
        String txLabel;
        int profileId;
        if (!this.transactional) {
            return;
        }
        this.locationField = this.classAdapter.nextTransactionLocation();
        this.methodKey = this.classAdapter.createMethodKey(this.methodName, this.methodDesc, this.annotationProfileId());
        this.posTxScope = this.newLocal(txScopeType);
        this.mv.visitTypeInsn(187, txScopeType.getInternalName());
        this.mv.visitInsn(89);
        this.mv.visitMethodInsn(183, txScopeType.getInternalName(), "<init>", "()V", false);
        this.mv.visitVarInsn(58, this.posTxScope);
        Object txType = this.annotationInfo.getValue("type");
        if (txType != null) {
            this.setTxType(txType);
        }
        if (this.classAdapter.isEnableProfileLocation()) {
            this.setTxProfileLocation(this.locationField);
        }
        if ((profileId = this.methodKey.getProfileId()) > 0) {
            this.setProfileId(profileId);
        }
        if ((txLabel = (String)this.annotationInfo.getValue("label")) != null && !txLabel.isEmpty()) {
            this.classAdapter.putTxnLabel(this.locationField, txLabel);
            this.setLabel(txLabel);
        }
        if ((txIsolation = this.annotationInfo.getValue("isolation")) != null) {
            this.setTxIsolation(txIsolation);
        }
        if ((batch = this.annotationInfo.getValue("batch")) != null) {
            this.setBatch(batch);
        }
        if ((batchOnCascade = this.annotationInfo.getValue("batchOnCascade")) != null) {
            this.setBatchOnCascade(batchOnCascade);
        }
        if ((batchSize = this.annotationInfo.getValue("batchSize")) != null) {
            this.setBatchSize(batchSize);
        }
        if ((getGeneratedKeys = this.annotationInfo.getValue("getGeneratedKeys")) != null) {
            this.setGetGeneratedKeys(getGeneratedKeys);
        }
        if ((readOnly = this.annotationInfo.getValue("readOnly")) != null) {
            this.setReadOnly(readOnly);
        }
        if ((flushOnQuery = this.annotationInfo.getValue("flushOnQuery")) != null) {
            this.setFlushOnQuery(flushOnQuery);
        }
        if ((skipCache = this.annotationInfo.getValue("skipCache")) != null) {
            this.setSkipCache(skipCache);
        }
        if ((noRollbackFor = this.annotationInfo.getValue("noRollbackFor")) != null) {
            this.setNoRollbackFor(noRollbackFor);
        }
        if ((rollbackFor = this.annotationInfo.getValue("rollbackFor")) != null) {
            this.setRollbackFor(rollbackFor);
        }
        this.mv.visitVarInsn(25, this.posTxScope);
        this.mv.visitMethodInsn(184, helpScopeTrans.getInternalName(), "enter", "(" + txScopeType.getDescriptor() + ")V", false);
    }

    @Override
    protected void onFinally(int opcode) {
        if (!this.transactional) {
            return;
        }
        this.classAdapter.transactionalMethod(this.methodKey);
        if (opcode == 177) {
            this.visitInsn(1);
        } else if (opcode == 176 || opcode == 191) {
            this.dup();
        } else {
            if (opcode == 173 || opcode == 175) {
                this.dup2();
            } else {
                this.dup();
            }
            this.box(Type.getReturnType(this.methodDesc));
        }
        this.visitIntInsn(17, opcode);
        this.visitMethodInsn(184, helpScopeTrans.getInternalName(), "exit", "(Ljava/lang/Object;I)V", false);
    }
}

