/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.enhance.common;

import io.ebean.enhance.common.UrlHelper;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public class AgentManifest {
    private final Set<String> entityPackages = new HashSet<String>();
    private final Set<String> transactionalPackages = new HashSet<String>();
    private final Set<String> querybeanPackages = new HashSet<String>();
    private TxProfileMode transactionProfilingMode = TxProfileMode.NONE;
    private int transactionProfilingStart = 1000;
    private int debugLevel = -1;
    private boolean transientInternalFields;
    private boolean checkNullManyFields = true;
    private boolean enableProfileLocation;
    private boolean enableQueryAutoLabel;

    public static AgentManifest read(ClassLoader classLoader, Set<String> initialPackages) {
        try {
            return new AgentManifest(initialPackages).readManifests(classLoader, "META-INF/ebean-typequery.mf").readManifests(classLoader, "META-INF/ebean.mf").readManifests(classLoader, "ebean.mf");
        }
        catch (IOException e) {
            System.err.println("Agent: error reading ebean manifest resources");
            e.printStackTrace();
            return new AgentManifest();
        }
    }

    public AgentManifest(Set<String> initialPackages) {
        if (initialPackages != null) {
            this.entityPackages.addAll(initialPackages);
        }
    }

    private AgentManifest() {
    }

    public String toString() {
        return "entityPackages:" + this.entityPackages + " querybeanPackages:" + this.querybeanPackages + " transactionalPackages:" + this.transactionalPackages + " profilingMode:" + (Object)((Object)this.transactionProfilingMode);
    }

    public boolean isEnableProfileLocation() {
        return this.enableProfileLocation;
    }

    public boolean isEnableQueryAutoLabel() {
        return this.enableQueryAutoLabel;
    }

    int transactionProfilingStart() {
        switch (this.transactionProfilingMode) {
            case NONE: {
                return -1;
            }
            case MANUAL: {
                return 0;
            }
            case ENABLED: {
                return this.transactionProfilingStart;
            }
        }
        return this.transactionProfilingStart;
    }

    public int getDebugLevel() {
        return this.debugLevel;
    }

    public Set<String> getEntityPackages() {
        return this.entityPackages;
    }

    public boolean isTransactionalNone() {
        return this.transactionalPackages.contains("none") && this.transactionalPackages.size() == 1;
    }

    public boolean isTransientInternalFields() {
        return this.transientInternalFields;
    }

    public boolean isCheckNullManyFields() {
        return this.checkNullManyFields;
    }

    public boolean isQueryBeanNone() {
        return this.querybeanPackages.contains("none") && this.querybeanPackages.size() == 1;
    }

    public Set<String> getTransactionalPackages() {
        return this.transactionalPackages;
    }

    public Set<String> getQuerybeanPackages() {
        return this.querybeanPackages;
    }

    AgentManifest readManifests(ClassLoader classLoader, String path) throws IOException {
        Enumeration<URL> resources = classLoader.getResources(path);
        while (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            try {
                this.addResource(UrlHelper.openNoCache(url));
            }
            catch (IOException e) {
                System.err.println("Error reading manifest resources " + url);
                e.printStackTrace();
            }
        }
        return this;
    }

    private void addResource(InputStream is) throws IOException {
        try {
            this.addManifest(new Manifest(is));
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                System.err.println("Error closing manifest resource");
                e.printStackTrace();
            }
        }
    }

    private void readProfilingMode(Attributes attributes) {
        String mode;
        String queryLabelMode;
        String locationMode;
        String debug = attributes.getValue("debug");
        if (debug != null) {
            this.debugLevel = Integer.parseInt(debug);
        }
        if ((locationMode = attributes.getValue("profile-location")) != null) {
            this.enableProfileLocation = Boolean.parseBoolean(locationMode);
        }
        if ((queryLabelMode = attributes.getValue("query-labels")) != null) {
            this.enableQueryAutoLabel = Boolean.parseBoolean(queryLabelMode);
        }
        if ((mode = attributes.getValue("transaction-profiling")) != null) {
            this.transactionProfilingMode = this.parseMode(mode);
        }
    }

    private TxProfileMode parseMode(String mode) {
        switch (mode.trim().toLowerCase()) {
            case "enabled": 
            case "auto": 
            case "enable": {
                return TxProfileMode.ENABLED;
            }
            case "manual": {
                return TxProfileMode.MANUAL;
            }
        }
        return TxProfileMode.NONE;
    }

    private void readProfilingStart(Attributes attributes) {
        String start = attributes.getValue("transaction-profiling-startvalue");
        if (start != null) {
            try {
                this.transactionProfilingStart = Integer.parseInt(start);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private void addManifest(Manifest manifest) {
        Attributes attributes = manifest.getMainAttributes();
        this.readProfilingMode(attributes);
        this.readProfilingStart(attributes);
        this.readOptions(attributes);
        this.add(this.entityPackages, attributes.getValue("packages"));
        this.add(this.entityPackages, attributes.getValue("entity-packages"));
        this.add(this.transactionalPackages, attributes.getValue("transactional-packages"));
        this.add(this.querybeanPackages, attributes.getValue("querybean-packages"));
        String topPackages = attributes.getValue("top-packages");
        if (topPackages != null) {
            this.add(this.transactionalPackages, topPackages);
            this.add(this.querybeanPackages, topPackages);
        }
    }

    private void readOptions(Attributes attributes) {
        this.transientInternalFields = this.bool("transient-internal-fields", this.transientInternalFields, attributes);
        this.checkNullManyFields = this.bool("check-null-many-fields", this.checkNullManyFields, attributes);
    }

    private boolean bool(String key, boolean defaultValue, Attributes attributes) {
        String val = attributes.getValue(key);
        return val != null ? Boolean.parseBoolean(val) : defaultValue;
    }

    private void add(Set<String> addTo, String packages) {
        if (packages != null) {
            String[] split;
            for (String aSplit : split = packages.split(",|;| ")) {
                String pkg = aSplit.trim();
                if (pkg.isEmpty()) continue;
                addTo.add(pkg);
            }
        }
    }

    static enum TxProfileMode {
        NONE,
        ENABLED,
        MANUAL;

    }
}

