/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.enhance.entity;

import io.ebean.enhance.asm.AnnotationVisitor;
import io.ebean.enhance.asm.Attribute;
import io.ebean.enhance.asm.Handle;
import io.ebean.enhance.asm.Label;
import io.ebean.enhance.asm.MethodVisitor;
import io.ebean.enhance.asm.Opcodes;
import io.ebean.enhance.asm.TypePath;
import io.ebean.enhance.common.ClassMeta;
import io.ebean.enhance.common.EnhanceConstants;
import io.ebean.enhance.entity.ConstructorDeferredCode;
import io.ebean.enhance.entity.FieldMeta;

class ConstructorAdapter
extends MethodVisitor
implements EnhanceConstants,
Opcodes {
    private final ClassMeta meta;
    private final String className;
    private final String constructorDesc;
    private boolean constructorInitializationDone;
    private final ConstructorDeferredCode deferredCode;

    ConstructorAdapter(MethodVisitor mv, ClassMeta meta, String constructorDesc) {
        super(458752, mv);
        this.meta = meta;
        this.className = meta.getClassName();
        this.constructorDesc = constructorDesc;
        this.deferredCode = new ConstructorDeferredCode(meta, mv);
    }

    @Override
    public void visitVarInsn(int opcode, int var) {
        if (!this.deferredCode.deferVisitVarInsn(opcode, var)) {
            super.visitVarInsn(opcode, var);
        }
    }

    @Override
    public void visitTypeInsn(int opcode, String type) {
        if (!this.deferredCode.deferVisitTypeInsn(opcode, type)) {
            super.visitTypeInsn(opcode, type);
        }
    }

    @Override
    public void visitInsn(int opcode) {
        if (!this.deferredCode.deferVisitInsn(opcode)) {
            super.visitInsn(opcode);
        }
    }

    @Override
    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
        if (!this.deferredCode.deferVisitMethodInsn(opcode, owner, name, desc, itf)) {
            super.visitMethodInsn(opcode, owner, name, desc, itf);
            this.addInitialisationIfRequired(opcode, owner, name, desc);
        }
    }

    @Override
    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        if (this.deferredCode.consumeVisitFieldInsn(opcode, name)) {
            return;
        }
        if (!this.className.equals(owner)) {
            super.visitFieldInsn(opcode, owner, name, desc);
            return;
        }
        FieldMeta fieldMeta = this.meta.getFieldPersistent(name);
        if (fieldMeta == null || !fieldMeta.isPersistent()) {
            if (this.meta.isLog(4)) {
                this.meta.log("... visitFieldInsn (in constructor but non-persistent)- " + opcode + " owner:" + owner + ":" + name + ":" + desc);
            }
            super.visitFieldInsn(opcode, owner, name, desc);
        } else if (opcode == 181) {
            String methodName = "_ebean_set_" + name;
            String methodDesc = "(" + desc + ")V";
            if (this.meta.isLog(3)) {
                this.meta.log("... Constructor PUTFIELD replaced with:" + methodName + methodDesc);
            }
            super.visitMethodInsn(182, this.className, methodName, methodDesc, false);
        } else if (opcode == 180 && fieldMeta.isMany()) {
            String methodName = "_ebean_get_" + name;
            String methodDesc = "()" + desc;
            if (this.meta.isLog(3)) {
                this.meta.log("... Constructor GETFIELD:" + name + " replaced with: " + methodName + methodDesc);
            }
            super.visitMethodInsn(182, this.className, methodName, methodDesc, false);
        } else {
            if (this.meta.isLog(3)) {
                this.meta.log("... visitFieldInsn (unaltered in constructor)- " + opcode + " owner:" + owner + ":" + name + ":" + desc);
            }
            super.visitFieldInsn(opcode, owner, name, desc);
        }
    }

    private void addInitialisationIfRequired(int opcode, String owner, String name, String desc) {
        if ("io/ebean/Model".equals(owner) && "<init>".equals(name)) {
            this.addConstructorInit(owner);
            return;
        }
        if (opcode == 183 && name.equals("<init>") && desc.equals("()V")) {
            if (this.meta.isSuperClassEntity()) {
                if (this.meta.isLog(3)) {
                    this.meta.log("... skipping intercept <init> ... handled by super class... CONSTRUCTOR: owner:" + owner + " " + this.constructorDesc);
                }
            } else if (owner.equals(this.meta.getClassName())) {
                if (this.meta.isLog(3)) {
                    this.meta.log("... skipping intercept <init> ... handled by other constructor... CONSTRUCTOR: owner:" + owner + " " + this.constructorDesc);
                }
            } else if (owner.equals(this.meta.getSuperClassName())) {
                this.addConstructorInit(owner);
            } else if (this.meta.isLog(3)) {
                this.meta.log("... skipping intercept <init> ... incorrect type " + owner);
            }
        }
    }

    private void addConstructorInit(String owner) {
        if (this.meta.isLog(2)) {
            this.meta.log("... adding intercept <init> in CONSTRUCTOR:" + this.constructorDesc + " OWNER/SUPER:" + owner);
        }
        if (this.constructorInitializationDone) {
            String msg = "Error in Enhancement. Only expecting to add <init> of intercept object once but it is trying to add it twice for " + this.meta.getClassName() + " CONSTRUCTOR:" + this.constructorDesc + " OWNER:" + owner;
            System.err.println(msg);
        } else {
            super.visitVarInsn(25, 0);
            super.visitTypeInsn(187, "io/ebean/bean/EntityBeanIntercept");
            super.visitInsn(89);
            super.visitVarInsn(25, 0);
            super.visitMethodInsn(183, "io/ebean/bean/EntityBeanIntercept", "<init>", "(Ljava/lang/Object;)V", false);
            super.visitFieldInsn(181, this.className, "_ebean_intercept", "Lio/ebean/bean/EntityBeanIntercept;");
            if (this.meta.isLog(8)) {
                this.meta.log("... constructorInitializationDone " + owner);
            }
            this.constructorInitializationDone = true;
        }
    }

    @Override
    public void visitParameter(String name, int access) {
        this.deferredCode.flush();
        super.visitParameter(name, access);
    }

    @Override
    public AnnotationVisitor visitAnnotationDefault() {
        this.deferredCode.flush();
        return super.visitAnnotationDefault();
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        this.deferredCode.flush();
        return super.visitAnnotation(desc, visible);
    }

    @Override
    public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
        this.deferredCode.flush();
        return super.visitTypeAnnotation(typeRef, typePath, desc, visible);
    }

    @Override
    public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
        this.deferredCode.flush();
        return super.visitParameterAnnotation(parameter, desc, visible);
    }

    @Override
    public void visitAttribute(Attribute attr) {
        this.deferredCode.flush();
        super.visitAttribute(attr);
    }

    @Override
    public void visitFrame(int type, int nLocal, Object[] local, int nStack, Object[] stack) {
        this.deferredCode.flush();
        super.visitFrame(type, nLocal, local, nStack, stack);
    }

    @Override
    public void visitIntInsn(int opcode, int operand) {
        this.deferredCode.flush();
        super.visitIntInsn(opcode, operand);
    }

    @Override
    public void visitMethodInsn(int opcode, String owner, String name, String desc) {
        this.deferredCode.flush();
        super.visitMethodInsn(opcode, owner, name, desc);
    }

    @Override
    public void visitInvokeDynamicInsn(String name, String desc, Handle bsm, Object ... bsmArgs) {
        this.deferredCode.flush();
        super.visitInvokeDynamicInsn(name, desc, bsm, bsmArgs);
    }

    @Override
    public void visitJumpInsn(int opcode, Label label) {
        this.deferredCode.flush();
        super.visitJumpInsn(opcode, label);
    }

    @Override
    public void visitLabel(Label label) {
        this.deferredCode.flush();
        super.visitLabel(label);
    }

    @Override
    public void visitLdcInsn(Object cst) {
        this.deferredCode.flush();
        super.visitLdcInsn(cst);
    }

    @Override
    public void visitIincInsn(int var, int increment) {
        this.deferredCode.flush();
        super.visitIincInsn(var, increment);
    }

    @Override
    public void visitTableSwitchInsn(int min, int max, Label dflt, Label ... labels) {
        this.deferredCode.flush();
        super.visitTableSwitchInsn(min, max, dflt, labels);
    }

    @Override
    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        this.deferredCode.flush();
        super.visitLookupSwitchInsn(dflt, keys, labels);
    }

    @Override
    public void visitMultiANewArrayInsn(String desc, int dims) {
        this.deferredCode.flush();
        super.visitMultiANewArrayInsn(desc, dims);
    }

    @Override
    public AnnotationVisitor visitInsnAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
        this.deferredCode.flush();
        return super.visitInsnAnnotation(typeRef, typePath, desc, visible);
    }

    @Override
    public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        this.deferredCode.flush();
        super.visitTryCatchBlock(start, end, handler, type);
    }

    @Override
    public AnnotationVisitor visitTryCatchAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
        this.deferredCode.flush();
        return super.visitTryCatchAnnotation(typeRef, typePath, desc, visible);
    }

    @Override
    public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
        this.deferredCode.flush();
        super.visitLocalVariable(name, desc, signature, start, end, index);
    }

    @Override
    public AnnotationVisitor visitLocalVariableAnnotation(int typeRef, TypePath typePath, Label[] start, Label[] end, int[] index, String desc, boolean visible) {
        this.deferredCode.flush();
        return super.visitLocalVariableAnnotation(typeRef, typePath, start, end, index, desc, visible);
    }

    @Override
    public void visitLineNumber(int line, Label start) {
        this.deferredCode.flush();
        super.visitLineNumber(line, start);
    }

    @Override
    public void visitMaxs(int maxStack, int maxLocals) {
        this.deferredCode.flush();
        super.visitMaxs(maxStack, maxLocals);
    }

    @Override
    public void visitEnd() {
        this.deferredCode.flush();
        super.visitEnd();
    }
}

