/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.enhance.common;

import io.ebean.enhance.common.UrlHelper;
import io.ebean.enhance.querybean.DetectQueryBean;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public class AgentManifest {
    private final Set<Integer> classLoaderIdentities = new HashSet<Integer>();
    private final List<String> loadedResources = new ArrayList<String>();
    private final Set<String> entityPackages = new HashSet<String>();
    private final Set<String> transactionalPackages = new HashSet<String>();
    private final Set<String> querybeanPackages = new HashSet<String>();
    private final DetectQueryBean detectQueryBean = new DetectQueryBean();
    private int debugLevel = -1;
    private boolean transientInternalFields = true;
    private boolean checkNullManyFields = true;
    private boolean enableProfileLocation = true;

    public AgentManifest(ClassLoader classLoader) {
        this.readManifest(classLoader);
    }

    public AgentManifest() {
    }

    public boolean readManifest(ClassLoader classLoader) {
        if (classLoader == null) {
            return false;
        }
        int loaderIdentity = System.identityHashCode(classLoader);
        if (this.classLoaderIdentities.add(loaderIdentity)) {
            try {
                int beforeSize = this.entityPackages.size();
                this.readManifests(classLoader, "META-INF/ebean-generated-info.mf");
                this.readManifests(classLoader, "META-INF/ebean.mf");
                this.readManifests(classLoader, "ebean.mf");
                int afterSize = this.entityPackages.size();
                if (afterSize > beforeSize) {
                    this.detectQueryBean.addAll(this.entityPackages);
                    return true;
                }
            }
            catch (IOException e) {
                System.err.println("Agent: error reading ebean manifest resources");
                e.printStackTrace();
            }
        }
        return false;
    }

    public boolean isDetectQueryBean(String owner) {
        return this.detectQueryBean.isQueryBean(owner);
    }

    public String toString() {
        return "entityPackages:" + this.entityPackages + " querybeanPackages:" + this.querybeanPackages + " transactionalPackages:" + this.transactionalPackages;
    }

    public boolean isEnableProfileLocation() {
        return this.enableProfileLocation;
    }

    public int getDebugLevel() {
        return this.debugLevel;
    }

    public List<String> getLoadedResources() {
        return this.loadedResources;
    }

    public Set<String> getEntityPackages() {
        return this.entityPackages;
    }

    public boolean isTransactionalNone() {
        return this.transactionalPackages.contains("none") && this.transactionalPackages.size() == 1;
    }

    public boolean isTransientInternalFields() {
        return this.transientInternalFields;
    }

    public boolean isCheckNullManyFields() {
        return this.checkNullManyFields;
    }

    public boolean isQueryBeanNone() {
        return this.querybeanPackages.contains("none") && this.querybeanPackages.size() == 1;
    }

    public Set<String> getTransactionalPackages() {
        return this.transactionalPackages;
    }

    public Set<String> getQuerybeanPackages() {
        return this.querybeanPackages;
    }

    AgentManifest readManifests(ClassLoader classLoader, String path) throws IOException {
        Enumeration<URL> resources = classLoader.getResources(path);
        while (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            try {
                this.addResource(UrlHelper.openNoCache(url));
                this.loadedResources.add(path);
            }
            catch (IOException e) {
                System.err.println("Error reading manifest resources " + url);
                e.printStackTrace();
            }
        }
        return this;
    }

    private void addResource(InputStream is) throws IOException {
        try {
            this.addManifest(new Manifest(is));
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                System.err.println("Error closing manifest resource");
                e.printStackTrace();
            }
        }
    }

    private void readProfilingMode(Attributes attributes) {
        String locationMode;
        String debug = attributes.getValue("debug");
        if (debug != null) {
            this.debugLevel = Integer.parseInt(debug);
        }
        if ((locationMode = attributes.getValue("profile-location")) != null) {
            this.enableProfileLocation = Boolean.parseBoolean(locationMode);
        }
    }

    private void addManifest(Manifest manifest) {
        Attributes attributes = manifest.getMainAttributes();
        this.readProfilingMode(attributes);
        this.readOptions(attributes);
        this.add(this.entityPackages, attributes.getValue("packages"));
        this.add(this.entityPackages, attributes.getValue("entity-packages"));
        this.add(this.transactionalPackages, attributes.getValue("transactional-packages"));
        this.add(this.querybeanPackages, attributes.getValue("querybean-packages"));
        String topPackages = attributes.getValue("top-packages");
        if (topPackages != null) {
            this.add(this.transactionalPackages, topPackages);
            this.add(this.querybeanPackages, topPackages);
        }
    }

    private void readOptions(Attributes attributes) {
        this.transientInternalFields = this.bool("transient-internal-fields", this.transientInternalFields, attributes);
        this.checkNullManyFields = this.bool("check-null-many-fields", this.checkNullManyFields, attributes);
    }

    private boolean bool(String key, boolean defaultValue, Attributes attributes) {
        String val = attributes.getValue(key);
        return val != null ? Boolean.parseBoolean(val) : defaultValue;
    }

    private void add(Set<String> addTo, String packages) {
        if (packages != null) {
            String[] split;
            for (String aSplit : split = packages.split("[,; ]")) {
                String pkg = aSplit.trim();
                if (pkg.isEmpty()) continue;
                addTo.add(pkg);
            }
        }
    }
}

