/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.enhance.common;

import io.ebean.enhance.asm.ClassReader;
import io.ebean.enhance.asm.ClassVisitor;
import io.ebean.enhance.asm.ClassWriter;
import io.ebean.enhance.common.CommonSuperUnresolved;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ClassWriterWithoutClassLoading
extends ClassWriter {
    private final Map<String, Set<String>> type2instanceOfs = new HashMap<String, Set<String>>();
    private final Map<String, String> type2superclass = new HashMap<String, String>();
    private final Map<String, Boolean> type2isInterface = new HashMap<String, Boolean>();
    private final ClassLoader classLoader;
    private List<CommonSuperUnresolved> unresolved = new ArrayList<CommonSuperUnresolved>();

    public ClassWriterWithoutClassLoading(ClassReader classReader, int flags, ClassLoader classLoader) {
        super(classReader, flags);
        this.classLoader = classLoader;
    }

    public ClassWriterWithoutClassLoading(int flags, ClassLoader classLoader) {
        super(flags);
        this.classLoader = classLoader;
    }

    public List<CommonSuperUnresolved> getUnresolved() {
        return this.unresolved;
    }

    @Override
    protected String getCommonSuperClass(String type1, String type2) {
        try {
            if (this.getInstanceOfs(type2).contains(type1)) {
                return type1;
            }
            if (this.getInstanceOfs(type1).contains(type2)) {
                return type2;
            }
            if (this.isInterface(type1) || this.isInterface(type2)) {
                return "java/lang/Object";
            }
            String type = type1;
            do {
                type = this.getSuperclass(type);
            } while (!this.getInstanceOfs(type2).contains(type));
            return type;
        }
        catch (Exception e) {
            this.unresolved.add(new CommonSuperUnresolved(type1, type2, e.toString()));
            return "java/lang/Object";
        }
    }

    private String getSuperclass(String type) {
        if (!this.type2superclass.containsKey(type)) {
            this.initializeTypeHierarchyFor(type);
        }
        return this.type2superclass.get(type);
    }

    private boolean isInterface(String type) {
        if (!this.type2isInterface.containsKey(type)) {
            this.initializeTypeHierarchyFor(type);
        }
        return this.type2isInterface.get(type);
    }

    private Set<String> getInstanceOfs(String type) {
        if (!this.type2instanceOfs.containsKey(type)) {
            this.initializeTypeHierarchyFor(type);
        }
        return this.type2instanceOfs.get(type);
    }

    private void initializeTypeHierarchyFor(final String internalTypeName) {
        if (this.classLoader == null) {
            throw new IllegalStateException("ClassLoader is null?");
        }
        try (InputStream classBytes = this.classLoader.getResourceAsStream(internalTypeName + ".class");){
            ClassReader classReader = new ClassReader(classBytes);
            classReader.accept(new ClassVisitor(458752){

                @Override
                public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                    super.visit(version, access, name, signature, superName, interfaces);
                    ClassWriterWithoutClassLoading.this.type2superclass.put(internalTypeName, superName);
                    ClassWriterWithoutClassLoading.this.type2isInterface.put(internalTypeName, (access & 0x200) > 0);
                    HashSet<String> instanceOfs = new HashSet<String>();
                    instanceOfs.add(internalTypeName);
                    if (superName != null) {
                        instanceOfs.add(superName);
                        instanceOfs.addAll(ClassWriterWithoutClassLoading.this.getInstanceOfs(superName));
                    }
                    for (String superInterface : interfaces) {
                        instanceOfs.add(superInterface);
                        instanceOfs.addAll(ClassWriterWithoutClassLoading.this.getInstanceOfs(superInterface));
                    }
                    ClassWriterWithoutClassLoading.this.type2instanceOfs.put(internalTypeName, instanceOfs);
                }
            }, 7);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

