/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.enhance.common;

import io.ebean.enhance.common.AgentManifest;
import io.ebean.enhance.common.DistillPackages;
import java.util.Arrays;

class FilterEntityTransactional {
    private final boolean noFiltering;
    private final String[] topLevelPackages;

    FilterEntityTransactional(AgentManifest manifest) {
        this.noFiltering = manifest.getTransactionalPackages().isEmpty() || manifest.getEntityPackages().isEmpty();
        DistillPackages distill = new DistillPackages().add(manifest.getEntityPackages());
        if (!manifest.isTransactionalNone()) {
            distill.add(manifest.getTransactionalPackages());
        }
        this.topLevelPackages = distill.distill();
    }

    public String toString() {
        return "noFiltering:" + this.noFiltering + " topLevelPackages:" + Arrays.toString(this.topLevelPackages);
    }

    boolean detectEnhancement(String className) {
        if (this.noFiltering) {
            return true;
        }
        for (String pkg : this.topLevelPackages) {
            if (!className.startsWith(pkg)) continue;
            return true;
        }
        return false;
    }
}

