/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.enhance.entity;

import io.ebean.enhance.asm.AnnotationVisitor;
import io.ebean.enhance.asm.ClassVisitor;
import io.ebean.enhance.asm.FieldVisitor;
import io.ebean.enhance.asm.MethodVisitor;
import io.ebean.enhance.common.ClassMeta;
import io.ebean.enhance.common.EnhanceConstants;
import io.ebean.enhance.common.EnhanceContext;
import io.ebean.enhance.common.NoEnhancementRequiredException;
import io.ebean.enhance.entity.ConstructorAdapter;
import io.ebean.enhance.entity.DefaultConstructor;
import io.ebean.enhance.entity.IndexFieldWeaver;
import io.ebean.enhance.entity.InterceptField;
import io.ebean.enhance.entity.MarkerField;
import io.ebean.enhance.entity.MethodEquals;
import io.ebean.enhance.entity.MethodFieldAdapter;
import io.ebean.enhance.entity.MethodIsEmbeddedNewOrDirty;
import io.ebean.enhance.entity.MethodNewInstance;
import io.ebean.enhance.entity.MethodSetEmbeddedLoaded;
import io.ebean.enhance.entity.MethodStaticInitAdapter;

public class ClassAdapterEntity
extends ClassVisitor
implements EnhanceConstants {
    private final EnhanceContext enhanceContext;
    private final ClassLoader classLoader;
    private final ClassMeta classMeta;
    private boolean firstMethod = true;

    public ClassAdapterEntity(ClassVisitor cv, ClassLoader classLoader, EnhanceContext context) {
        super(589824, cv);
        this.classLoader = classLoader;
        this.enhanceContext = context;
        this.classMeta = context.createClassMeta();
    }

    public void logEnhanced() {
        this.classMeta.logEnhanced();
    }

    public boolean isLog(int level) {
        return this.classMeta.isLog(level);
    }

    public void log(String msg) {
        this.classMeta.log(msg);
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.classMeta.setClassName(name, superName);
        int n = 1 + interfaces.length;
        String[] c = new String[n];
        for (int i = 0; i < interfaces.length; ++i) {
            c[i] = interfaces[i];
            if (c[i].equals("io/ebean/bean/EntityBean")) {
                this.classMeta.setEntityBeanInterface(true);
            }
            if (c[i].equals("scala/ScalaObject")) {
                this.classMeta.setScalaInterface(true);
            }
            if (!c[i].equals("groovy/lang/GroovyObject")) continue;
            this.classMeta.setGroovyInterface(true);
        }
        if (this.classMeta.hasEntityBeanInterface()) {
            c = interfaces;
        } else {
            c[c.length - 1] = "io/ebean/bean/EntityBean";
            if (this.classMeta.isLog(8)) {
                this.classMeta.log("... add EntityBean interface");
            }
        }
        if (!superName.equals("java/lang/Object")) {
            ClassMeta superMeta;
            if (this.classMeta.isLog(7)) {
                this.classMeta.log("read information about superClasses " + superName + " to see if it is entity/embedded/mappedSuperclass");
            }
            if ((superMeta = this.enhanceContext.getSuperMeta(superName, this.classLoader)) != null && superMeta.isEntity()) {
                this.classMeta.setSuperMeta(superMeta);
            }
        }
        super.visit(version, access, name, signature, superName, c);
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        this.classMeta.addClassAnnotation(desc);
        return super.visitAnnotation(desc, visible);
    }

    private boolean isEbeanFieldMarker(String name) {
        return name.equals("_EBEAN_MARKER");
    }

    private boolean isPropertyChangeListenerField(String desc) {
        return desc.equals("Ljava/beans/PropertyChangeSupport;");
    }

    @Override
    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        if ((access & 8) != 0) {
            if (this.isEbeanFieldMarker(name)) {
                this.classMeta.setAlreadyEnhanced(true);
                if (this.isLog(4)) {
                    this.log("Found ebean marker field " + name + " " + value);
                }
            } else if (this.isLog(4)) {
                this.log("Skip intercepting static field " + name);
            }
            return super.visitField(access, name, desc, signature, value);
        }
        if (this.isPropertyChangeListenerField(desc)) {
            if (this.isLog(4)) {
                this.classMeta.log("Found existing PropertyChangeSupport field " + name);
            }
            return super.visitField(access, name, desc, signature, value);
        }
        if ((access & 0x80) != 0) {
            return super.visitField(access, name, desc, signature, value);
        }
        if ((access & 0x10) != 0) {
            access ^= 0x10;
        }
        FieldVisitor fv = super.visitField(access, name, desc, signature, value);
        return this.classMeta.createLocalFieldVisitor(fv, name, desc);
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv;
        if (this.firstMethod) {
            if (this.classMeta.isAlreadyEnhanced()) {
                throw new NoEnhancementRequiredException();
            }
            if (this.classMeta.hasEntityBeanInterface()) {
                this.log("Enhancing when EntityBean interface already exists!");
            }
            String marker = MarkerField.addField(this.cv, this.classMeta);
            if (this.isLog(4)) {
                this.log("... add marker field \"" + marker + "\"");
            }
            IndexFieldWeaver.addPropertiesField(this.cv, this.classMeta);
            if (this.isLog(4)) {
                this.log("... add _ebean_props field");
            }
            if (!this.classMeta.isSuperClassEntity()) {
                if (this.isLog(4)) {
                    this.log("... add intercept and identity fields");
                }
                InterceptField.addField(this.cv, this.classMeta, this.enhanceContext.isTransientInternalFields());
                MethodEquals.addIdentityField(this.cv, this.classMeta);
            }
            this.firstMethod = false;
        }
        if (this.isLog(4)) {
            this.log("--- #### method name[" + name + "] desc[" + desc + "] sig[" + signature + "]");
        }
        if (this.isConstructor(name, desc)) {
            if (desc.equals("()V")) {
                access = 1;
            }
            mv = super.visitMethod(access, name, desc, signature, exceptions);
            return new ConstructorAdapter(mv, this.classMeta, desc);
        }
        if (this.isStaticInit(name, desc)) {
            if (this.isLog(4)) {
                this.log("... --- #### enhance existing static init method");
            }
            mv = super.visitMethod(8, name, desc, signature, exceptions);
            return new MethodStaticInitAdapter(mv, this.classMeta);
        }
        mv = super.visitMethod(access, name, desc, signature, exceptions);
        if (this.interceptEntityMethod(access, name, desc)) {
            return new MethodFieldAdapter(mv, this.classMeta, name + " " + desc);
        }
        return mv;
    }

    @Override
    public void visitEnd() {
        if (!this.classMeta.isEntityEnhancementRequired()) {
            throw new NoEnhancementRequiredException();
        }
        if (!this.classMeta.hasStaticInit()) {
            IndexFieldWeaver.addPropertiesInit(this.cv, this.classMeta);
        }
        if (!this.classMeta.hasDefaultConstructor()) {
            DefaultConstructor.add(this.cv, this.classMeta);
        }
        MarkerField.addGetMarker(this.cv, this.classMeta);
        if (this.isLog(4)) {
            this.log("... add _ebean_getPropertyNames() and _ebean_getPropertyName()");
        }
        IndexFieldWeaver.addGetPropertyNames(this.cv, this.classMeta);
        IndexFieldWeaver.addGetPropertyName(this.cv, this.classMeta);
        if (!this.classMeta.isSuperClassEntity()) {
            if (this.isLog(8)) {
                this.log("... add _ebean_getIntercept() and _ebean_setIntercept()");
            }
            InterceptField.addGetterSetter(this.cv, this.classMeta);
        }
        this.classMeta.addFieldGetSetMethods(this.cv);
        IndexFieldWeaver.addMethods(this.cv, this.classMeta);
        MethodSetEmbeddedLoaded.addMethod(this.cv, this.classMeta);
        MethodIsEmbeddedNewOrDirty.addMethod(this.cv, this.classMeta);
        MethodNewInstance.addMethod(this.cv, this.classMeta);
        this.enhanceContext.addClassMeta(this.classMeta);
        this.enhanceContext.summaryEntity(this.classMeta.getClassName());
        super.visitEnd();
    }

    private boolean isConstructor(String name, String desc) {
        if (name.equals("<init>")) {
            if (desc.equals("()V")) {
                this.classMeta.setHasDefaultConstructor(true);
            }
            return true;
        }
        return false;
    }

    private boolean isStaticInit(String name, String desc) {
        if (name.equals("<clinit>") && desc.equals("()V")) {
            this.classMeta.setHasStaticInit(true);
            return true;
        }
        return false;
    }

    private boolean interceptEntityMethod(int access, String name, String desc) {
        if ((access & 8) != 0) {
            if (this.isLog(4)) {
                this.log("Skip intercepting static method " + name);
            }
            return false;
        }
        if (name.equals("hashCode") && desc.equals("()I")) {
            this.classMeta.setHasEqualsOrHashcode(true);
            return true;
        }
        if (name.equals("equals") && desc.equals("(Ljava/lang/Object;)Z")) {
            this.classMeta.setHasEqualsOrHashcode(true);
            return true;
        }
        return !name.equals("toString") || !desc.equals("()Ljava/lang/String;");
    }
}

