/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.enhance.transactional;

import io.ebean.enhance.asm.MethodVisitor;
import io.ebean.enhance.asm.Opcodes;
import io.ebean.enhance.common.EnhanceConstants;
import io.ebean.enhance.transactional.ClassAdapterTransactional;

class ProfileMethodInstruction
implements EnhanceConstants,
Opcodes {
    private static final String QP_FIELD_PREFIX = "_$ebpq";
    private final ClassAdapterTransactional classAdapter;
    private final MethodVisitor mv;

    ProfileMethodInstruction(ClassAdapterTransactional classAdapter, MethodVisitor mv) {
        this.classAdapter = classAdapter;
        this.mv = mv;
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
        if (!this.classAdapter.isEnableProfileLocation()) {
            this.mv.visitMethodInsn(opcode, owner, name, desc, itf);
        } else if ("<init>".equals(name) && this.classAdapter.isQueryBean(owner)) {
            this.mv.visitMethodInsn(opcode, owner, name, desc, itf);
            if (!this.isAssocQueryBean(owner)) {
                int fieldIdx = this.classAdapter.nextQueryProfileLocation();
                if (this.classAdapter.isLog(4)) {
                    this.classAdapter.log("add profile location " + fieldIdx);
                }
                this.mv.visitFieldInsn(178, this.classAdapter.className(), QP_FIELD_PREFIX + fieldIdx, "Lio/ebean/ProfileLocation;");
                this.mv.visitMethodInsn(182, owner, "setProfileLocation", "(Lio/ebean/ProfileLocation;)Ljava/lang/Object;", false);
                this.mv.visitTypeInsn(192, owner);
            }
        } else if (!this.classAdapter.isFinder()) {
            this.mv.visitMethodInsn(opcode, owner, name, desc, itf);
        } else if (this.isNewQuery(name, desc)) {
            int fieldIdx = this.classAdapter.nextQueryProfileLocation();
            this.mv.visitMethodInsn(opcode, owner, name, desc, itf);
            this.mv.visitFieldInsn(178, this.classAdapter.className(), QP_FIELD_PREFIX + fieldIdx, "Lio/ebean/ProfileLocation;");
            this.mv.visitMethodInsn(185, "io/ebean/Query", "setProfileLocation", "(Lio/ebean/ProfileLocation;)Lio/ebean/Query;", true);
            if (this.classAdapter.isLog(4)) {
                this.classAdapter.log("add profile location " + fieldIdx);
            }
        } else if (this.isNewUpdateQuery(name, desc)) {
            int fieldIdx = this.classAdapter.nextQueryProfileLocation();
            this.mv.visitMethodInsn(opcode, owner, name, desc, itf);
            this.mv.visitFieldInsn(178, this.classAdapter.className(), QP_FIELD_PREFIX + fieldIdx, "Lio/ebean/ProfileLocation;");
            this.mv.visitMethodInsn(185, "io/ebean/UpdateQuery", "setProfileLocation", "(Lio/ebean/ProfileLocation;)Lio/ebean/UpdateQuery;", true);
            if (this.classAdapter.isLog(4)) {
                this.classAdapter.log("add profile location " + fieldIdx);
            }
        } else {
            this.mv.visitMethodInsn(opcode, owner, name, desc, itf);
        }
    }

    private boolean isAssocQueryBean(String owner) {
        return owner.contains("/query/assoc/QAssoc");
    }

    private boolean isNewUpdateQuery(String name, String desc) {
        return name.equals("update") && desc.equals("()Lio/ebean/UpdateQuery;");
    }

    private boolean isNewQuery(String name, String desc) {
        if (name.equals("query") && (desc.equals("()Lio/ebean/Query;") || desc.equals("(Ljava/lang/String;)Lio/ebean/Query;"))) {
            return true;
        }
        return name.equals("nativeSql") && desc.equals("(Ljava/lang/String;)Lio/ebean/Query;");
    }
}

