/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.enhance.querybean;

import io.ebean.enhance.asm.ClassVisitor;
import io.ebean.enhance.common.EnhanceContext;
import io.ebean.enhance.querybean.Constants;
import io.ebean.enhance.querybean.FieldInfo;
import io.ebean.enhance.querybean.TypeQueryAssocBasicConstructor;
import io.ebean.enhance.querybean.TypeQueryAssocMainConstructor;
import java.util.ArrayList;
import java.util.List;

class ClassInfo
implements Constants {
    private final EnhanceContext enhanceContext;
    private final String className;
    private boolean addedMarkerAnnotation;
    private boolean typeQueryBean;
    private boolean typeQueryUser;
    private boolean fieldAccessUser;
    private boolean alreadyEnhanced;
    private List<FieldInfo> fields;
    private boolean hasBasicConstructor;
    private boolean hasMainConstructor;
    private boolean entityBean;

    public ClassInfo(EnhanceContext enhanceContext, String className) {
        this.enhanceContext = enhanceContext;
        this.className = className;
    }

    public void setEntityBean() {
        this.entityBean = true;
    }

    public boolean isEntityBean() {
        return this.entityBean;
    }

    public String getClassName() {
        return this.className;
    }

    String getShortName() {
        int pos = this.className.lastIndexOf("/");
        return this.className.substring(pos + 1);
    }

    boolean isAlreadyEnhanced() {
        return this.alreadyEnhanced;
    }

    boolean addMarkerAnnotation() {
        if (this.addedMarkerAnnotation) {
            return false;
        }
        this.addedMarkerAnnotation = true;
        return true;
    }

    boolean isTypeQueryBean() {
        return this.typeQueryBean;
    }

    boolean isTypeQueryUser() {
        return this.typeQueryUser;
    }

    public boolean isFieldAccessUser() {
        return this.fieldAccessUser;
    }

    void markTypeQueryEnhanced() {
        this.typeQueryUser = true;
    }

    boolean checkTypeQueryAnnotation(String desc) {
        if (this.isTypeQueryBeanAnnotation(desc)) {
            this.typeQueryBean = true;
        } else if (this.isAlreadyEnhancedAnnotation(desc)) {
            this.alreadyEnhanced = true;
        }
        return this.typeQueryBean;
    }

    void addField(int access, String name, String desc, String signature) {
        if ((access & 1) != 0) {
            if (this.fields == null) {
                this.fields = new ArrayList<FieldInfo>();
            }
            if ((access & 8) == 0) {
                this.fields.add(new FieldInfo(this, name, desc, signature));
            }
        }
    }

    private boolean isAlreadyEnhancedAnnotation(String desc) {
        return "Lio/ebean/typequery/AlreadyEnhancedMarker;".equals(desc);
    }

    private boolean isTypeQueryBeanAnnotation(String desc) {
        return "Lio/ebean/typequery/TypeQueryBean;".equals(desc);
    }

    public List<FieldInfo> getFields() {
        return this.fields;
    }

    void addGetFieldIntercept(String owner, String name) {
        if (this.isLog(4)) {
            this.log("change getfield " + owner + " name:" + name);
        }
        this.typeQueryUser = true;
    }

    void markEntityFieldAccess(String type, String owner, String name) {
        if (this.isLog(2)) {
            this.log("replace " + type + " field access " + owner + "." + name);
        }
        this.fieldAccessUser = true;
    }

    public boolean isLog(int level) {
        return this.enhanceContext.isLog(level);
    }

    public void log(String msg) {
        this.enhanceContext.log(this.className, msg);
    }

    void setHasBasicConstructor() {
        this.hasBasicConstructor = true;
    }

    void setHasMainConstructor() {
        this.hasMainConstructor = true;
    }

    void addAssocBeanExtras(ClassVisitor cv) {
        if (this.isLog(4)) {
            String msg = "... add fields";
            if (!this.hasBasicConstructor) {
                msg = msg + ", basic constructor";
            }
            if (!this.hasMainConstructor) {
                msg = msg + ", main constructor";
            }
            this.log(msg);
        }
        if (!this.hasBasicConstructor) {
            new TypeQueryAssocBasicConstructor(this, cv, "(Ljava/lang/String;Ljava/lang/Object;I)V", "(Ljava/lang/String;TR;I)V").visitCode();
        }
        if (!this.hasMainConstructor) {
            new TypeQueryAssocMainConstructor(this, cv, "(Ljava/lang/String;Ljava/lang/Object;Ljava/lang/String;I)V", "(Ljava/lang/String;TR;Ljava/lang/String;I)V").visitCode();
        }
    }
}

