/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.enhance.common;

import io.ebean.enhance.common.UrlHelper;
import io.ebean.enhance.querybean.DetectQueryBean;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public final class AgentManifest {
    private final Set<Integer> classLoaderIdentities = new HashSet<Integer>();
    private final List<String> loadedResources = new ArrayList<String>();
    private final Set<String> entityPackages = new HashSet<String>();
    private final Set<String> transactionalPackages = new HashSet<String>();
    private final Set<String> querybeanPackages = new HashSet<String>();
    private final DetectQueryBean detectQueryBean = new DetectQueryBean();
    private int debugLevel = -1;
    private boolean allowNullableDbArray;
    private boolean transientInternalFields;
    private boolean transientInit;
    private boolean transientInitThrowError;
    private boolean checkNullManyFields = true;
    private boolean enableProfileLocation = true;
    private boolean enableEntityFieldAccess;
    private boolean synthetic = true;
    private int enhancementVersion;

    public AgentManifest(ClassLoader classLoader) {
        this.readManifest(classLoader);
    }

    public AgentManifest() {
    }

    public boolean readManifest(ClassLoader classLoader) {
        if (classLoader == null) {
            return false;
        }
        int loaderIdentity = System.identityHashCode(classLoader);
        if (this.classLoaderIdentities.add(loaderIdentity)) {
            try {
                int beforeSize = this.entityPackages.size();
                this.readEbeanVersion(classLoader, "META-INF/ebean-version.mf");
                this.readManifests(classLoader, "META-INF/ebean-generated-info.mf");
                this.readManifests(classLoader, "META-INF/ebean.mf");
                this.readManifests(classLoader, "ebean.mf");
                int afterSize = this.entityPackages.size();
                if (afterSize > beforeSize) {
                    this.detectQueryBean.addAll(this.entityPackages);
                    return true;
                }
            }
            catch (IOException e) {
                System.err.println("Agent: error reading ebean manifest resources");
                e.printStackTrace();
            }
        }
        return false;
    }

    public String toString() {
        return "entityPackages:" + this.entityPackages + " querybeanPackages:" + this.querybeanPackages + " transactionalPackages:" + this.transactionalPackages;
    }

    public boolean isDetectEntityBean(String owner) {
        return this.detectQueryBean.isEntityBean(owner);
    }

    public boolean isDetectQueryBean(String owner) {
        return this.detectQueryBean.isQueryBean(owner);
    }

    public int enhancementVersion() {
        return this.enhancementVersion;
    }

    public boolean isEnableProfileLocation() {
        return this.enableProfileLocation;
    }

    public boolean isEnableEntityFieldAccess() {
        return this.enableEntityFieldAccess;
    }

    public int debugLevel() {
        return this.debugLevel;
    }

    public List<String> loadedResources() {
        return this.loadedResources;
    }

    public Set<String> entityPackages() {
        return this.entityPackages;
    }

    public boolean isTransactionalNone() {
        return this.transactionalPackages.contains("none") && this.transactionalPackages.size() == 1;
    }

    public boolean isTransientInit() {
        return this.transientInit;
    }

    public boolean isTransientInitThrowError() {
        return this.transientInitThrowError;
    }

    public boolean isTransientInternalFields() {
        return this.transientInternalFields;
    }

    public boolean isCheckNullManyFields() {
        return this.checkNullManyFields;
    }

    public boolean isAllowNullableDbArray() {
        return this.allowNullableDbArray;
    }

    public int accPublic() {
        return this.synthetic ? 4097 : 1;
    }

    public int accProtected() {
        return this.synthetic ? 4100 : 4;
    }

    public int accPrivate() {
        return this.synthetic ? 4098 : 2;
    }

    public boolean isQueryBeanNone() {
        return this.querybeanPackages.contains("none") && this.querybeanPackages.size() == 1;
    }

    public Set<String> transactionalPackages() {
        return this.transactionalPackages;
    }

    public Set<String> querybeanPackages() {
        return this.querybeanPackages;
    }

    protected void readEbeanVersion(ClassLoader classLoader, String path) throws IOException {
        Enumeration<URL> resources = classLoader.getResources(path);
        while (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            try {
                Manifest manifest = this.manifest(UrlHelper.openNoCache(url));
                String value = manifest.getMainAttributes().getValue("ebean-version");
                if (value != null) {
                    this.enhancementVersion = Integer.parseInt(value.trim());
                    if (this.enhancementVersion > 141) {
                        this.allowNullableDbArray = true;
                        this.transientInit = true;
                        this.transientInitThrowError = true;
                    }
                }
                this.loadedResources.add(path);
            }
            catch (Exception e) {
                System.err.println("Error reading manifest resources " + url);
                e.printStackTrace();
            }
        }
    }

    void readManifests(ClassLoader classLoader, String path) throws IOException {
        Enumeration<URL> resources = classLoader.getResources(path);
        while (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            try {
                this.addResource(UrlHelper.openNoCache(url));
                this.loadedResources.add(path);
            }
            catch (IOException e) {
                System.err.println("Error reading manifest resources " + url);
                e.printStackTrace();
            }
        }
    }

    private void addResource(InputStream is) throws IOException {
        this.addManifest(this.manifest(is));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Manifest manifest(InputStream is) throws IOException {
        try {
            Manifest manifest = new Manifest(is);
            return manifest;
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                System.err.println("Error closing manifest resource");
                e.printStackTrace();
            }
        }
    }

    private void readProfilingMode(Attributes attributes) {
        String syntheticOption;
        String fieldAccessMode;
        String locationMode;
        String debug = attributes.getValue("debug");
        if (debug != null) {
            this.debugLevel = Integer.parseInt(debug);
        }
        if ((locationMode = attributes.getValue("profile-location")) != null) {
            this.enableProfileLocation = Boolean.parseBoolean(locationMode);
        }
        if ((fieldAccessMode = attributes.getValue("entity-field-access")) != null) {
            this.enableEntityFieldAccess = Boolean.parseBoolean(fieldAccessMode);
        }
        if ((syntheticOption = attributes.getValue("synthetic")) != null) {
            this.synthetic = Boolean.parseBoolean(syntheticOption);
        }
    }

    private void addManifest(Manifest manifest) {
        Attributes attributes = manifest.getMainAttributes();
        this.readProfilingMode(attributes);
        this.readOptions(attributes);
        this.add(this.entityPackages, attributes.getValue("packages"));
        this.add(this.entityPackages, attributes.getValue("entity-packages"));
        this.add(this.transactionalPackages, attributes.getValue("transactional-packages"));
        this.add(this.querybeanPackages, attributes.getValue("querybean-packages"));
        String topPackages = attributes.getValue("top-packages");
        if (topPackages != null) {
            this.add(this.transactionalPackages, topPackages);
            this.add(this.querybeanPackages, topPackages);
        }
    }

    private void readOptions(Attributes attributes) {
        this.transientInit = this.bool("transient-init", this.transientInit, attributes);
        this.transientInitThrowError = this.bool("transient-init-error", this.transientInit, attributes);
        this.transientInternalFields = this.bool("transient-internal-fields", this.transientInternalFields, attributes);
        this.checkNullManyFields = this.bool("check-null-many-fields", this.checkNullManyFields, attributes);
        this.allowNullableDbArray = this.bool("allow-nullable-dbarray", this.allowNullableDbArray, attributes);
    }

    private boolean bool(String key, boolean defaultValue, Attributes attributes) {
        String val = attributes.getValue(key);
        return val != null ? Boolean.parseBoolean(val) : defaultValue;
    }

    private void add(Set<String> addTo, String packages) {
        if (packages != null) {
            String[] split;
            for (String aSplit : split = packages.split("[,; ]")) {
                String pkg = aSplit.trim();
                if (pkg.isEmpty()) continue;
                addTo.add(pkg);
            }
        }
    }
}

