/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.enhance.entity;

import io.ebean.enhance.asm.MethodVisitor;
import io.ebean.enhance.entity.ConstructorAdapter;
import io.ebean.enhance.entity.DeferredCode;
import java.util.ArrayList;
import java.util.List;

public final class CapturedInitCode {
    private final String name;
    private final String type;
    private final List<DeferredCode> code;

    CapturedInitCode(List<DeferredCode> codes, int opcode, String owner, String name, String desc, String type) {
        this.name = name;
        this.type = type;
        this.code = new ArrayList<DeferredCode>(codes);
        this.code.add(new PutField(opcode, owner, name, desc));
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    public void write(ConstructorAdapter mv) {
        for (DeferredCode deferredCode : this.code) {
            deferredCode.write(mv);
        }
    }

    public String mismatch(String type2) {
        return "type1:" + this.type + " type2:" + type2;
    }

    private static class PutField
    implements DeferredCode {
        final int opcode;
        final String owner;
        final String name;
        final String desc;

        public PutField(int opcode, String owner, String name, String desc) {
            this.opcode = opcode;
            this.owner = owner;
            this.name = name;
            this.desc = desc;
        }

        @Override
        public void write(MethodVisitor mv) {
            mv.visitFieldInsn(this.opcode, this.owner, this.name, this.desc);
        }
    }
}

