/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.enhance.entity;

import io.ebean.enhance.asm.ClassVisitor;
import io.ebean.enhance.asm.Label;
import io.ebean.enhance.asm.MethodVisitor;
import io.ebean.enhance.asm.Opcodes;
import io.ebean.enhance.asm.Type;
import io.ebean.enhance.common.ClassMeta;
import io.ebean.enhance.common.EnhanceConstants;
import io.ebean.enhance.common.VisitUtil;
import io.ebean.enhance.entity.PrimitiveHelper;
import java.util.HashSet;

public final class FieldMeta
implements Opcodes,
EnhanceConstants,
Comparable<FieldMeta> {
    private final ClassMeta classMeta;
    private final String fieldClass;
    private final String fieldName;
    private final String fieldDesc;
    private final HashSet<String> annotations = new HashSet();
    private final Type asmType;
    private final boolean primitiveType;
    private final boolean objectType;
    private final String getMethodName;
    private final String getMethodDesc;
    private final String setMethodName;
    private final String setMethodDesc;
    private final String getNoInterceptMethodName;
    private final String setNoInterceptMethodName;
    private int indexPosition;
    private int sortOrder;
    private boolean notNull;

    public FieldMeta(ClassMeta classMeta, String name, String desc, String fieldClass) {
        this.classMeta = classMeta;
        this.fieldName = name;
        this.fieldDesc = desc;
        this.fieldClass = fieldClass;
        this.asmType = Type.getType(desc);
        int sort = this.asmType.getSort();
        this.primitiveType = sort > 0 && sort <= 8;
        this.objectType = sort == 10;
        this.getMethodDesc = "()" + desc;
        this.setMethodDesc = "(" + desc + ")V";
        this.getMethodName = "_ebean_get_" + name;
        this.setMethodName = "_ebean_set_" + name;
        this.getNoInterceptMethodName = "_ebean_getni_" + name;
        this.setNoInterceptMethodName = "_ebean_setni_" + name;
    }

    @Override
    public int compareTo(FieldMeta other) {
        return Integer.compare(this.sortOrder, other.sortOrder);
    }

    void setSortOrder(int i) {
        this.sortOrder = this.isId() ? i - 10000 : (this.isToMany() ? i + 10000 : (this.isToOne() ? i + 9000 : (this.isEmbedded() ? i + 8000 : (this.isDbJson() ? i + 7000 : (this.isDbArray() ? i + 6000 : (this.isWhen() ? i + 2000 : (this.isVersion() ? i + 1000 : i)))))));
    }

    public void setIndexPosition(int indexPosition) {
        this.indexPosition = indexPosition;
    }

    public String toString() {
        return this.fieldName;
    }

    public String name() {
        return this.fieldName;
    }

    public boolean isPrimitiveType() {
        return this.primitiveType;
    }

    public void setNotNull() {
        this.notNull = true;
    }

    public boolean isNullable() {
        return !this.notNull;
    }

    void addAnnotationDesc(String desc) {
        this.annotations.add(desc);
        if (!this.notNull && desc.equals("Lio/ebean/annotation/NotNull;")) {
            this.notNull = true;
        }
    }

    private boolean isInterceptGet() {
        return !this.isId() && !this.isTransient();
    }

    private boolean isInterceptSet() {
        return !this.isId() && !this.isTransient() && !this.isToMany();
    }

    public boolean isObjectArray() {
        if (this.fieldDesc.charAt(0) == '[' && this.fieldDesc.length() > 2) {
            if (!this.isTransient()) {
                System.err.println("ERROR: We can not support Object Arrays... for field: " + this.fieldName);
            }
            return true;
        }
        return false;
    }

    public boolean isPersistent() {
        return !this.isTransient();
    }

    public boolean isTransient() {
        return this.annotations.contains("Ljavax/persistence/Transient;") || this.annotations.contains("Ljakarta/persistence/Transient;") || this.annotations.contains("Lio/ebean/annotation/Draft;");
    }

    public boolean isId() {
        return this.annotations.contains("Ljavax/persistence/Id;") || this.annotations.contains("Ljakarta/persistence/Id;") || this.annotations.contains("Ljavax/persistence/EmbeddedId;") || this.annotations.contains("Ljakarta/persistence/EmbeddedId;");
    }

    private boolean isToOne() {
        return this.annotations.contains("Ljavax/persistence/OneToOne;") || this.annotations.contains("Ljakarta/persistence/OneToOne;") || this.annotations.contains("Ljavax/persistence/ManyToOne;") || this.annotations.contains("Ljakarta/persistence/ManyToOne;");
    }

    public boolean isToMany() {
        return this.annotations.contains("Ljavax/persistence/OneToMany;") || this.annotations.contains("Ljakarta/persistence/OneToMany;") || this.annotations.contains("Ljavax/persistence/ManyToMany;") || this.annotations.contains("Ljakarta/persistence/ManyToMany;");
    }

    private boolean isManyToMany() {
        return this.annotations.contains("Ljavax/persistence/ManyToMany;") || this.annotations.contains("Ljakarta/persistence/ManyToMany;");
    }

    public boolean isInitMany() {
        return this.isToMany() || this.isInitDbArray();
    }

    private boolean isInitDbArray() {
        return this.isDbArray() && (this.notNull || !this.classMeta.isAllowNullableDbArray());
    }

    private boolean isDbArray() {
        return this.annotations.contains("Lio/ebean/annotation/DbArray;");
    }

    private boolean isDbJson() {
        return this.annotations.contains("Lio/ebean/annotation/DbJson;") || this.annotations.contains("Lio/ebean/annotation/DbJsonB;");
    }

    private boolean isWhen() {
        return this.annotations.contains("Lio/ebean/annotation/WhenModified;") || this.annotations.contains("Lio/ebean/annotation/WhenCreated;");
    }

    private boolean isVersion() {
        return this.annotations.contains("Ljavax/persistence/Version;") || this.annotations.contains("Ljakarta/persistence/Version;");
    }

    boolean isEmbedded() {
        return this.annotations.contains("Ljavax/persistence/Embedded;") || this.annotations.contains("Ljakarta/persistence/Embedded;");
    }

    boolean hasOrderColumn() {
        return this.annotations.contains("Ljavax/persistence/OrderColumn;") || this.annotations.contains("Ljakarta/persistence/OrderColumn;");
    }

    boolean isLocalField(ClassMeta classMeta) {
        return this.fieldClass.equals(classMeta.className());
    }

    void appendGetPrimitiveIdValue(MethodVisitor mv, ClassMeta classMeta) {
        mv.visitMethodInsn(182, classMeta.className(), this.getMethodName, this.getMethodDesc, false);
    }

    void appendCompare(MethodVisitor mv, ClassMeta classMeta) {
        if (this.primitiveType) {
            if (classMeta.isLog(4)) {
                classMeta.log(" ... getIdentity compare primitive field[" + this.fieldName + "] type[" + this.fieldDesc + "]");
            }
            if (this.fieldDesc.equals("J")) {
                mv.visitInsn(9);
                mv.visitInsn(148);
            } else if (this.fieldDesc.equals("D")) {
                mv.visitInsn(14);
                mv.visitInsn(151);
            } else if (this.fieldDesc.equals("F")) {
                mv.visitInsn(11);
                mv.visitInsn(149);
            }
        }
    }

    void appendValueOf(MethodVisitor mv) {
        if (this.primitiveType) {
            Type objectWrapperType = PrimitiveHelper.getObjectWrapper(this.asmType);
            String objDesc = objectWrapperType.getInternalName();
            String primDesc = this.asmType.getDescriptor();
            mv.visitMethodInsn(184, objDesc, "valueOf", "(" + primDesc + ")L" + objDesc + ";", false);
        }
    }

    void appendSwitchGet(MethodVisitor mv, ClassMeta classMeta, boolean intercept) {
        if (intercept) {
            mv.visitMethodInsn(182, classMeta.className(), this.getMethodName, this.getMethodDesc, false);
        } else if (this.isLocalField(classMeta)) {
            mv.visitFieldInsn(180, classMeta.className(), this.fieldName, this.fieldDesc);
        } else {
            mv.visitMethodInsn(182, classMeta.className(), this.getNoInterceptMethodName, this.getMethodDesc, false);
        }
        if (this.primitiveType) {
            this.appendValueOf(mv);
        }
    }

    void appendSwitchSet(MethodVisitor mv, ClassMeta classMeta, boolean intercept) {
        if (this.primitiveType) {
            Type objectWrapperType = PrimitiveHelper.getObjectWrapper(this.asmType);
            String primDesc = this.asmType.getDescriptor();
            String primType = this.asmType.getClassName();
            String objInt = objectWrapperType.getInternalName();
            mv.visitTypeInsn(192, objInt);
            mv.visitMethodInsn(182, objInt, primType + "Value", "()" + primDesc, false);
        } else {
            mv.visitTypeInsn(192, this.asmType.getInternalName());
        }
        if (intercept) {
            mv.visitMethodInsn(182, classMeta.className(), this.setMethodName, this.setMethodDesc, false);
        } else {
            mv.visitMethodInsn(182, classMeta.className(), this.setNoInterceptMethodName, this.setMethodDesc, false);
        }
    }

    public void addGetSetMethods(ClassVisitor cv, ClassMeta classMeta) {
        if (!this.isLocalField(classMeta)) {
            String msg = "ERROR: " + this.fieldClass + " != " + classMeta.className() + " for field " + this.fieldName + " " + this.fieldDesc;
            throw new RuntimeException(msg);
        }
        this.addGet(cv, classMeta);
        this.addSet(cv, classMeta);
        this.addGetNoIntercept(cv, classMeta);
        this.addSetNoIntercept(cv, classMeta);
    }

    private String initCollectionClass() {
        boolean dbArray = this.isDbArray();
        if (this.fieldDesc.equals("Ljava/util/List;")) {
            return dbArray ? "java/util/ArrayList" : "io/ebean/common/BeanList";
        }
        if (this.fieldDesc.equals("Ljava/util/Set;")) {
            return dbArray ? "java/util/LinkedHashSet" : "io/ebean/common/BeanSet";
        }
        if (this.fieldDesc.equals("Ljava/util/Map;")) {
            return dbArray ? "java/util/LinkedHashMap" : "io/ebean/common/BeanMap";
        }
        return null;
    }

    private void addGet(ClassVisitor cw, ClassMeta classMeta) {
        MethodVisitor mv = cw.visitMethod(classMeta.accAccessor(), this.getMethodName, this.getMethodDesc, null, null);
        mv.visitCode();
        if (this.isInitMany()) {
            this.addGetForMany(mv);
            return;
        }
        int iReturnOpcode = this.asmType.getOpcode(172);
        String className = classMeta.className();
        Label labelEnd = new Label();
        Label labelStart = null;
        int maxVars = 1;
        if (this.isId()) {
            labelStart = new Label();
            mv.visitLabel(labelStart);
            mv.visitLineNumber(5, labelStart);
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, className, "_ebean_intercept", "Lio/ebean/bean/EntityBeanIntercept;");
            classMeta.visitMethodInsnIntercept(mv, "preGetId", "()V");
        } else if (this.isInterceptGet()) {
            maxVars = 2;
            labelStart = new Label();
            mv.visitLabel(labelStart);
            mv.visitLineNumber(6, labelStart);
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, className, "_ebean_intercept", "Lio/ebean/bean/EntityBeanIntercept;");
            VisitUtil.visitIntInsn(mv, this.indexPosition);
            classMeta.visitMethodInsnIntercept(mv, "preGetter", "(I)V");
        }
        if (labelStart == null) {
            labelStart = labelEnd;
        }
        mv.visitLabel(labelEnd);
        mv.visitLineNumber(7, labelEnd);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, className, this.fieldName, this.fieldDesc);
        mv.visitInsn(iReturnOpcode);
        Label labelEnd1 = new Label();
        mv.visitLabel(labelEnd1);
        mv.visitLocalVariable("this", "L" + className + ";", null, labelStart, labelEnd1, 0);
        mv.visitMaxs(maxVars, 1);
        mv.visitEnd();
    }

    private void addGetForMany(MethodVisitor mv) {
        String className = this.classMeta.className();
        String ebCollection = this.initCollectionClass();
        Label l0 = new Label();
        mv.visitLabel(l0);
        mv.visitLineNumber(1, l0);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, className, "_ebean_intercept", "Lio/ebean/bean/EntityBeanIntercept;");
        VisitUtil.visitIntInsn(mv, this.indexPosition);
        this.classMeta.visitMethodInsnIntercept(mv, "preGetter", "(I)V");
        Label l4 = new Label();
        if (this.classMeta.context().isCheckNullManyFields()) {
            if (ebCollection == null) {
                String msg = "Unexpected collection type [" + Type.getType(this.fieldDesc).getClassName() + "] for [" + this.classMeta.className() + "." + this.fieldName + "] expected either java.util.List, java.util.Set or java.util.Map ";
                throw new RuntimeException(msg);
            }
            Label l3 = new Label();
            mv.visitLabel(l3);
            mv.visitLineNumber(2, l3);
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, className, this.fieldName, this.fieldDesc);
            mv.visitJumpInsn(199, l4);
            Label l5 = new Label();
            mv.visitLabel(l5);
            mv.visitLineNumber(3, l5);
            mv.visitVarInsn(25, 0);
            mv.visitTypeInsn(187, ebCollection);
            mv.visitInsn(89);
            mv.visitMethodInsn(183, ebCollection, "<init>", "()V", false);
            mv.visitFieldInsn(181, className, this.fieldName, this.fieldDesc);
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, className, "_ebean_intercept", "Lio/ebean/bean/EntityBeanIntercept;");
            VisitUtil.visitIntInsn(mv, this.indexPosition);
            this.classMeta.visitMethodInsnIntercept(mv, "initialisedMany", "(I)V");
            if (this.isManyToMany() || this.hasOrderColumn()) {
                Label l6 = new Label();
                mv.visitLabel(l6);
                mv.visitLineNumber(4, l6);
                mv.visitVarInsn(25, 0);
                mv.visitFieldInsn(180, className, this.fieldName, this.fieldDesc);
                mv.visitTypeInsn(192, "io/ebean/bean/BeanCollection");
                mv.visitFieldInsn(178, "io/ebean/bean/BeanCollection$ModifyListenMode", "ALL", "Lio/ebean/bean/BeanCollection$ModifyListenMode;");
                mv.visitMethodInsn(185, "io/ebean/bean/BeanCollection", "setModifyListening", "(Lio/ebean/bean/BeanCollection$ModifyListenMode;)V", true);
            }
        }
        mv.visitLabel(l4);
        mv.visitLineNumber(5, l4);
        mv.visitFrame(3, 0, null, 0, null);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, className, this.fieldName, this.fieldDesc);
        mv.visitInsn(176);
        Label l7 = new Label();
        mv.visitLabel(l7);
        mv.visitLocalVariable("this", "L" + className + ";", null, l0, l7, 0);
        mv.visitMaxs(3, 1);
        mv.visitEnd();
    }

    private void addGetNoIntercept(ClassVisitor cw, ClassMeta classMeta) {
        int iReturnOpcode = this.asmType.getOpcode(172);
        MethodVisitor mv = cw.visitMethod(classMeta.accProtected(), this.getNoInterceptMethodName, this.getMethodDesc, null, null);
        mv.visitCode();
        Label l0 = new Label();
        mv.visitLabel(l0);
        mv.visitLineNumber(1, l0);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, this.fieldClass, this.fieldName, this.fieldDesc);
        mv.visitInsn(iReturnOpcode);
        Label l2 = new Label();
        mv.visitLabel(l2);
        mv.visitLocalVariable("this", "L" + this.fieldClass + ";", null, l0, l2, 0);
        mv.visitMaxs(2, 1);
        mv.visitEnd();
    }

    private void addSet(ClassVisitor cw, ClassMeta classMeta) {
        String preSetterArgTypes = "Ljava/lang/Object;Ljava/lang/Object;";
        if (!this.objectType) {
            preSetterArgTypes = this.fieldDesc + this.fieldDesc;
        }
        int iLoadOpcode = this.asmType.getOpcode(21);
        MethodVisitor mv = cw.visitMethod(classMeta.accAccessor(), this.setMethodName, this.setMethodDesc, null, null);
        mv.visitCode();
        Label l0 = new Label();
        mv.visitLabel(l0);
        mv.visitLineNumber(1, l0);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, this.fieldClass, "_ebean_intercept", "Lio/ebean/bean/EntityBeanIntercept;");
        if (this.isInterceptSet()) {
            mv.visitInsn(4);
        } else {
            mv.visitInsn(3);
        }
        VisitUtil.visitIntInsn(mv, this.indexPosition);
        mv.visitVarInsn(25, 0);
        if (this.isId() || this.isToManyGetField(classMeta)) {
            mv.visitFieldInsn(180, this.fieldClass, this.fieldName, this.fieldDesc);
        } else {
            mv.visitMethodInsn(182, this.fieldClass, this.getMethodName, this.getMethodDesc, false);
        }
        mv.visitVarInsn(iLoadOpcode, 1);
        String preSetterMethod = "preSetter";
        if (this.isToMany()) {
            preSetterMethod = "preSetterMany";
        }
        classMeta.visitMethodInsnIntercept(mv, preSetterMethod, "(ZI" + preSetterArgTypes + ")V");
        Label l1 = new Label();
        mv.visitLabel(l1);
        mv.visitLineNumber(2, l1);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(iLoadOpcode, 1);
        mv.visitFieldInsn(181, this.fieldClass, this.fieldName, this.fieldDesc);
        Label l3 = new Label();
        mv.visitLabel(l3);
        mv.visitLineNumber(4, l3);
        mv.visitInsn(177);
        Label l4 = new Label();
        mv.visitLabel(l4);
        mv.visitLocalVariable("this", "L" + this.fieldClass + ";", null, l0, l4, 0);
        mv.visitLocalVariable("newValue", this.fieldDesc, null, l0, l4, 1);
        mv.visitMaxs(5, 2);
        mv.visitEnd();
    }

    private boolean isToManyGetField(ClassMeta meta) {
        return this.isToMany() && meta.isToManyGetField();
    }

    private void addSetNoIntercept(ClassVisitor cw, ClassMeta classMeta) {
        int iLoadOpcode = this.asmType.getOpcode(21);
        MethodVisitor mv = cw.visitMethod(classMeta.accProtected(), this.setNoInterceptMethodName, this.setMethodDesc, null, null);
        mv.visitCode();
        Label l0 = new Label();
        mv.visitLabel(l0);
        mv.visitLineNumber(1, l0);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(iLoadOpcode, 1);
        mv.visitFieldInsn(181, this.fieldClass, this.fieldName, this.fieldDesc);
        Label l1 = new Label();
        mv.visitLabel(l1);
        mv.visitLineNumber(2, l1);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, this.fieldClass, "_ebean_intercept", "Lio/ebean/bean/EntityBeanIntercept;");
        VisitUtil.visitIntInsn(mv, this.indexPosition);
        classMeta.visitMethodInsnIntercept(mv, "setLoadedProperty", "(I)V");
        Label l2 = new Label();
        mv.visitLabel(l2);
        mv.visitLineNumber(1, l2);
        mv.visitInsn(177);
        Label l3 = new Label();
        mv.visitLabel(l3);
        mv.visitLocalVariable("this", "L" + this.fieldClass + ";", null, l0, l3, 0);
        mv.visitLocalVariable("_newValue", this.fieldDesc, null, l0, l3, 1);
        mv.visitMaxs(4, 2);
        mv.visitEnd();
    }
}

