/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.enhance.common;

import io.ebean.enhance.common.AgentManifest;
import io.ebean.enhance.common.DistillPackages;
import java.util.Arrays;

class FilterQueryBean {
    private final boolean ignoreAll;
    private final boolean detectOnAll;
    private final String[] topLevelPackages;

    FilterQueryBean(AgentManifest manifest) {
        this.ignoreAll = manifest.isQueryBeanNone();
        this.detectOnAll = manifest.querybeanPackages().isEmpty();
        DistillPackages distill = new DistillPackages().add(manifest.entityPackages());
        if (!manifest.isQueryBeanNone()) {
            distill.add(manifest.querybeanPackages());
        }
        this.topLevelPackages = distill.distill();
    }

    public String toString() {
        return "ignoreAll:" + this.ignoreAll + " detectOnAll:" + this.detectOnAll + " topLevelPackages:" + Arrays.toString(this.topLevelPackages);
    }

    boolean detectEnhancement(String className) {
        if (this.ignoreAll) {
            return false;
        }
        if (this.detectOnAll) {
            return true;
        }
        for (String pkg : this.topLevelPackages) {
            if (!className.startsWith(pkg)) continue;
            return true;
        }
        return false;
    }
}

