/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.enhance.querybean;

import io.ebean.enhance.asm.MethodVisitor;
import io.ebean.enhance.asm.Opcodes;
import io.ebean.enhance.common.EnhanceContext;
import io.ebean.enhance.querybean.ClassInfo;

class MethodAdapter
extends MethodVisitor
implements Opcodes {
    private final EnhanceContext enhanceContext;
    private final ClassInfo classInfo;
    private final ClassLoader loader;

    MethodAdapter(MethodVisitor mv, EnhanceContext enhanceContext, ClassInfo classInfo, ClassLoader loader) {
        super(589824, mv);
        this.enhanceContext = enhanceContext;
        this.classInfo = classInfo;
        this.loader = loader;
    }

    private boolean isQueryBean(String owner) {
        return this.enhanceContext.isQueryBean(owner, this.loader);
    }

    private boolean isEntityBean(String owner) {
        return this.enhanceContext.isEntityBean(owner);
    }

    @Override
    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        if (opcode == 178 || opcode == 179) {
            super.visitFieldInsn(opcode, owner, name, desc);
            return;
        }
        if (opcode == 180 && this.isQueryBean(owner)) {
            this.classInfo.addGetFieldIntercept(owner, name);
            this.mv.visitMethodInsn(182, owner, "_" + name, "()" + desc, false);
        } else {
            if (opcode == 180 && this.fieldAccessReplacement(owner)) {
                this.classInfo.markEntityFieldAccess("get", owner, name);
                this.mv.visitMethodInsn(182, owner, "_ebean_get_" + name, "()" + desc, false);
                return;
            }
            if (opcode == 181 && this.fieldAccessReplacement(owner)) {
                this.classInfo.markEntityFieldAccess("set", owner, name);
                this.mv.visitMethodInsn(182, owner, "_ebean_set_" + name, "(" + desc + ")V", false);
                return;
            }
            super.visitFieldInsn(opcode, owner, name, desc);
        }
    }

    private boolean fieldAccessReplacement(String owner) {
        return !this.classInfo.isEntityBean() && this.enhanceContext.isEnableEntityFieldAccess() && this.isOtherEntityClass(owner);
    }

    private boolean isOtherEntityClass(String owner) {
        return !this.classInfo.getClassName().equals(owner) && this.isEntityBean(owner);
    }
}

