/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.enhance.common;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import java.util.TreeSet;

public class SummaryInfo {
    private final List<String> loadedResources;
    private final Set<String> entities = new HashSet<String>();
    private final Set<String> queryBeans = new HashSet<String>();
    private final Set<String> queryBeanCallers = new HashSet<String>();
    private final Set<String> fieldAccessUsers = new HashSet<String>();
    private final Set<String> transactional = new HashSet<String>();

    SummaryInfo(List<String> loadedResources) {
        this.loadedResources = loadedResources;
    }

    SummaryInfo prepare() {
        for (String queryBean : this.queryBeans) {
            this.queryBeanCallers.remove(queryBean);
            this.queryBeanCallers.remove(queryBean + "$Companion");
        }
        return this;
    }

    public boolean isEmpty() {
        return this.entities.isEmpty() && this.queryBeans.isEmpty() && this.queryBeanCallers.isEmpty() && this.transactional.isEmpty();
    }

    public boolean hasEntities() {
        return !this.entities.isEmpty();
    }

    public boolean hasQueryBeans() {
        return !this.queryBeans.isEmpty();
    }

    public boolean hasTransactional() {
        return !this.transactional.isEmpty();
    }

    public boolean hasQueryCallers() {
        return !this.queryBeanCallers.isEmpty();
    }

    public boolean hasFieldAccess() {
        return !this.fieldAccessUsers.isEmpty();
    }

    public String toString() {
        return " entities:" + this.entities + " queryBeans:" + this.queryBeans + " tqb:" + this.transactional;
    }

    void addTransactional(String className) {
        this.transactional.add(className);
    }

    void addEntity(String className) {
        this.entities.add(className);
    }

    void addQueryBean(String className) {
        this.queryBeans.add(className);
    }

    void addQueryBeanCaller(String className) {
        this.queryBeanCallers.add(className);
    }

    void addFieldAccessUser(String className) {
        this.fieldAccessUsers.add(className);
    }

    private String summary(String prefix, Set<String> beans) {
        return new SumOut(beans).summary(prefix);
    }

    public List<String> loadedResources() {
        return this.loadedResources;
    }

    public String entities() {
        return this.summary("     Entities", this.entities);
    }

    public String queryBeans() {
        return this.summary("   QueryBeans", this.queryBeans);
    }

    public String queryCallers() {
        return this.summary("Query Callers", this.queryBeanCallers);
    }

    public String fieldAccess() {
        return this.summary(" Field Access", this.fieldAccessUsers);
    }

    public String transactional() {
        return this.summary("Transactional", this.transactional);
    }

    static class SumOut {
        private final Set<String> beans;
        private final Set<String> trimmedBeans;
        private String[] commonAsArray;
        private String commonPrefix;

        SumOut(Set<String> beans) {
            this.beans = beans;
            this.initCommonPrefix();
            this.trimmedBeans = this.trimmedBeans();
        }

        String sizeOut(int size) {
            return " (" + size + ")" + (size < 9 ? " " : "");
        }

        String summary(String prefix) {
            return prefix + this.sizeOut(this.beans.size()) + " pkgs[" + this.commonPrefix + "] beans" + this.trimmedBeans.toString();
        }

        String commonPackage() {
            return this.commonPrefix;
        }

        String beans() {
            return this.trimmedBeans.toString();
        }

        private void initCommonPrefix() {
            if (this.beans.isEmpty()) {
                this.commonPrefix = "";
            } else {
                for (String bean : this.beans) {
                    String beanPrefix = this.prefix(bean);
                    if (this.commonPrefix == null) {
                        this.commonPrefix = beanPrefix;
                        this.commonAsArray = beanPrefix.split("/");
                        continue;
                    }
                    this.common(beanPrefix);
                }
            }
        }

        private void common(String beanPrefix) {
            if (beanPrefix.equals(this.commonPrefix)) {
                return;
            }
            String[] elements = beanPrefix.split("/");
            int min = Math.min(this.commonAsArray.length, elements.length);
            for (int i = 0; i < min; ++i) {
                if (elements[i].equals(this.commonAsArray[i])) continue;
                this.commonFor(i);
                return;
            }
            if (this.commonAsArray.length != min) {
                this.commonFor(min);
            }
        }

        private void setCommonPrefix(String beanPrefix) {
            this.commonPrefix = beanPrefix;
            this.commonAsArray = beanPrefix.split("/");
        }

        private void commonFor(int pos) {
            StringJoiner joiner = new StringJoiner("/");
            for (int i = 0; i < pos; ++i) {
                joiner.add(this.commonAsArray[i]);
            }
            this.setCommonPrefix(joiner.toString());
        }

        String prefix(String bean) {
            int pos = bean.lastIndexOf(47);
            return pos == -1 ? bean : bean.substring(0, pos);
        }

        private Set<String> trimmedBeans() {
            if (this.beans.isEmpty()) {
                return this.beans;
            }
            TreeSet<String> temp = new TreeSet<String>();
            int trimLen = this.commonPrefix.length() + 1;
            if (trimLen == 1) {
                trimLen = 0;
            }
            for (String bean : this.beans) {
                if (bean.length() > trimLen) {
                    bean = bean.substring(trimLen);
                }
                temp.add(bean);
            }
            return temp;
        }
    }
}

