/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.enhance.transactional;

import io.ebean.enhance.asm.AnnotationVisitor;
import io.ebean.enhance.asm.ClassVisitor;
import io.ebean.enhance.asm.FieldVisitor;
import io.ebean.enhance.asm.Label;
import io.ebean.enhance.asm.MethodVisitor;
import io.ebean.enhance.common.AlreadyEnhancedException;
import io.ebean.enhance.common.AnnotationInfo;
import io.ebean.enhance.common.AnnotationInfoVisitor;
import io.ebean.enhance.common.ClassMeta;
import io.ebean.enhance.common.EnhanceContext;
import io.ebean.enhance.common.NoEnhancementRequiredException;
import io.ebean.enhance.common.VisitUtil;
import io.ebean.enhance.querybean.TypeQueryUtil;
import io.ebean.enhance.transactional.ConstructorMethodAdapter;
import io.ebean.enhance.transactional.MethodAdapter;
import io.ebean.enhance.transactional.StaticInitAdapter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ClassAdapterTransactional
extends ClassVisitor {
    private static final Logger logger = Logger.getLogger(ClassAdapterTransactional.class.getName());
    static final String QP_FIELD_PREFIX = "_$ebpq";
    static final String TX_FIELD_PREFIX = "_$ebpt";
    private static final String IO_EBEAN_FINDER = "io/ebean/Finder";
    private static final String $_COMPANION = "$Companion";
    private static final String INIT_PROFILE_LOCATIONS = "_$initProfileLocations";
    private static final String LKOTLIN_METADATA = "Lkotlin/Metadata;";
    private static final String _$EBP = "_$ebp";
    private static final String LIO_EBEAN_PROFILE_LOCATION = "Lio/ebean/ProfileLocation;";
    private final EnhanceContext enhanceContext;
    private final ClassLoader classLoader;
    private final ArrayList<ClassMeta> transactionalInterfaces = new ArrayList();
    private final EnhanceContext.ProfileLineNumberMode profileLineNumberMode;
    private AnnotationInfo classAnnotationInfo;
    private String className;
    private boolean markAsKotlin;
    private boolean existingStaticInitialiser;
    private boolean finder;
    private int queryProfileCount;
    private int transactionProfileCount;
    private final Map<Integer, String> txLabels = new LinkedHashMap<Integer, String>();
    private final Map<Integer, String> locationToMethodName = new HashMap<Integer, String>();
    private final Set<String> methodNames = new HashSet<String>();
    private final Set<String> overloadedMethodNames = new HashSet<String>();

    public ClassAdapterTransactional(ClassVisitor cv, ClassLoader classLoader, EnhanceContext context) {
        super(589824, cv);
        this.classLoader = classLoader;
        this.enhanceContext = context;
        this.profileLineNumberMode = context.profileLineMode();
    }

    public String className() {
        return this.className;
    }

    public boolean isLog(int level) {
        return this.enhanceContext.isLog(level);
    }

    public void log(String msg) {
        this.enhanceContext.log(this.className, msg);
    }

    boolean isQueryBean(String owner) {
        return this.enhanceContext.isQueryBean(owner, this.classLoader);
    }

    AnnotationInfo getClassAnnotationInfo() {
        return this.classAnnotationInfo;
    }

    AnnotationInfo getInterfaceTransactionalInfo(String methodName, String methodDesc) {
        AnnotationInfo interfaceAnnotationInfo = null;
        for (int i = 0; i < this.transactionalInterfaces.size(); ++i) {
            ClassMeta interfaceMeta = this.transactionalInterfaces.get(i);
            AnnotationInfo ai = interfaceMeta.interfaceTransactionalInfo(methodName, methodDesc);
            if (ai == null) continue;
            if (interfaceAnnotationInfo != null) {
                String msg = "Error in [" + this.className + "] searching the transactional interfaces [" + this.transactionalInterfaces + "] found more than one match for the transactional method:" + methodName + " " + methodDesc;
                logger.log(Level.SEVERE, msg);
                continue;
            }
            interfaceAnnotationInfo = ai;
            if (!this.isLog(4)) continue;
            this.log("inherit transactional from interface [" + interfaceMeta + "] method[" + methodName + " " + methodDesc + "]");
        }
        return interfaceAnnotationInfo;
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.className = name;
        if (TypeQueryUtil.isQueryBean(superName)) {
            throw new NoEnhancementRequiredException();
        }
        this.finder = superName.equals(IO_EBEAN_FINDER);
        int n = 1 + interfaces.length;
        String[] newInterfaces = new String[n];
        for (int i = 0; i < interfaces.length; ++i) {
            newInterfaces[i] = interfaces[i];
            if (newInterfaces[i].equals("io/ebean/bean/EnhancedTransactional")) {
                throw new AlreadyEnhancedException(name);
            }
            ClassMeta interfaceMeta = this.enhanceContext.interfaceMeta(newInterfaces[i], this.classLoader);
            if (interfaceMeta == null || !interfaceMeta.isTransactional()) continue;
            this.transactionalInterfaces.add(interfaceMeta);
            if (!this.isLog(6)) continue;
            this.log(" implements transactional interface " + interfaceMeta.description());
        }
        newInterfaces[newInterfaces.length - 1] = "io/ebean/bean/EnhancedTransactional";
        String newSignature = VisitUtil.signatureAppend(signature, "io/ebean/bean/EnhancedTransactional");
        super.visit(version, access, name, newSignature, superName, newInterfaces);
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        if (LKOTLIN_METADATA.equals(desc)) {
            this.markAsKotlin = true;
        }
        AnnotationVisitor av = super.visitAnnotation(desc, visible);
        if (desc.equals("Lio/ebean/annotation/Transactional;")) {
            this.classAnnotationInfo = new AnnotationInfo(null);
            return new AnnotationInfoVisitor(null, this.classAnnotationInfo, av);
        }
        return av;
    }

    @Override
    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        if (name.startsWith(_$EBP) && desc.equals(LIO_EBEAN_PROFILE_LOCATION)) {
            throw new AlreadyEnhancedException(this.className);
        }
        return super.visitField(access, name, desc, signature, value);
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        if (name.equals(INIT_PROFILE_LOCATIONS)) {
            throw new AlreadyEnhancedException(this.className);
        }
        if (name.equals("<init>")) {
            if (this.checkConstructorForProfileLocation(desc)) {
                if (this.isLog(7)) {
                    this.log("checking constructor, maybe add profile location for queries in className:" + this.className + " " + name + " [" + desc + "]");
                }
                return new ConstructorMethodAdapter(this, mv);
            }
            return mv;
        }
        if (name.equals("<clinit>")) {
            if (!this.enhanceContext.isEnableProfileLocation()) {
                return mv;
            }
            if (this.isLog(4)) {
                this.log("... <clinit> exists - adding call to _$initProfileLocations()");
            }
            this.existingStaticInitialiser = true;
            return new StaticInitAdapter(mv, access, name, desc, this.className);
        }
        return new MethodAdapter(this, mv, access, name, desc);
    }

    private boolean checkConstructorForProfileLocation(String desc) {
        return this.enhanceContext.isEnableProfileLocation() && !desc.startsWith("(Lio/ebean/Query;") && !this.kotlinCompanion();
    }

    private boolean kotlinCompanion() {
        return this.markAsKotlin && this.className.endsWith($_COMPANION);
    }

    @Override
    public void visitEnd() {
        if (this.queryProfileCount == 0 && this.transactionProfileCount == 0) {
            throw new NoEnhancementRequiredException(this.className);
        }
        if (this.isLog(4)) {
            this.log("queryCount:" + this.queryProfileCount + " txnCount:" + this.transactionProfileCount + " profileLocation:" + this.isEnableProfileLocation());
        }
        if (this.enhanceContext.isEnableProfileLocation()) {
            this.addStaticFieldDefinitions();
            this.addStaticFieldInitialisers();
            if (!this.existingStaticInitialiser) {
                if (this.isLog(5)) {
                    this.log("... add <clinit> to call _$initProfileLocations()");
                }
                this.addStaticInitialiser();
            }
        }
        if (this.transactionProfileCount > 0) {
            this.enhanceContext.summaryTransactional(this.className);
        } else {
            this.enhanceContext.summaryQueryBeanCaller(this.className);
        }
        super.visitEnd();
    }

    public void logEnhanced() {
        if (this.transactionProfileCount > 0) {
            this.log("enhanced transactional");
        } else {
            this.log("enhanced query bean caller");
        }
    }

    private void addStaticFieldDefinitions() {
        FieldVisitor fv;
        int i;
        for (i = 0; i < this.queryProfileCount; ++i) {
            fv = this.cv.visitField(this.enhanceContext.accPrivate() + 8, QP_FIELD_PREFIX + i, LIO_EBEAN_PROFILE_LOCATION, null, null);
            fv.visitEnd();
        }
        for (i = 0; i < this.transactionProfileCount; ++i) {
            fv = this.cv.visitField(this.enhanceContext.accPrivate() + 8, TX_FIELD_PREFIX + i, LIO_EBEAN_PROFILE_LOCATION, null, null);
            fv.visitEnd();
        }
    }

    private void addStaticFieldInitialisers() {
        Label l0;
        int i;
        MethodVisitor mv = this.cv.visitMethod(this.enhanceContext.accPrivate() + 8, INIT_PROFILE_LOCATIONS, "()V", null, null);
        mv.visitCode();
        boolean supportsProfileWithLine = this.enhanceContext.supportsProfileWithLine();
        for (i = 0; i < this.queryProfileCount; ++i) {
            l0 = new Label();
            mv.visitLabel(l0);
            mv.visitLineNumber(1, l0);
            String createMethod = supportsProfileWithLine && this.includeLineNumber(i) ? "createWithLine" : "create";
            mv.visitMethodInsn(184, "io/ebean/ProfileLocation", createMethod, "()Lio/ebean/ProfileLocation;", true);
            mv.visitFieldInsn(179, this.className, QP_FIELD_PREFIX + i, LIO_EBEAN_PROFILE_LOCATION);
        }
        for (i = 0; i < this.transactionProfileCount; ++i) {
            l0 = new Label();
            mv.visitLabel(l0);
            mv.visitLineNumber(2, l0);
            String label = this.getTxnLabel(i);
            if (supportsProfileWithLine) {
                mv.visitLdcInsn(label);
                mv.visitMethodInsn(184, "io/ebean/ProfileLocation", "create", "(Ljava/lang/String;)Lio/ebean/ProfileLocation;", true);
            } else {
                mv.visitIntInsn(16, 0);
                mv.visitLdcInsn(label);
                mv.visitMethodInsn(184, "io/ebean/ProfileLocation", "create", "(ILjava/lang/String;)Lio/ebean/ProfileLocation;", true);
            }
            mv.visitFieldInsn(179, this.className, TX_FIELD_PREFIX + i, LIO_EBEAN_PROFILE_LOCATION);
        }
        Label l1 = new Label();
        mv.visitLabel(l1);
        mv.visitLineNumber(3, l1);
        mv.visitInsn(177);
        mv.visitMaxs(1, 0);
        mv.visitEnd();
    }

    private String getTxnLabel(int i) {
        String label = this.txLabels.get(i);
        return label != null ? label : "";
    }

    private void addStaticInitialiser() {
        MethodVisitor mv = this.cv.visitMethod(8, "<clinit>", "()V", null, null);
        mv.visitCode();
        Label l0 = new Label();
        mv.visitLabel(l0);
        mv.visitLineNumber(4, l0);
        mv.visitMethodInsn(184, this.className, INIT_PROFILE_LOCATIONS, "()V", false);
        Label l1 = new Label();
        mv.visitLabel(l1);
        mv.visitLineNumber(5, l1);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    boolean fluidQueryBuilders() {
        return this.enhanceContext.fluidQueryBuilders();
    }

    boolean isEnableProfileLocation() {
        return this.enhanceContext.isEnableProfileLocation();
    }

    int nextQueryProfileLocation() {
        return this.queryProfileCount++;
    }

    int nextQueryProfileLocation(String methodName, String queryBeanType) {
        if (this.profileLineNumberMode == EnhanceContext.ProfileLineNumberMode.AUTO) {
            String key = methodName + queryBeanType;
            this.locationToMethodName.put(this.queryProfileCount, key);
            if (!this.methodNames.add(key)) {
                this.overloadedMethodNames.add(key);
            }
        }
        return this.queryProfileCount++;
    }

    private boolean includeLineNumber(int pos) {
        if (this.profileLineNumberMode == EnhanceContext.ProfileLineNumberMode.ALL) {
            return true;
        }
        String name = this.locationToMethodName.get(pos);
        return name != null && this.overloadedMethodNames.contains(name);
    }

    int nextTransactionLocation() {
        return this.transactionProfileCount++;
    }

    boolean isFinder() {
        return this.finder;
    }

    void putTxnLabel(int locationField, String txLabel) {
        this.txLabels.put(locationField, txLabel);
    }
}

