/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.enhance.common;

import io.ebean.enhance.Transformer;
import io.ebean.enhance.asm.MethodVisitor;
import io.ebean.enhance.common.AgentManifest;
import io.ebean.enhance.common.ArgParser;
import io.ebean.enhance.common.ClassBytesReader;
import io.ebean.enhance.common.ClassMeta;
import io.ebean.enhance.common.ClassMetaCache;
import io.ebean.enhance.common.ClassMetaReader;
import io.ebean.enhance.common.FilterEntityTransactional;
import io.ebean.enhance.common.FilterQueryBean;
import io.ebean.enhance.common.IgnoreClassHelper;
import io.ebean.enhance.common.PackageFilter;
import io.ebean.enhance.common.SummaryInfo;
import io.ebean.enhance.common.SysoutMessageOutput;
import io.ebean.enhance.entity.MessageOutput;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class EnhanceContext {
    private static final Logger logger = Logger.getLogger(EnhanceContext.class.getName());
    private final AgentManifest manifest;
    private final IgnoreClassHelper ignoreClassHelper;
    private final Map<String, String> agentArgsMap;
    private final ClassMetaReader reader;
    private final ClassBytesReader classBytesReader;
    private MessageOutput logout;
    private int logLevel;
    private final HashMap<String, ClassMeta> map = new HashMap();
    private final FilterEntityTransactional filterEntityTransactional;
    private final FilterQueryBean filterQueryBean;
    private final PackageFilter packageFilter;
    private boolean throwOnError;
    private final boolean enableProfileLocation;
    private final boolean enableEntityFieldAccess;
    private final ProfileLineNumberMode profileLineNumberMode;
    private final int accPublic;
    private final int accProtected;
    private final int accPrivate;
    private final int enhancementVersion;
    private SummaryInfo summaryInfo;

    public EnhanceContext(ClassBytesReader classBytesReader, String agentArgs, AgentManifest manifest) {
        this(classBytesReader, agentArgs, manifest, new ClassMetaCache());
    }

    public EnhanceContext(ClassBytesReader classBytesReader, String agentArgs, AgentManifest manifest, ClassMetaCache metaCache) {
        String debugValue;
        this.manifest = manifest;
        this.enableProfileLocation = manifest.isEnableProfileLocation();
        this.enableEntityFieldAccess = manifest.isEnableEntityFieldAccess();
        this.profileLineNumberMode = manifest.profileLineMode();
        this.accPublic = manifest.accPublic();
        this.accProtected = manifest.accProtected();
        this.accPrivate = manifest.accPrivate();
        this.agentArgsMap = ArgParser.parse(agentArgs);
        this.enhancementVersion = this.versionOf(manifest);
        this.filterEntityTransactional = new FilterEntityTransactional(manifest);
        this.filterQueryBean = new FilterQueryBean(manifest);
        this.ignoreClassHelper = new IgnoreClassHelper();
        this.logout = new SysoutMessageOutput(System.out);
        this.classBytesReader = classBytesReader;
        this.reader = new ClassMetaReader(this, metaCache);
        this.packageFilter = this.initPackageFilter(this.agentArgsMap.get("packages"));
        if (manifest.debugLevel() > -1) {
            this.logLevel = manifest.debugLevel();
        }
        if ((debugValue = this.agentArgsMap.get("debug")) != null) {
            try {
                this.logLevel = Integer.parseInt(debugValue);
            }
            catch (NumberFormatException e) {
                logger.log(Level.WARNING, "Agent debug argument [" + debugValue + "] is not an int?");
            }
        }
        if (this.logLevel > 0 || this.propertyBoolean("printversion", false)) {
            System.out.println("ebean-agent version:" + Transformer.getVersion() + " enhancement:" + this.enhancementVersion + " resources:" + manifest.loadedResources());
        }
    }

    private PackageFilter initPackageFilter(String packages) {
        return packages == null ? null : new PackageFilter(packages);
    }

    private int versionOf(AgentManifest manifest) {
        String ver = this.agentArgsMap.get("version");
        if (ver != null) {
            return Integer.parseInt(ver);
        }
        return manifest.enhancementVersion();
    }

    public void withClassLoader(ClassLoader loader) {
        if (this.manifest.readManifest(loader) && this.logLevel > 1) {
            this.log(null, "loaded entity packages: " + this.manifest.entityPackages());
        }
    }

    public void setLogLevel(int logLevel) {
        this.logLevel = logLevel;
    }

    @Deprecated
    public String getPackagesSummary() {
        return this.packagesSummary();
    }

    public String packagesSummary() {
        return "packages entity:" + this.entityPackages() + "  transactional:" + this.transactionalPackages() + "  querybean:" + this.querybeanPackages() + "  profileLocation:" + this.enableProfileLocation + "  version:" + this.enhancementVersion;
    }

    public Set<String> entityPackages() {
        return this.manifest.entityPackages();
    }

    public Set<String> transactionalPackages() {
        return this.manifest.transactionalPackages();
    }

    public Set<String> querybeanPackages() {
        return this.manifest.querybeanPackages();
    }

    public byte[] classBytes(String className, ClassLoader classLoader) {
        return this.classBytesReader.getClassBytes(className, classLoader);
    }

    public boolean isEntityBean(String owner) {
        return this.manifest.isDetectEntityBean(owner);
    }

    public boolean isQueryBean(String owner, ClassLoader classLoader) {
        if (this.manifest.isDetectQueryBean(owner)) {
            try {
                ClassMeta classMeta = this.reader.get(true, owner, classLoader);
                if (classMeta == null) {
                    return true;
                }
                return classMeta.isQueryBean();
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return false;
    }

    private String property(String key) {
        return this.agentArgsMap.get(key.toLowerCase());
    }

    private boolean propertyBoolean(String key, boolean defaultValue) {
        String s = this.property(key);
        if (s == null) {
            return defaultValue;
        }
        return s.trim().equalsIgnoreCase("true");
    }

    public boolean isEnableEntityFieldAccess() {
        return this.enableEntityFieldAccess;
    }

    public boolean isEnableProfileLocation() {
        return this.enableProfileLocation;
    }

    public boolean detectEntityTransactionalEnhancement(String className) {
        return this.filterEntityTransactional.detectEnhancement(className);
    }

    public boolean detectQueryBeanEnhancement(String className) {
        return this.filterQueryBean.detectEnhancement(className);
    }

    public boolean isIgnoreClass(String className) {
        if (this.packageFilter != null && this.packageFilter.ignore(className)) {
            return true;
        }
        return this.ignoreClassHelper.isIgnoreClass(className);
    }

    public void setLogout(MessageOutput logout) {
        this.logout = logout;
    }

    public ClassMeta createClassMeta() {
        return new ClassMeta(this, this.logLevel, this.logout);
    }

    public ClassMeta superMeta(String superClassName, ClassLoader classLoader) {
        try {
            if (this.isIgnoreClass(superClassName)) {
                return null;
            }
            return this.reader.get(false, superClassName, classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public ClassMeta interfaceMeta(String interfaceClassName, ClassLoader classLoader) {
        try {
            if (this.isIgnoreClass(interfaceClassName)) {
                return null;
            }
            return this.reader.get(true, interfaceClassName, classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public void addClassMeta(ClassMeta meta) {
        this.map.put(meta.className(), meta);
    }

    public ClassMeta get(String className) {
        return this.map.get(className);
    }

    public void log(int level, String className, String msg) {
        if (this.logLevel >= level) {
            this.log(className, msg);
        }
    }

    public void log(String className, String msg) {
        if (className != null) {
            msg = "cls: " + className + "  msg: " + msg;
        }
        this.logout.println("ebean-enhance> " + msg);
    }

    public boolean isLog(int level) {
        return this.logLevel >= level;
    }

    public void log(Throwable e) {
        e.printStackTrace(new PrintStream(new ByteArrayOutputStream()){

            @Override
            public void print(String message) {
                EnhanceContext.this.logout.println(message);
            }

            @Override
            public void println(String message) {
                EnhanceContext.this.logout.println(message);
            }
        });
    }

    public int logLevel() {
        return this.logLevel;
    }

    public boolean isTransientInit() {
        return this.manifest.isTransientInit();
    }

    public boolean isTransientInitThrowError() {
        return this.manifest.isTransientInitThrowError();
    }

    public boolean isTransientInternalFields() {
        return this.manifest.isTransientInternalFields();
    }

    public boolean isCheckNullManyFields() {
        return this.manifest.isCheckNullManyFields();
    }

    public boolean isAllowNullableDbArray() {
        return this.manifest.isAllowNullableDbArray();
    }

    public boolean isThrowOnError() {
        return this.throwOnError;
    }

    public void setThrowOnError(boolean throwOnError) {
        this.throwOnError = throwOnError;
    }

    public void collectSummary() {
        this.summaryInfo = new SummaryInfo(this.manifest.loadedResources());
    }

    public void summaryTransactional(String className) {
        if (this.summaryInfo != null) {
            this.summaryInfo.addTransactional(className);
        }
    }

    public void summaryEntity(String className) {
        if (this.summaryInfo != null) {
            this.summaryInfo.addEntity(className);
        }
    }

    public void summaryQueryBean(String className) {
        if (this.summaryInfo != null) {
            this.summaryInfo.addQueryBean(className);
        }
    }

    public void summaryQueryBeanCaller(String className) {
        if (this.summaryInfo != null) {
            this.summaryInfo.addQueryBeanCaller(className);
        }
    }

    public void summaryFieldAccessUser(String className) {
        if (this.summaryInfo != null) {
            this.summaryInfo.addFieldAccessUser(className);
        }
    }

    @Deprecated
    public SummaryInfo getSummaryInfo() {
        return this.summaryInfo();
    }

    public SummaryInfo summaryInfo() {
        return this.summaryInfo.prepare();
    }

    public int accPublic() {
        return this.accPublic;
    }

    public int accProtected() {
        return this.accProtected;
    }

    public int accPrivate() {
        return this.accPrivate;
    }

    public boolean isToManyGetField() {
        return this.enhancementVersion > 128;
    }

    public boolean isEnhancedToString() {
        return this.enhancementVersion > 132;
    }

    public String interceptNew() {
        return this.enhancementVersion >= 140 ? "io/ebean/bean/InterceptReadWrite" : "io/ebean/bean/EntityBeanIntercept";
    }

    public void visitMethodInsnIntercept(MethodVisitor mv, String name, String desc) {
        mv.visitMethodInsn(this.interceptInvoke(), "io/ebean/bean/EntityBeanIntercept", name, desc, this.interceptIface());
    }

    private int interceptInvoke() {
        return this.enhancementVersion >= 140 ? 185 : 182;
    }

    private boolean interceptIface() {
        return this.enhancementVersion >= 140;
    }

    public boolean interceptAddReadOnly() {
        return this.enhancementVersion >= 141;
    }

    public boolean supportsProfileWithLine() {
        return this.enhancementVersion >= 143;
    }

    public boolean improvedQueryBeans() {
        return this.enhancementVersion >= 145;
    }

    public boolean fluidQueryBuilders() {
        return this.enhancementVersion >= 148;
    }

    public boolean useAopTransactionScope() {
        return this.enhancementVersion >= 149;
    }

    public ProfileLineNumberMode profileLineMode() {
        return this.profileLineNumberMode;
    }

    public static enum ProfileLineNumberMode {
        AUTO,
        NONE,
        ALL;

    }
}

