/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.enhance.ant;

import io.ebean.enhance.EnhancementException;
import io.ebean.enhance.Transformer;
import io.ebean.enhance.ant.StringReplace;
import io.ebean.enhance.ant.TransformationListener;
import io.ebean.enhance.common.InputStreamTransform;
import java.io.File;
import java.io.IOException;
import java.lang.instrument.IllegalClassFormatException;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

public class OfflineFileTransform {
    protected final InputStreamTransform inputStreamTransform;
    protected final String inDir;
    protected TransformationListener listener;
    private final int logLevel;

    public OfflineFileTransform(Transformer transformer, ClassLoader classLoader, String inDir) {
        this.inputStreamTransform = new InputStreamTransform(transformer, classLoader);
        this.logLevel = transformer.getLogLevel();
        this.inDir = inDir = this.trimSlash(inDir);
    }

    public void setListener(TransformationListener v) {
        this.listener = v;
    }

    private String trimSlash(String dir) {
        if (dir.endsWith("/")) {
            return dir.substring(0, dir.length() - 1);
        }
        return dir;
    }

    public void process(String packageNames) {
        if (packageNames == null) {
            this.processPackage("");
            return;
        }
        LinkedHashSet<String> pkgNames = new LinkedHashSet<String>();
        Collections.addAll(pkgNames, packageNames.split(","));
        this.process(pkgNames);
    }

    public void process(Set<String> packageNames) {
        if (packageNames == null || packageNames.isEmpty()) {
            this.inputStreamTransform.log(2, "processing all directories (as no explicit packages)");
            this.processPackage("");
            return;
        }
        for (String pkgName : packageNames) {
            String pkg = pkgName.trim().replace('.', '/');
            if (pkg.endsWith("**")) {
                pkg = pkg.substring(0, pkg.length() - 2);
            } else if (pkg.endsWith("*")) {
                pkg = pkg.substring(0, pkg.length() - 1);
            }
            pkg = this.trimSlash(pkg);
            this.processPackage(pkg);
        }
    }

    private void processPackage(String dir) {
        this.inputStreamTransform.log(3, "transform> pkg: " + dir);
        String dirPath = this.inDir + "/" + dir;
        File d = new File(dirPath);
        if (!d.exists()) {
            throw new RuntimeException("File not found " + dirPath + "  currentDir:" + new File(".").getAbsolutePath());
        }
        File[] files = d.listFiles();
        if (files != null) {
            for (File file : files) {
                try {
                    if (file.isDirectory()) {
                        String subDir = dir + "/" + file.getName();
                        this.processPackage(subDir);
                        continue;
                    }
                    String fileName = file.getName();
                    if (fileName.endsWith(".java")) {
                        System.err.println("Expecting a .class file but got " + fileName + " ... ignoring");
                        continue;
                    }
                    if (!fileName.endsWith(".class")) continue;
                    this.transformFile(file);
                }
                catch (Exception e) {
                    throw new RuntimeException("Error transforming file " + file.getName(), e);
                }
            }
        } else {
            throw new RuntimeException("Can't read directory " + d.getName());
        }
    }

    private void transformFile(File file) throws IOException, IllegalClassFormatException {
        String className = this.getClassName(file);
        try {
            byte[] result = this.inputStreamTransform.transform(className, file);
            if (result != null) {
                InputStreamTransform.writeBytes(result, file);
                if (this.listener != null && this.logLevel > 0) {
                    this.listener.logEvent("Enhanced " + file);
                }
            }
        }
        catch (EnhancementException e) {
            if (this.listener != null) {
                this.listener.logError("Error enhancing class " + className + " " + e.getMessage());
            }
            throw e;
        }
    }

    private String getClassName(File file) {
        String path = file.getPath();
        path = path.substring(this.inDir.length() + 1);
        path = path.substring(0, path.length() - ".class".length());
        return StringReplace.replace(path, "\\", "/");
    }
}

