/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.enhance.entity;

import io.ebean.enhance.asm.Label;
import io.ebean.enhance.asm.MethodVisitor;
import io.ebean.enhance.asm.Opcodes;
import io.ebean.enhance.common.ClassMeta;
import io.ebean.enhance.entity.CapturedInitCode;
import io.ebean.enhance.entity.DeferredCode;
import java.util.ArrayList;
import java.util.List;

final class ConstructorDeferredCode
implements Opcodes {
    private static final ALoad ALOAD_INSTRUCTION = new ALoad();
    private static final Dup DUP_INSTRUCTION = new Dup();
    private static final Iconst0 ICONST0_INSTRUCTION = new Iconst0();
    private final ClassMeta meta;
    private final MethodVisitor mv;
    private final List<DeferredCode> codes = new ArrayList<DeferredCode>();
    private State state = State.UNSET;
    private String stateInitialiseType;

    ConstructorDeferredCode(ClassMeta meta, MethodVisitor mv) {
        this.meta = meta;
        this.mv = mv;
    }

    boolean deferVisitVarInsn(int opcode, int var) {
        if (this.state == State.KT_ICONST && opcode == 54) {
            this.codes.add(new Istore(var));
            this.state = State.ALOAD;
            return true;
        }
        this.flush();
        if (opcode == 25 && var == 0) {
            this.codes.add(ALOAD_INSTRUCTION);
            this.state = State.ALOAD;
            return true;
        }
        if (opcode == 25) {
            this.state = State.ALOAD;
        }
        return false;
    }

    boolean deferVisitTypeInsn(int opcode, String type) {
        if (opcode == 187 && this.stateAload()) {
            this.codes.add(new NewCollection(type));
            this.state = State.NEW_COLLECTION;
            return true;
        }
        if (opcode == 192 && this.stateInvokeSpecial()) {
            this.codes.add(new CheckCastCollection(type));
            this.state = State.KT_CHECKCAST;
            return true;
        }
        this.flush();
        return false;
    }

    boolean deferVisitInsn(int opcode) {
        if (opcode == 3 && this.stateAload()) {
            this.codes.add(ICONST0_INSTRUCTION);
            this.state = State.KT_ICONST;
            return true;
        }
        if (opcode == 89 && this.stateNewCollection()) {
            this.codes.add(DUP_INSTRUCTION);
            this.state = State.DUP;
            return true;
        }
        this.flush();
        return false;
    }

    boolean deferVisitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
        if (opcode == 183 && this.stateDup() && this.isNoArgInit(name, desc)) {
            this.codes.add(new NoArgInit(opcode, owner, name, desc, itf));
            this.state = State.INVOKE_SPECIAL;
            this.stateInitialiseType = owner;
            return true;
        }
        if (opcode == 184 && this.stateAload()) {
            if (this.kotlinEmptyList(owner, name, desc) || this.emptyList(owner, name, desc)) {
                this.codes.add(new NoArgInit(opcode, owner, name, desc, itf));
                this.state = State.EMPTY;
                this.stateInitialiseType = "java/util/ArrayList";
                return true;
            }
            if (this.emptySet(owner, name, desc)) {
                this.codes.add(new NoArgInit(opcode, owner, name, desc, itf));
                this.state = State.EMPTY;
                this.stateInitialiseType = "java/util/LinkedHashSet";
                return true;
            }
            if (this.emptyMap(owner, name, desc)) {
                this.codes.add(new NoArgInit(opcode, owner, name, desc, itf));
                this.state = State.EMPTY;
                this.stateInitialiseType = "java/util/LinkedHashMap";
                return true;
            }
        }
        this.flush();
        this.state = State.MAYBE_UNSUPPORTED;
        return false;
    }

    private boolean isNoArgInit(String name, String desc) {
        return name.equals("<init>") && desc.equals("()V");
    }

    private boolean emptyList(String owner, String name, String desc) {
        return desc.equals("()Ljava/util/List;") && (owner.equals("java/util/List") && name.equals("of") || owner.equals("java/util/Collections") && name.equals("emptyList"));
    }

    private boolean emptySet(String owner, String name, String desc) {
        return desc.equals("()Ljava/util/Set;") && (owner.equals("java/util/Set") && name.equals("of") || owner.equals("java/util/Collections") && name.equals("emptySet"));
    }

    private boolean emptyMap(String owner, String name, String desc) {
        return desc.equals("()Ljava/util/Map;") && (owner.equals("java/util/Map") && name.equals("of") || owner.equals("java/util/Collections") && name.equals("emptyMap"));
    }

    private boolean kotlinEmptyList(String owner, String name, String desc) {
        return owner.equals("kotlin/collections/CollectionsKt") && name.equals("emptyList") && desc.equals("()Ljava/util/List;");
    }

    boolean consumeVisitFieldInsn(int opcode, String owner, String name, String desc) {
        if (opcode == 181) {
            if (this.meta.isConsumeInitMany(name) && this.unsupportedInitialisation()) {
                this.meta.addUnsupportedInitMany(name);
                this.flush();
                return false;
            }
            if (this.stateConsumeDeferred()) {
                if (this.meta.isConsumeInitMany(name) && this.isConsumeManyType()) {
                    if (this.meta.isLog(3)) {
                        this.meta.log("... consumed init of many: " + name);
                    }
                    this.state = State.UNSET;
                    this.codes.clear();
                    return true;
                }
                if (this.meta.isInitTransient(name)) {
                    if (this.meta.isLog(3)) {
                        this.meta.log("... init transient: " + name + " type: " + this.stateInitialiseType);
                    }
                    this.meta.addTransientInit(new CapturedInitCode(this.codes, opcode, owner, name, desc, this.stateInitialiseType));
                } else if (this.meta.isTransient(name)) {
                    this.meta.addUnsupportedTransientInit(name);
                }
            } else if (this.meta.isTransient(name)) {
                this.meta.addUnsupportedTransientInit(name);
            }
        }
        this.flush();
        if (opcode == 180) {
            this.state = State.GETFIELD;
        }
        return false;
    }

    private boolean unsupportedInitialisation() {
        if (this.state == State.ALOAD || this.state == State.GETFIELD) {
            return false;
        }
        return this.state == State.MAYBE_UNSUPPORTED || this.state == State.UNSET || this.state == State.INVOKE_SPECIAL && !this.isConsumeManyType();
    }

    boolean consumeVisitLabel(Label label) {
        if (this.state == State.KT_CHECKCAST) {
            this.codes.add(new DeferredLabel(label));
            this.state = State.KT_LABEL;
            return true;
        }
        return false;
    }

    public boolean consumeVisitLineNumber(int line, Label start) {
        if (this.state == State.KT_LABEL) {
            this.codes.add(new DeferredLineNumber(line, start));
            this.state = State.INVOKE_SPECIAL;
            return true;
        }
        return false;
    }

    void flush() {
        this.state = State.UNSET;
        if (!this.codes.isEmpty()) {
            for (DeferredCode code : this.codes) {
                if (this.meta.isLog(4)) {
                    this.meta.log("... flush deferred: " + code);
                }
                code.write(this.mv);
            }
            this.codes.clear();
        }
    }

    private boolean stateAload() {
        return this.state == State.ALOAD;
    }

    private boolean stateNewCollection() {
        return this.state == State.NEW_COLLECTION;
    }

    private boolean stateDup() {
        return this.state == State.DUP;
    }

    private boolean stateInvokeSpecial() {
        return this.state == State.INVOKE_SPECIAL;
    }

    private boolean stateConsumeDeferred() {
        return this.state == State.INVOKE_SPECIAL || this.state == State.KT_CHECKCAST || this.state == State.EMPTY;
    }

    private boolean isConsumeManyType() {
        return "java/util/ArrayList".equals(this.stateInitialiseType) || "java/util/LinkedList".equals(this.stateInitialiseType) || "java/util/LinkedHashSet".equals(this.stateInitialiseType) || "java/util/HashSet".equals(this.stateInitialiseType) || "java/util/LinkedHashMap".equals(this.stateInitialiseType) || "java/util/HashMap".equals(this.stateInitialiseType);
    }

    static enum State {
        UNSET,
        ALOAD,
        KT_ICONST,
        NEW_COLLECTION,
        DUP,
        INVOKE_SPECIAL,
        KT_CHECKCAST,
        KT_LABEL,
        EMPTY,
        GETFIELD,
        MAYBE_UNSUPPORTED;

    }

    private static class Istore
    implements DeferredCode {
        private final int value;

        Istore(int value) {
            this.value = value;
        }

        @Override
        public void write(MethodVisitor mv) {
            mv.visitVarInsn(54, this.value);
        }
    }

    private static class ALoad
    implements DeferredCode {
        private ALoad() {
        }

        @Override
        public void write(MethodVisitor mv) {
            mv.visitVarInsn(25, 0);
        }
    }

    private static class NewCollection
    implements DeferredCode {
        final String type;

        NewCollection(String type) {
            this.type = type;
        }

        @Override
        public void write(MethodVisitor mv) {
            mv.visitTypeInsn(187, this.type);
        }
    }

    private static class CheckCastCollection
    implements DeferredCode {
        final String type;

        CheckCastCollection(String type) {
            this.type = type;
        }

        @Override
        public void write(MethodVisitor mv) {
            mv.visitTypeInsn(192, this.type);
        }
    }

    private static class Iconst0
    implements DeferredCode {
        private Iconst0() {
        }

        @Override
        public void write(MethodVisitor mv) {
            mv.visitInsn(3);
        }
    }

    private static class Dup
    implements DeferredCode {
        private Dup() {
        }

        @Override
        public void write(MethodVisitor mv) {
            mv.visitInsn(89);
        }
    }

    private static class NoArgInit
    implements DeferredCode {
        final int opcode;
        final String owner;
        final String name;
        final String desc;
        final boolean itf;

        NoArgInit(int opcode, String owner, String name, String desc, boolean itf) {
            this.opcode = opcode;
            this.owner = owner;
            this.name = name;
            this.desc = desc;
            this.itf = itf;
        }

        @Override
        public void write(MethodVisitor mv) {
            mv.visitMethodInsn(this.opcode, this.owner, this.name, this.desc, this.itf);
        }
    }

    private static class DeferredLabel
    implements DeferredCode {
        private final Label label;

        DeferredLabel(Label label) {
            this.label = label;
        }

        @Override
        public void write(MethodVisitor mv) {
            mv.visitLabel(this.label);
        }
    }

    private static class DeferredLineNumber
    implements DeferredCode {
        private final int line;
        private final Label label;

        DeferredLineNumber(int line, Label label) {
            this.line = line;
            this.label = label;
        }

        @Override
        public void write(MethodVisitor mv) {
            mv.visitLineNumber(this.line, this.label);
        }
    }
}

