/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.enhance.querybean;

import java.util.HashSet;
import java.util.Set;

public class DetectQueryBean {
    private final Set<String> entityPackages = new HashSet<String>();

    public void addAll(Set<String> rawEntityPackages) {
        for (String rawEntityPackage : rawEntityPackages) {
            this.entityPackages.add(DetectQueryBean.convert(rawEntityPackage));
        }
    }

    private static String convert(String pkg) {
        if ((pkg = pkg.trim()).endsWith("*")) {
            pkg = pkg.substring(0, pkg.length() - 1);
        }
        if (pkg.endsWith(".query")) {
            pkg = pkg.substring(0, pkg.length() - 6);
        }
        return (pkg = pkg.replace('.', '/')).endsWith("/") ? pkg : pkg + "/";
    }

    public String toString() {
        return this.entityPackages.toString();
    }

    public boolean isEmpty() {
        return this.entityPackages.isEmpty();
    }

    public boolean isQueryBean(String owner) {
        String suffix;
        int subPackagePos = owner.lastIndexOf("/query/");
        if (subPackagePos > -1 && this.isQueryBeanSuffix(suffix = owner.substring(subPackagePos))) {
            String domainPackage = owner.substring(0, subPackagePos + 1);
            return this.isEntityBeanPackage(domainPackage);
        }
        return false;
    }

    private boolean isEntityBeanPackage(String domainPackage) {
        for (String pkg : this.entityPackages) {
            if (!domainPackage.startsWith(pkg)) continue;
            return true;
        }
        return false;
    }

    public boolean isEntityBean(String owner) {
        return this.isEntityBeanPackage(owner);
    }

    private boolean isQueryBeanSuffix(String suffix) {
        return suffix.startsWith("/query/Q") || suffix.startsWith("/query/assoc/Q");
    }
}

