/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.config;

import io.ebean.config.DatabaseConfig;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;

public class ClassLoadConfig {
    protected final ClassLoaderContext context;

    public ClassLoadConfig() {
        this(null);
    }

    public ClassLoadConfig(ClassLoader classLoader) {
        this.context = new ClassLoaderContext(classLoader);
    }

    public boolean isJodaTimePresent() {
        return this.isPresent("org.joda.time.LocalDateTime");
    }

    public boolean isJavaxValidationAnnotationsPresent() {
        return this.isPresent("javax.validation.constraints.NotNull");
    }

    public boolean isJakartaValidationAnnotationsPresent() {
        return this.isPresent("jakarta.validation.constraints.NotNull");
    }

    public boolean isJavaxPostConstructPresent() {
        return this.isPresent("javax.annotation.PostConstruct");
    }

    public boolean isJacksonAnnotationsPresent() {
        return this.isPresent("com.fasterxml.jackson.annotation.JsonIgnore");
    }

    public boolean isJacksonCorePresent() {
        return this.isPresent("com.fasterxml.jackson.core.JsonParser");
    }

    public boolean isJacksonObjectMapperPresent() {
        return this.isPresent("com.fasterxml.jackson.databind.ObjectMapper");
    }

    public Object newInstance(String className) {
        try {
            Class<?> cls = this.forName(className);
            return cls.newInstance();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error constructing " + className, e);
        }
    }

    public Enumeration<URL> getResources(String name) throws IOException {
        return this.context.getResources(name);
    }

    public boolean isPresent(String className) {
        try {
            this.forName(className);
            return true;
        }
        catch (Throwable ex) {
            return false;
        }
    }

    protected Class<?> forName(String name) throws ClassNotFoundException {
        return this.context.forName(name);
    }

    public ClassLoader getClassLoader() {
        return this.context.getClassLoader();
    }

    protected static class ClassLoaderContext {
        protected final ClassLoader preferredLoader;
        protected final ClassLoader contextLoader;
        protected final ClassLoader callerLoader;

        ClassLoaderContext(ClassLoader preferredLoader) {
            this.preferredLoader = preferredLoader;
            this.callerLoader = DatabaseConfig.class.getClassLoader();
            this.contextLoader = this.contextLoader();
        }

        ClassLoader contextLoader() {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            return loader != null ? loader : this.callerLoader;
        }

        Enumeration<URL> getResources(String name) throws IOException {
            if (this.preferredLoader != null) {
                return this.preferredLoader.getResources(name);
            }
            return this.contextLoader().getResources(name);
        }

        Class<?> forName(String name) throws ClassNotFoundException {
            if (this.preferredLoader != null) {
                return this.classForName(name, this.preferredLoader);
            }
            try {
                return this.classForName(name, this.contextLoader);
            }
            catch (ClassNotFoundException e) {
                if (this.callerLoader == this.contextLoader) {
                    throw e;
                }
                return this.classForName(name, this.callerLoader);
            }
        }

        Class<?> classForName(String name, ClassLoader classLoader) throws ClassNotFoundException {
            return Class.forName(name, true, classLoader);
        }

        ClassLoader getClassLoader() {
            return this.preferredLoader != null ? this.preferredLoader : this.contextLoader;
        }
    }
}

