/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.config.dbplatform.h2;

import io.ebean.config.dbplatform.AbstractDbEncrypt;
import io.ebean.config.dbplatform.DbEncryptFunction;

public class H2DbEncrypt
extends AbstractDbEncrypt {
    public H2DbEncrypt() {
        this.varcharEncryptFunction = new H2VarcharFunction();
        this.dateEncryptFunction = new H2DateFunction();
    }

    @Override
    public boolean isBindEncryptDataFirst() {
        return false;
    }

    private static class H2VarcharFunction
    implements DbEncryptFunction {
        private H2VarcharFunction() {
        }

        @Override
        public String getDecryptSql(String columnWithTableAlias) {
            return "TRIM(CHAR(0) FROM UTF8TOSTRING(DECRYPT('AES', STRINGTOUTF8(?), " + columnWithTableAlias + ")))";
        }

        @Override
        public String getEncryptBindSql() {
            return "ENCRYPT('AES', STRINGTOUTF8(?), STRINGTOUTF8(?))";
        }
    }

    private static class H2DateFunction
    implements DbEncryptFunction {
        private H2DateFunction() {
        }

        @Override
        public String getDecryptSql(String columnWithTableAlias) {
            return "PARSEDATETIME(TRIM(CHAR(0) FROM UTF8TOSTRING(DECRYPT('AES', STRINGTOUTF8(?), " + columnWithTableAlias + "))),'yyyyMMdd')";
        }

        @Override
        public String getEncryptBindSql() {
            return "ENCRYPT('AES', STRINGTOUTF8(?), STRINGTOUTF8(FORMATDATETIME(?,'yyyyMMdd')))";
        }
    }
}

