/*
 * Decompiled with CFR 0.152.
 */
package io.ebean;

import io.ebean.DB;
import io.ebean.Database;
import io.ebean.Query;
import io.ebean.Transaction;
import io.ebean.UpdateQuery;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class BeanFinder<I, T> {
    protected final Database server;
    protected final Class<T> type;

    protected BeanFinder(Class<T> type, Database server) {
        this.type = type;
        this.server = server;
    }

    public Database db() {
        return this.server;
    }

    public Transaction currentTransaction() {
        return this.db().currentTransaction();
    }

    public void flush() {
        this.db().flush();
    }

    public Database db(String server) {
        return DB.byName(server);
    }

    @Nonnull
    public T ref(I id) {
        return this.db().reference(this.type, id);
    }

    @Nullable
    public T findById(I id) {
        return this.db().find(this.type, id);
    }

    @Nullable
    public Optional<T> findByIdOrEmpty(I id) {
        return this.db().find(this.type).setId(id).findOneOrEmpty();
    }

    public void deleteById(I id) {
        this.db().delete(this.type, id);
    }

    @Nonnull
    public List<T> findAll() {
        return this.query().findList();
    }

    protected UpdateQuery<T> updateQuery() {
        return this.db().update(this.type);
    }

    protected Query<T> query() {
        return this.db().find(this.type);
    }

    protected Query<T> nativeSql(String nativeSql) {
        return this.db().findNative(this.type, nativeSql);
    }

    protected Query<T> query(String ormQuery) {
        return this.db().createQuery(this.type, ormQuery);
    }
}

